/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.renderer;

import com.shavenpuppy.jglib.MultiBuffer;
import com.shavenpuppy.jglib.algorithms.RadixSort;
import com.shavenpuppy.jglib.opengl.GL;
import com.shavenpuppy.jglib.opengl.nvidia.GLFence;
import com.shavenpuppy.jglib.renderer.ShadedTriangle;
import com.shavenpuppy.jglib.renderer.Shader;
import com.shavenpuppy.jglib.renderer.State;
import com.shavenpuppy.jglib.renderer.Triangle;
import com.shavenpuppy.jglib.util.ObjectList;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.prefs.Preferences;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;

public final class Renderer {
    private boolean brokenDrivers;
    private final int maxTriangles;
    private final int numStateIndices;
    private final State[] currentState;
    private final State[] copyState;
    private final State[] oldState;
    private final Triangle[] triangle;
    private final Shader[] shader;
    private final ShadedTriangle[] shadedTriangle;
    private final ShadedTriangle[] sortedTriangle;
    private int sortedTriangleCount;
    private int numTriangles;
    private int numShadedTriangles;
    private final RadixSort sort = new RadixSort();
    private final int[][] sortIndex;
    private final int[] adjacency;
    private final ArrayList stateLists = new ArrayList(256);
    private int numStateLists;
    private final MultiBuffer indexBuf;
    private GLFence fence;
    private static final boolean DEBUG = false;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.shavenpuppy.jglib.renderer.Renderer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public Renderer(int maxTriangles, int numStateIndices) throws Exception {
        Class<?> clazz;
        this.maxTriangles = maxTriangles;
        this.numStateIndices = numStateIndices;
        this.triangle = new Triangle[maxTriangles];
        this.shader = new Shader[maxTriangles];
        this.shadedTriangle = new ShadedTriangle[maxTriangles];
        this.sortedTriangle = new ShadedTriangle[maxTriangles];
        int i = 0;
        while (i < maxTriangles) {
            this.shadedTriangle[i] = new ShadedTriangle();
            ++i;
        }
        this.sortIndex = new int[numStateIndices][];
        i = 0;
        while (i < numStateIndices) {
            this.sortIndex[i] = new int[maxTriangles];
            ++i;
        }
        this.adjacency = new int[maxTriangles];
        this.currentState = new State[numStateIndices];
        this.copyState = new State[numStateIndices];
        this.oldState = new State[numStateIndices];
        this.indexBuf = new MultiBuffer(4 * maxTriangles * 3);
        if (GLContext.GL_NV_vertex_array_range || GLContext.GL_NV_vertex_array_range2) {
            this.fence = new GLFence();
            this.fence.create();
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("com.shavenpuppy.jglib.renderer.Renderer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Preferences prefs = Preferences.systemNodeForPackage(clazz);
        this.brokenDrivers = Boolean.valueOf(prefs.get("brokendrivers", "false"));
        if (this.brokenDrivers) {
            System.out.println("Broken driver flag set.");
        }
    }

    public void add(Triangle tri, Shader sh) {
        this.triangle[this.numTriangles] = tri;
        this.shader[this.numTriangles++] = sh;
    }

    public void add(Triangle[] tri, Shader[] sh, int start, int count) {
        System.arraycopy(tri, start, this.triangle, this.numTriangles, count);
        System.arraycopy(sh, start, this.shader, this.numTriangles, count);
        this.numTriangles += count;
    }

    public void add(ObjectList tri, ObjectList sh) {
        if (!$assertionsDisabled && tri.size() != sh.size()) {
            throw new AssertionError();
        }
        System.arraycopy(tri.array(), 0, this.triangle, this.numTriangles, tri.size());
        System.arraycopy(sh.array(), 0, this.shader, this.numTriangles, sh.size());
        this.numTriangles += tri.size();
    }

    public void render() {
        try {
            this.shade();
            this.sort();
            this.build();
            this.draw();
        }
        finally {
            this.reset();
        }
    }

    private void shade() {
        int n = this.numTriangles;
        int i = 0;
        while (i < n) {
            this.numShadedTriangles += this.shader[i].shade(this.triangle[i], this.shadedTriangle, this.numShadedTriangles);
            ++i;
        }
    }

    private void sort() {
        int n = this.numShadedTriangles;
        int i = 0;
        while (i < n) {
            ShadedTriangle st = this.shadedTriangle[i];
            this.adjacency[i] = st.parent.adjacency;
            State[] state = st.state;
            int j = 0;
            while (j < this.numStateIndices) {
                this.sortIndex[j][i] = state[j].sortOrder();
                ++j;
            }
            ++i;
        }
        this.sort.resetIndices();
        this.sort.sort(this.adjacency, this.numShadedTriangles);
        i = this.numStateIndices;
        while (--i >= 0) {
            this.sort.sort(this.sortIndex[i], this.numShadedTriangles);
        }
    }

    private void build() {
        int[] index = this.sort.getIndices();
        int i = 0;
        while (i < this.numStateIndices) {
            this.currentState[i] = null;
            ++i;
        }
        int n = this.numShadedTriangles;
        this.numStateLists = 0;
        StateList currentStateList = null;
        int i2 = 0;
        while (i2 < n) {
            ShadedTriangle st = this.shadedTriangle[index[i2]];
            State[] newState = st.state;
            int numDifferent = 0;
            int j = 0;
            while (j < this.numStateIndices) {
                if (this.currentState[j] != newState[j]) {
                    this.oldState[numDifferent] = this.currentState[j];
                    this.copyState[numDifferent++] = this.currentState[j] = newState[j];
                }
                ++j;
            }
            if (numDifferent != 0) {
                if (this.numStateLists == this.stateLists.size()) {
                    currentStateList = new StateList();
                    this.stateLists.add(currentStateList);
                } else {
                    currentStateList = (StateList)this.stateLists.get(this.numStateLists);
                }
                ++this.numStateLists;
                currentStateList.numStates = numDifferent;
                j = 0;
                while (j < numDifferent) {
                    currentStateList.unstate[j] = this.oldState[j];
                    currentStateList.state[j] = this.copyState[j];
                    ++j;
                }
                currentStateList.init();
            }
            currentStateList.add(st);
            ++i2;
        }
    }

    private void draw() {
        if (this.numStateLists > 0) {
            boolean useVAR;
            boolean bl = useVAR = GLContext.GL_NV_vertex_array_range || GLContext.GL_NV_vertex_array_range2;
            if (useVAR) {
                this.fence.finish();
            }
            if (GLContext.GL_NV_vertex_array_range2) {
                GL11.glEnableClientState((int)34099);
            } else if (GLContext.GL_NV_vertex_array_range) {
                GL11.glEnableClientState((int)34077);
            }
            int i = 0;
            while (i < this.numStateLists) {
                StateList sl = (StateList)this.stateLists.get(i);
                sl.render();
                ++i;
            }
            i = this.numStateIndices;
            while (--i >= 0) {
                this.currentState[i].postRender();
            }
            if (useVAR) {
                this.fence.set(34034);
                if (GLContext.GL_NV_vertex_array_range2) {
                    GL11.glDisableClientState((int)34099);
                } else if (GLContext.GL_NV_vertex_array_range) {
                    GL11.glDisableClientState((int)34077);
                }
            }
        }
    }

    private void reset() {
        this.numTriangles = 0;
        this.numShadedTriangles = 0;
        this.sortedTriangleCount = 0;
        this.indexBuf.ints.clear();
    }

    private class StateList {
        final State[] unstate;
        final State[] state;
        int numStates;
        int start;
        int end;
        final IntBuffer indices;
        static final /* synthetic */ boolean $assertionsDisabled;
        static /* synthetic */ Class class$0;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.shavenpuppy.jglib.renderer.Renderer$StateList");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        StateList() {
            this.unstate = new State[Renderer.this.numStateIndices];
            this.state = new State[Renderer.this.numStateIndices];
            this.indices = ((Renderer)Renderer.this).indexBuf.ints.duplicate();
        }

        void init() {
            this.indices.clear().position(Renderer.this.sortedTriangleCount * 3).mark();
            this.end = this.start = Renderer.this.sortedTriangleCount;
        }

        void add(ShadedTriangle triangle) {
            triangle.parent.write(this.indices);
            ++this.end;
            ShadedTriangle[] shadedTriangleArray = Renderer.this.sortedTriangle;
            Renderer renderer = Renderer.this;
            int n = renderer.sortedTriangleCount;
            renderer.sortedTriangleCount = n + 1;
            shadedTriangleArray[n] = triangle;
        }

        void render() {
            int i = this.numStates;
            while (--i >= 0) {
                if (this.unstate[i] == null) continue;
                this.unstate[i].postRender();
            }
            i = 0;
            while (i < this.numStates) {
                this.state[i].preRender();
                ++i;
            }
            Shader oldShader = null;
            int i2 = this.start;
            while (i2 < this.end) {
                ShadedTriangle st = Renderer.this.sortedTriangle[i2];
                Shader newShader = st.shader;
                if (!$assertionsDisabled && newShader != oldShader && oldShader != null) {
                    throw new AssertionError();
                }
                oldShader = newShader;
                oldShader.process(st.parent);
                ++i2;
            }
            this.indices.limit(this.indices.position()).reset();
            if (this.indices.remaining() == 0) {
                return;
            }
            if (!Renderer.this.brokenDrivers && (GLContext.GL_EXT_draw_range_elements || GLContext.OpenGL12)) {
                int max;
                int min = oldShader.getMinVertexIndex();
                if (min != (max = oldShader.getMaxVertexIndex())) {
                    GL.glDrawRangeElements(4, min, max, this.indices);
                } else {
                    GL11.glDrawElements((int)4, (IntBuffer)this.indices);
                }
            } else {
                GL11.glDrawElements((int)4, (IntBuffer)this.indices);
            }
        }
    }
}

