/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.opengl;

import com.shavenpuppy.jglib.Glyph;
import com.shavenpuppy.jglib.opengl.GLRenderable;
import com.shavenpuppy.jglib.opengl.GLTexture;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.OpenGLException;
import org.lwjgl.util.Rectangle;
import org.lwjgl.util.WritablePoint;
import org.lwjgl.util.WritableRectangle;

public class GLGlyph
implements GLRenderable {
    protected transient GLTexture texture;
    protected transient Glyph glyph;
    protected transient int xpos;
    protected transient int ypos;
    private static final Rectangle bounds = new Rectangle();

    public GLGlyph(GLTexture texture, Glyph glyph) {
        this.texture = texture;
        this.glyph = glyph;
    }

    public GLGlyph(GLGlyph src) {
        this.texture = src.texture;
        this.glyph = src.glyph;
    }

    public void from(GLGlyph src) {
        this.init(src.texture, src.glyph);
    }

    public void init(GLTexture texture, Glyph g) {
        this.texture = texture;
        this.glyph = g;
    }

    public String getName() {
        return null;
    }

    public int getXpos() {
        return this.xpos;
    }

    public int getYpos() {
        return this.ypos;
    }

    public void render() throws OpenGLException {
        this.glyph.getBounds((WritableRectangle)bounds);
        float x0 = (float)bounds.getX() / (float)this.texture.getWidth();
        float y1 = (float)bounds.getY() / (float)this.texture.getHeight();
        float x1 = (float)(bounds.getX() + bounds.getWidth()) / (float)this.texture.getWidth();
        float y0 = (float)(bounds.getY() + bounds.getHeight()) / (float)this.texture.getHeight();
        GL11.glTexCoord2f((float)x0, (float)y0);
        GL11.glVertex2i((int)this.xpos, (int)this.ypos);
        GL11.glTexCoord2f((float)x1, (float)y0);
        GL11.glVertex2i((int)(bounds.getWidth() + this.xpos), (int)this.ypos);
        GL11.glTexCoord2f((float)x1, (float)y1);
        GL11.glVertex2i((int)(bounds.getWidth() + this.xpos), (int)(bounds.getHeight() + this.ypos));
        GL11.glTexCoord2f((float)x0, (float)y1);
        GL11.glVertex2i((int)this.xpos, (int)(bounds.getHeight() + this.ypos));
    }

    public void setLocation(int xp, int yp) {
        this.xpos = xp;
        this.ypos = yp;
    }

    public int getWidth() {
        return this.glyph.getWidth();
    }

    public int getHeight() {
        return this.glyph.getHeight();
    }

    public int getBearingX() {
        return this.glyph.getBearingX();
    }

    public int getBearingY() {
        return this.glyph.getBearingY();
    }

    public int getAdvance() {
        return this.glyph.getAdvance();
    }

    public int getKerningAfter(GLGlyph g) {
        return this.glyph.getKerningAfter(g.glyph);
    }

    public void getBearing(WritablePoint dest) {
        this.glyph.getBearing(dest);
    }

    public void getBounds(WritableRectangle dest) {
        this.glyph.getBounds(dest);
    }
}

