/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.opengl;

import com.shavenpuppy.jglib.MultiBuffer;
import com.shavenpuppy.jglib.opengl.GL;
import com.shavenpuppy.jglib.opengl.GLFrustum;
import com.shavenpuppy.jglib.opengl.GLRenderable;
import java.nio.FloatBuffer;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.OpenGLException;
import org.lwjgl.opengl.glu.GLU;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.Vector3f;

public class GLCamera
implements GLRenderable {
    public final GLFrustum frustum;
    private float width;
    private float height;
    private float near = 1000.0f;
    private float far = 100000.0f;
    private float fov = 90.0f;
    private boolean updateMatrix = true;
    public final Vector3f eye = new Vector3f();
    private final Vector3f negEye = new Vector3f();
    public final Vector3f lookAt = new Vector3f();
    public final Vector3f up = new Vector3f(0.0f, 0.0f, 1.0f);
    private GLRenderable preRotate;
    private GLRenderable preTranslate;
    private GLRenderable scene;
    private static final Vector3f v0 = new Vector3f();
    private static final Vector3f v1 = new Vector3f();
    private static final Vector3f v2 = new Vector3f();
    private static final Matrix4f mm = new Matrix4f();
    private static final MultiBuffer buf = new MultiBuffer(64);
    private final Matrix4f proj;
    private final Matrix4f modl;
    private boolean processed;

    public GLCamera() {
        this.frustum = new GLFrustum();
        this.proj = this.frustum.proj;
        this.modl = this.frustum.modl;
    }

    public GLCamera(GL gl, float width, float height, float near, float far, float fov) {
        this();
        this.width = width;
        this.height = height;
        this.near = near;
        this.far = far;
        this.fov = fov;
        this.updateMatrix = true;
    }

    private void frustum(Matrix4f mat, float left, float right, float bottom, float top, float nearval, float farval) {
        mat.m00 = 2.0f * nearval / (right - left);
        mat.m11 = 2.0f * nearval / (top - bottom);
        mat.m02 = (right + left) / (right - left);
        mat.m12 = (top + bottom) / (top - bottom);
        mat.m22 = -(farval + nearval) / (farval - nearval);
        mat.m32 = -(2.0f * farval * nearval) / (farval - nearval);
        Matrix4f.mul((Matrix4f)mat, (Matrix4f)mm, (Matrix4f)mat);
    }

    public float getFar() {
        return this.far;
    }

    public float getFOV() {
        return this.fov;
    }

    public String getName() {
        return "Camera";
    }

    public float getNear() {
        return this.near;
    }

    private void perspective(float fovy, float aspect, float zNear, float zFar) {
        float ymax = (float)((double)zNear * Math.tan((double)fovy * Math.PI / 360.0));
        float ymin = -ymax;
        float xmin = ymin * aspect;
        float xmax = ymax * aspect;
        this.proj.setIdentity();
        this.frustum(this.proj, xmin, xmax, ymin, ymax, zNear, zFar);
    }

    public void process() {
        if (this.processed) {
            return;
        }
        if (this.updateMatrix) {
            this.perspective(this.fov, this.width / this.height, this.near, this.far);
        }
        Vector3f.sub((Vector3f)this.eye, (Vector3f)this.lookAt, (Vector3f)v2);
        v2.normalise();
        Vector3f.cross((Vector3f)this.up, (Vector3f)v2, (Vector3f)v0);
        Vector3f.cross((Vector3f)v2, (Vector3f)v0, (Vector3f)v1);
        v0.normalise();
        v1.normalise();
        GLCamera.mm.m00 = GLCamera.v0.x;
        GLCamera.mm.m10 = GLCamera.v0.y;
        GLCamera.mm.m20 = GLCamera.v0.z;
        GLCamera.mm.m30 = 0.0f;
        GLCamera.mm.m01 = GLCamera.v1.x;
        GLCamera.mm.m11 = GLCamera.v1.y;
        GLCamera.mm.m21 = GLCamera.v1.z;
        GLCamera.mm.m31 = 0.0f;
        GLCamera.mm.m02 = GLCamera.v2.x;
        GLCamera.mm.m12 = GLCamera.v2.y;
        GLCamera.mm.m22 = GLCamera.v2.z;
        GLCamera.mm.m32 = 0.0f;
        GLCamera.mm.m03 = 0.0f;
        GLCamera.mm.m13 = 0.0f;
        GLCamera.mm.m13 = 0.0f;
        GLCamera.mm.m13 = 1.0f;
        this.modl.setIdentity();
        Matrix4f.mul((Matrix4f)this.modl, (Matrix4f)mm, (Matrix4f)this.modl);
        this.eye.negate(this.negEye);
        this.modl.translate(this.negEye);
        this.frustum.process();
        this.processed = true;
    }

    public void render() throws OpenGLException {
        this.process();
        if (this.updateMatrix) {
            this.updateMatrix = false;
            GL11.glMatrixMode((int)5889);
            GL11.glLoadIdentity();
            GLU.gluPerspective((float)this.fov, (float)(this.width / this.height), (float)this.near, (float)this.far);
            GL11.glMatrixMode((int)5888);
        }
        Vector3f.sub((Vector3f)this.eye, (Vector3f)this.lookAt, (Vector3f)v2);
        v2.normalise();
        Vector3f.cross((Vector3f)this.up, (Vector3f)v2, (Vector3f)v0);
        Vector3f.cross((Vector3f)v2, (Vector3f)v0, (Vector3f)v1);
        v0.normalise();
        v1.normalise();
        GLCamera.mm.m00 = GLCamera.v0.x;
        GLCamera.mm.m10 = GLCamera.v0.y;
        GLCamera.mm.m20 = GLCamera.v0.z;
        GLCamera.mm.m30 = 0.0f;
        GLCamera.mm.m01 = GLCamera.v1.x;
        GLCamera.mm.m11 = GLCamera.v1.y;
        GLCamera.mm.m21 = GLCamera.v1.z;
        GLCamera.mm.m31 = 0.0f;
        GLCamera.mm.m02 = GLCamera.v2.x;
        GLCamera.mm.m12 = GLCamera.v2.y;
        GLCamera.mm.m22 = GLCamera.v2.z;
        GLCamera.mm.m32 = 0.0f;
        GLCamera.mm.m03 = 0.0f;
        GLCamera.mm.m13 = 0.0f;
        GLCamera.mm.m13 = 0.0f;
        GLCamera.mm.m13 = 1.0f;
        GLCamera.buf.floats.rewind();
        mm.store(GLCamera.buf.floats);
        GL11.glPushMatrix();
        try {
            if (this.preRotate != null) {
                this.preRotate.render();
            }
            GL11.glMultMatrix((FloatBuffer)GLCamera.buf.floats);
            if (this.preTranslate != null) {
                this.preTranslate.render();
            }
            GL11.glTranslatef((float)this.negEye.x, (float)this.negEye.y, (float)this.negEye.z);
            this.processed = false;
            if (this.scene != null) {
                this.scene.render();
            }
        }
        finally {
            GL11.glPopMatrix();
        }
    }

    public void setFar(float newFar) {
        if (this.far != newFar) {
            this.far = newFar;
            this.updateMatrix = true;
        }
    }

    public void setFOV(float newFov) {
        if (this.fov != newFov) {
            this.fov = newFov;
            this.updateMatrix = true;
        }
    }

    public void setNear(float newNear) {
        if (this.near != newNear) {
            this.near = newNear;
            this.updateMatrix = true;
        }
    }

    public void setScene(GLRenderable preRotate, GLRenderable preTranslate, GLRenderable scene) {
        this.preRotate = preRotate;
        this.preTranslate = preTranslate;
        this.scene = scene;
    }

    public void setSize(float width, float height) {
        if (width != this.width) {
            this.width = width;
            this.updateMatrix = true;
        }
        if (height != this.height) {
            this.height = height;
            this.updateMatrix = true;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(64);
        sb.append("ex:");
        sb.append(this.eye.x);
        sb.append(" ey:");
        sb.append(this.eye.y);
        sb.append(" ez:");
        sb.append(this.eye.z);
        sb.append(" tx:");
        sb.append(this.lookAt.x);
        sb.append(" ty:");
        sb.append(this.lookAt.y);
        sb.append(" tz:");
        sb.append(this.lookAt.z);
        sb.append(" fov:");
        sb.append(this.fov);
        sb.append(" near:");
        sb.append(this.near);
        sb.append(" far:");
        sb.append(this.far);
        return sb.toString();
    }
}

