/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.interpolators;

import com.shavenpuppy.jglib.interpolators.Interpolator;
import com.shavenpuppy.jglib.util.FPMath;

public class PhasedInterpolator
implements Interpolator {
    private final float initialDuration;
    private final float finalDuration;
    private final int initialDurationFP;
    private final int finalDurationFP;
    private final Interpolator interpolator;

    public PhasedInterpolator(float initialDuration, float finalDuration, Interpolator interpolator) throws IllegalArgumentException {
        this.initialDuration = initialDuration;
        this.finalDuration = finalDuration;
        this.interpolator = interpolator;
        this.initialDurationFP = FPMath.fpValue(initialDuration);
        this.finalDurationFP = FPMath.fpValue(finalDuration);
        if (initialDuration + finalDuration >= 1.0f) {
            throw new IllegalArgumentException("Duration must be < 1.0f");
        }
    }

    public float interpolate(float a, float b, float ratio) {
        if (ratio < this.initialDuration) {
            return a;
        }
        if (ratio >= 1.0f - this.finalDuration) {
            return b;
        }
        return this.interpolator.interpolate(a, b, ratio - this.initialDuration);
    }

    public int interpolate(int a, int b, int ratio) {
        if (ratio < this.initialDurationFP) {
            return a;
        }
        if (ratio >= FPMath.ONE - this.finalDurationFP) {
            return b;
        }
        return this.interpolator.interpolate(a, b, ratio - this.initialDurationFP);
    }
}

