/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.geometry;

import com.shavenpuppy.jglib.geometry.Box;
import com.shavenpuppy.jglib.geometry.Classifier;
import com.shavenpuppy.jglib.geometry.Plane;
import com.shavenpuppy.jglib.geometry.Sphere;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.Vector3f;

public class Frustum
implements Classifier {
    public static float error = 0.0f;
    private final Plane[] plane = new Plane[6];
    private final Matrix4f clip = new Matrix4f();

    public Frustum() {
        int i = 0;
        while (i < 6) {
            this.plane[i] = new Plane();
            ++i;
        }
    }

    public Classifier.Classification classify(float x, float y, float z) {
        int p = 0;
        while (p < 6) {
            if (this.plane[p].classify(x, y, z) == Plane.BEHIND) {
                return Classifier.OUTSIDE;
            }
            ++p;
        }
        return Classifier.INSIDE;
    }

    public Classifier.Classification classify(float x, float y, float z, float radius) {
        int count = 0;
        int i = 0;
        while (i < 6) {
            float d = this.plane[i].distanceTo(x, y, z);
            if (d >= radius) {
                ++count;
            } else if (d <= -radius) {
                return Classifier.OUTSIDE;
            }
            ++i;
        }
        if (count == 6) {
            return Classifier.INSIDE;
        }
        return Classifier.SPANNING;
    }

    public Classifier.Classification classify(Box box) {
        int count = 0;
        int i = 0;
        while (i < 6) {
            Plane.Classification classification = box.classify(this.plane[i]);
            if (classification == Plane.BEHIND) {
                return Classifier.OUTSIDE;
            }
            if (classification == Plane.IN_FRONT_OF) {
                ++count;
            }
            ++i;
        }
        if (count == 6) {
            return Classifier.INSIDE;
        }
        return Classifier.SPANNING;
    }

    public Classifier.Classification classify(Sphere sphere) {
        int count = 0;
        int i = 0;
        while (i < 6) {
            Plane.Classification classification = sphere.classify(this.plane[i]);
            if (classification == Plane.BEHIND) {
                return Classifier.OUTSIDE;
            }
            if (classification == Plane.IN_FRONT_OF) {
                ++count;
            }
            ++i;
        }
        if (count == 6) {
            return Classifier.INSIDE;
        }
        return Classifier.SPANNING;
    }

    public Classifier.Classification classify(Vector3f v) {
        int p = 0;
        while (p < 6) {
            if (this.plane[p].classify(v) == Plane.BEHIND) {
                return Classifier.OUTSIDE;
            }
            ++p;
        }
        return Classifier.INSIDE;
    }

    public void extract(Matrix4f proj, Matrix4f modl) {
        Matrix4f.mul((Matrix4f)proj, (Matrix4f)modl, (Matrix4f)this.clip);
        this.plane[0].a = this.clip.m03 - this.clip.m00;
        this.plane[0].b = this.clip.m13 - this.clip.m10;
        this.plane[0].c = this.clip.m23 - this.clip.m20;
        this.plane[0].d = this.clip.m33 - this.clip.m30;
        this.plane[1].a = this.clip.m03 + this.clip.m00;
        this.plane[1].b = this.clip.m13 + this.clip.m10;
        this.plane[1].c = this.clip.m23 + this.clip.m20;
        this.plane[1].d = this.clip.m33 + this.clip.m30;
        this.plane[2].a = this.clip.m03 + this.clip.m01;
        this.plane[2].b = this.clip.m13 + this.clip.m11;
        this.plane[2].c = this.clip.m23 + this.clip.m21;
        this.plane[2].d = this.clip.m33 + this.clip.m31;
        this.plane[3].a = this.clip.m03 - this.clip.m01;
        this.plane[3].b = this.clip.m13 - this.clip.m11;
        this.plane[3].c = this.clip.m23 - this.clip.m21;
        this.plane[3].d = this.clip.m33 - this.clip.m31;
        this.plane[4].a = this.clip.m03 - this.clip.m02;
        this.plane[4].b = this.clip.m13 - this.clip.m12;
        this.plane[4].c = this.clip.m23 - this.clip.m22;
        this.plane[4].d = this.clip.m33 - this.clip.m32;
        this.plane[5].a = this.clip.m03 + this.clip.m02;
        this.plane[5].b = this.clip.m13 + this.clip.m12;
        this.plane[5].c = this.clip.m23 + this.clip.m22;
        this.plane[5].d = this.clip.m33 + this.clip.m32;
        int i = 0;
        while (i < 6) {
            this.plane[i].normalize();
            ++i;
        }
    }

    public boolean intersect(Plane p, Vector3f[] quad) {
        return false;
    }

    public Classifier.Classification quickClassify(Box box) {
        int i = 0;
        while (i < 6) {
            Plane p = this.plane[i];
            if (!(p.a * box.px + p.b * box.py + p.c * box.pz + p.d > 0.0f || p.a * box.ex + p.b * box.py + p.c * box.pz + p.d > 0.0f || p.a * box.px + p.b * box.ey + p.c * box.pz + p.d > 0.0f || p.a * box.ex + p.b * box.ey + p.c * box.pz + p.d > 0.0f || p.a * box.px + p.b * box.py + p.c * box.ez + p.d > 0.0f || p.a * box.ex + p.b * box.py + p.c * box.ez + p.d > 0.0f || p.a * box.px + p.b * box.ey + p.c * box.ez + p.d > 0.0f || p.a * box.ex + p.b * box.ey + p.c * box.ez + p.d > 0.0f)) {
                return Classifier.OUTSIDE;
            }
            ++i;
        }
        return Classifier.SPANNING;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(512);
        sb.append("Frustum[Left:");
        sb.append(this.plane[0]);
        sb.append(" Right:");
        sb.append(this.plane[1]);
        sb.append(" Bottom:");
        sb.append(this.plane[2]);
        sb.append(" Top:");
        sb.append(this.plane[3]);
        sb.append(" Far:");
        sb.append(this.plane[4]);
        sb.append(" Near:");
        sb.append(this.plane[5]);
        sb.append(']');
        return sb.toString();
    }
}

