/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.gamecommerce.client;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.puppygames.gamecommerce.client.LimitedSizeDocument;
import net.puppygames.gamecommerce.client.WizardGUI;
import net.puppygames.gamecommerce.shared.CreditCard;
import net.puppygames.gamecommerce.shared.PaymentDetails;
import net.puppygames.gamecommerce.shared.ValidateUtil;

class BuyPage2
extends WizardGUI
implements PaymentDetails.CreditCardDetailsEditor {
    private JLabel type_label;
    private JLabel name_label;
    private JLabel number_label;
    private JLabel expiry_label;
    private JLabel start_label;
    private JLabel issue_label;
    private JLabel slash1_label;
    private JLabel slash2_label;
    private JRadioButton type_credit_radiobutton;
    private JRadioButton type_debit_radiobutton;
    private JTextField name_textfield;
    private JTextField number_textfield;
    private JPanel expiry_panel;
    private JTextField expiry_month_textfield;
    private JTextField expiry_year_textfield;
    private JPanel start_panel;
    private JTextField start_month_textfield;
    private JTextField start_year_textfield;
    private JTextField issue_textfield;
    private ButtonGroup card_buttongroup;
    private CreditCard creditCard;
    private final EventHandler eventHandler = new EventHandler();
    private int thisYear = Calendar.getInstance().get(1) - 2000;
    private int thisMonth;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.puppygames.gamecommerce.client.BuyPage2");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    BuyPage2() {
        if (this.thisYear < 3) {
            throw new RuntimeException("Date is incorrectly set.");
        }
        this.thisMonth = Calendar.getInstance().get(2) + 1;
        this.type_label = new JLabel("Card Type");
        this.name_label = new JLabel("Name on Card");
        this.number_label = new JLabel("Card Number");
        this.expiry_label = new JLabel("Expiry Date (MM/YY)");
        this.start_label = new JLabel("Start Date (MM/YY)");
        this.issue_label = new JLabel("Issue Number");
        this.slash1_label = new JLabel("/");
        this.slash2_label = new JLabel("/");
        this.type_credit_radiobutton = new JRadioButton(CreditCard.CREDIT.getName());
        this.type_debit_radiobutton = new JRadioButton(CreditCard.DEBIT.getName());
        this.name_textfield = new JTextField(40);
        this.number_textfield = new JTextField(16);
        this.expiry_panel = new JPanel(new GridBagLayout());
        this.expiry_month_textfield = new JTextField(2);
        this.expiry_year_textfield = new JTextField(2);
        this.start_panel = new JPanel(new GridBagLayout());
        this.start_month_textfield = new JTextField(2);
        this.start_year_textfield = new JTextField(2);
        this.issue_textfield = new JTextField(2);
        this.card_buttongroup = new ButtonGroup();
        this.card_buttongroup.add(this.type_credit_radiobutton);
        this.card_buttongroup.add(this.type_debit_radiobutton);
        this.name_textfield.setDocument(new LimitedSizeDocument(40, false));
        this.number_textfield.setDocument(new LimitedSizeDocument(16, true));
        this.expiry_month_textfield.setDocument(new LimitedSizeDocument(2, true));
        this.expiry_year_textfield.setDocument(new LimitedSizeDocument(2, true));
        this.start_month_textfield.setDocument(new LimitedSizeDocument(2, true));
        this.start_year_textfield.setDocument(new LimitedSizeDocument(2, true));
        this.issue_textfield.setDocument(new LimitedSizeDocument(2, true));
        this.gui.add((Component)this.type_label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.gui.add((Component)this.name_label, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.gui.add((Component)this.number_label, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.gui.add((Component)this.expiry_label, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.gui.add((Component)this.start_label, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.gui.add((Component)this.type_credit_radiobutton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(2, 0, 2, 2), 0, 0));
        this.gui.add((Component)this.type_debit_radiobutton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 2, 2), 0, 0));
        this.gui.add((Component)this.name_textfield, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.gui.add((Component)this.number_textfield, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.gui.add((Component)this.expiry_panel, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.gui.add((Component)this.start_panel, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.gui.add((Component)this.issue_label, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.gui.add((Component)this.issue_textfield, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 16, 0));
        this.expiry_panel.add((Component)this.expiry_month_textfield, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 16, 0));
        this.expiry_panel.add((Component)this.slash1_label, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.expiry_panel.add((Component)this.expiry_year_textfield, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 16, 0));
        this.start_panel.add((Component)this.start_month_textfield, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 16, 0));
        this.start_panel.add((Component)this.slash2_label, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.start_panel.add((Component)this.start_year_textfield, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 16, 0));
        this.type_credit_radiobutton.addActionListener(this.eventHandler);
        this.type_debit_radiobutton.addActionListener(this.eventHandler);
        this.name_textfield.getDocument().addDocumentListener(this.eventHandler);
        this.number_textfield.getDocument().addDocumentListener(this.eventHandler);
        this.expiry_month_textfield.getDocument().addDocumentListener(this.eventHandler);
        this.expiry_year_textfield.getDocument().addDocumentListener(this.eventHandler);
        this.start_month_textfield.getDocument().addDocumentListener(this.eventHandler);
        this.start_year_textfield.getDocument().addDocumentListener(this.eventHandler);
        this.issue_textfield.getDocument().addDocumentListener(this.eventHandler);
    }

    public void init() {
        this.type_credit_radiobutton.setSelected(true);
        this.enableControls();
    }

    private void enableControls() {
        boolean checked = this.type_debit_radiobutton.isSelected();
        this.issue_label.setVisible(checked);
        this.issue_textfield.setVisible(checked);
        this.start_label.setVisible(checked);
        this.start_month_textfield.setVisible(checked);
        this.start_year_textfield.setVisible(checked);
        this.slash2_label.setVisible(checked);
        this.creditCard = checked ? CreditCard.DEBIT : CreditCard.CREDIT;
    }

    public String checkValid() {
        String message = null;
        String name = this.name_textfield.getText().trim();
        String number = this.number_textfield.getText().trim();
        String issue = this.issue_textfield.getText().trim();
        String sm = this.start_month_textfield.getText().trim();
        String sy = this.start_year_textfield.getText().trim();
        String em = this.expiry_month_textfield.getText().trim();
        String ey = this.expiry_year_textfield.getText().trim();
        if (!ValidateUtil.isName(name)) {
            message = "You must enter a name.";
        } else {
            if (this.creditCard.isDebitCard()) {
                try {
                    int in = Integer.parseInt(issue);
                    if (in < 1 || in > 20) {
                        message = "Invalid issue number.";
                    }
                }
                catch (NumberFormatException e) {
                    message = "You must enter an issue number for debit cards.";
                }
                if (message == null) {
                    try {
                        int ism = Integer.parseInt(sm);
                        if (ism < 1 || ism > 12) {
                            message = "Invalid start month.";
                        }
                        try {
                            int isy = Integer.parseInt(sy);
                            if (isy > 49) {
                                isy -= 100;
                            }
                            if (isy > this.thisYear) {
                                message = "Invalid start year.";
                            } else if (isy == this.thisYear && ism > this.thisMonth) {
                                message = "Invalid start date.";
                            }
                        }
                        catch (NumberFormatException e) {
                            message = "You must enter a start year in the range 00..0" + this.thisYear;
                        }
                    }
                    catch (NumberFormatException e) {
                        message = "You must enter a start month in the range 01..12";
                    }
                }
            }
            if (message == null) {
                try {
                    int iem = Integer.parseInt(em);
                    if (iem < 1 || iem > 12) {
                        message = "Invalid expiry month.";
                    }
                    try {
                        int iey = Integer.parseInt(ey);
                        if (iey > 49) {
                            iey -= 100;
                        }
                        if (iey < this.thisYear) {
                            message = "Invalid expiry year.";
                        } else if (iey == this.thisYear && iem < this.thisMonth) {
                            message = "Invalid expiry date.";
                        }
                    }
                    catch (NumberFormatException e) {
                        message = "You must enter an expiry year in the range 03..13";
                    }
                }
                catch (NumberFormatException e) {
                    message = "You must enter a expiry month in the range 01..12";
                }
            }
            if (message == null) {
                message = this.creditCard.validate(number);
            }
        }
        System.out.println(message);
        this.getWizardDialog().setNextButtonEnabled(message == null, message);
        return message;
    }

    public String getInstructions() {
        return "Now enter your credit or debit card details. Enter the name exactly as it is embossed on the card. For debit cards you must enter an issue number and start date.";
    }

    public String getTitle() {
        return "Step 3 of 5";
    }

    public int getCCExpiryMonth() {
        return Integer.parseInt(this.expiry_month_textfield.getText().trim());
    }

    public int getCCExpiryYear() {
        return Integer.parseInt(this.expiry_year_textfield.getText().trim());
    }

    public int getCCIssueNumber() {
        if (this.creditCard.isDebitCard()) {
            return Integer.parseInt(this.issue_textfield.getText().trim());
        }
        return 0;
    }

    public String getCCName() {
        return this.name_textfield.getText().trim();
    }

    public String getCCNumber() {
        return this.number_textfield.getText().trim();
    }

    public int getCCStartMonth() {
        if (this.creditCard.isDebitCard()) {
            return Integer.parseInt(this.start_month_textfield.getText().trim());
        }
        return 0;
    }

    public int getCCStartYear() {
        if (this.creditCard.isDebitCard()) {
            return Integer.parseInt(this.start_year_textfield.getText().trim());
        }
        return 0;
    }

    public CreditCard getCCType() {
        if (this.type_credit_radiobutton.isSelected()) {
            return CreditCard.CREDIT;
        }
        if (this.type_debit_radiobutton.isSelected()) {
            return CreditCard.CREDIT;
        }
        return null;
    }

    public void setCCExpiryMonth(int month) {
        if (month < 10) {
            this.expiry_month_textfield.setText("0" + month);
        } else {
            this.expiry_month_textfield.setText(String.valueOf(month));
        }
    }

    public void setCCExpiryYear(int year) {
        if (year < 10) {
            this.expiry_year_textfield.setText("0" + year);
        } else {
            this.expiry_year_textfield.setText(String.valueOf(year));
        }
    }

    public void setCCIssueNumber(int issue) {
        this.issue_textfield.setText(String.valueOf(issue));
    }

    public void setCCName(String name) {
        this.name_textfield.setText(name);
    }

    public void setCCNumber(String number) {
        this.number_textfield.setText(number);
    }

    public void setCCStartMonth(int month) {
        if (month < 10) {
            this.start_month_textfield.setText("0" + month);
        } else {
            this.start_month_textfield.setText(String.valueOf(month));
        }
    }

    public void setCCStartYear(int year) {
        if (year < 10) {
            this.start_year_textfield.setText("0" + year);
        } else {
            this.start_year_textfield.setText(String.valueOf(year));
        }
    }

    public void setCCType(CreditCard type) {
        this.creditCard = type;
        if (type == CreditCard.CREDIT) {
            this.type_credit_radiobutton.setSelected(true);
        } else if (type == CreditCard.DEBIT) {
            this.type_debit_radiobutton.setSelected(true);
        } else if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public String getCCSecurity() {
        return null;
    }

    public void setCCSecurity(String security) {
    }

    public void toPaymentDetails(PaymentDetails paymentDetails) {
        paymentDetails.fromCreditCardDetailsGetter(this);
    }

    private class EventHandler
    implements ActionListener,
    DocumentListener {
        EventHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            BuyPage2.this.enableControls();
            BuyPage2.this.checkValid();
        }

        public void changedUpdate(DocumentEvent e) {
            BuyPage2.this.checkValid();
        }

        public void insertUpdate(DocumentEvent e) {
            BuyPage2.this.checkValid();
        }

        public void removeUpdate(DocumentEvent e) {
            BuyPage2.this.checkValid();
        }
    }
}

