/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public final class ObjectList
implements Serializable {
    private Object[] value;
    private int count = 0;
    private boolean fastExpand;

    public ObjectList() {
        this(0);
    }

    public ObjectList(int size) {
        this(true, size);
    }

    public ObjectList(boolean fastExpand, int size) {
        this.fastExpand = fastExpand;
        this.value = new Object[size];
    }

    public int add(Object f) {
        if (this.count == this.value.length) {
            Object[] oldValue = this.value;
            this.value = this.fastExpand ? new Object[(oldValue.length << 1) + 1] : new Object[oldValue.length + 1];
            System.arraycopy(oldValue, 0, this.value, 0, oldValue.length);
        }
        this.value[this.count] = f;
        return this.count++;
    }

    public void addAll(Object[] f) {
        this.ensureCapacity(this.count + f.length);
        System.arraycopy(f, 0, this.value, this.count, f.length);
        this.count += f.length;
    }

    public void addAll(ObjectList f) {
        this.ensureCapacity(this.count + f.count);
        System.arraycopy(f.value, 0, this.value, this.count, f.count);
        this.count += f.count;
    }

    public Object[] array() {
        return this.value;
    }

    public int capacity() {
        return this.value.length;
    }

    public void clear() {
        this.count = 0;
    }

    public void ensureCapacity(int size) {
        if (this.value.length >= size) {
            return;
        }
        Object[] oldValue = this.value;
        this.value = new Object[size];
        System.out.println(size);
        System.arraycopy(oldValue, 0, this.value, 0, oldValue.length);
    }

    public Object get(int index) {
        return this.value[index];
    }

    public void grow() {
        ++this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int capacity = in.readInt();
        this.count = in.readInt();
        this.fastExpand = in.readBoolean();
        this.value = new Object[capacity];
        int i = 0;
        while (i < this.count) {
            this.value[i] = in.readObject();
            ++i;
        }
    }

    public Object remove(int index) {
        if (index >= this.count) {
            return null;
        }
        Object ret = this.value[index];
        --this.count;
        if (index < this.count) {
            System.arraycopy(this.value, index + 1, this.value, index, this.count - index);
        }
        return ret;
    }

    public void shrink() {
        --this.count;
    }

    public int size() {
        return this.count;
    }

    public void toArray(Object[] dest) {
        System.arraycopy(this.value, 0, dest, 0, this.count);
    }

    public void trimToSize() {
        if (this.count == this.value.length) {
            return;
        }
        Object[] oldValue = this.value;
        this.value = new Object[this.count];
        System.arraycopy(oldValue, 0, this.value, 0, this.count);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.value.length);
        out.writeInt(this.count);
        out.writeBoolean(this.fastExpand);
        int i = 0;
        while (i < this.count) {
            out.writeObject(this.value[i]);
            ++i;
        }
    }
}

