/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.sprites;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.sprites.Animated;
import com.shavenpuppy.jglib.sprites.Command;
import com.shavenpuppy.jglib.sprites.SpriteImage;
import org.w3c.dom.Element;

public class FrameCommand
extends Command {
    public static final long serialVersionUID = 1L;
    private int duration;
    private String imageName;
    private transient SpriteImage spriteImage;

    public boolean execute(Animated target, int tickRate) {
        int currentSequence = target.getSequence();
        int currentTick = target.getTick();
        if (currentTick >= this.duration) {
            target.setSequence(++currentSequence);
            target.setTick(0);
            return true;
        }
        target.setTick(currentTick + tickRate);
        target.setImage(this.spriteImage);
        return false;
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        this.imageName = element.getAttribute("i");
        this.duration = Integer.parseInt(element.getAttribute("d"));
    }

    protected void doCreate() throws Exception {
        this.spriteImage = (SpriteImage)Resources.get(this.imageName);
    }

    protected void doDestroy() {
        this.spriteImage = null;
    }
}

