/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.opengl;

import com.shavenpuppy.jglib.Image;
import com.shavenpuppy.jglib.opengl.GLBumpMap;
import com.shavenpuppy.jglib.resources.ImageResource;
import org.lwjgl.util.vector.Vector3f;

public class GLFrozenBumpMap
extends GLBumpMap {
    public static final long serialVersionUID = 1L;
    private transient Vector3f light;

    public GLFrozenBumpMap(String name, String url, float scale, Vector3f light) {
        super(name, url, scale);
        this.light = light;
    }

    public GLFrozenBumpMap(String name, ImageResource imageResource, float scale, Vector3f light) {
        super(name, imageResource, scale);
        this.light = light;
    }

    public GLFrozenBumpMap(String name, Image image, float scale, Vector3f light) {
        super(name, image, scale);
        this.light = light;
    }

    protected Image preprocess() {
        Image ret = super.preprocess();
        Image frozen = new Image(ret.getWidth(), ret.getHeight(), 2);
        ret.getData().rewind();
        Vector3f vec = new Vector3f();
        int y = 0;
        while (y < ret.getHeight()) {
            int x = 0;
            while (x < ret.getWidth()) {
                byte r = ret.getData().get();
                byte g = ret.getData().get();
                byte b = ret.getData().get();
                vec.set(this.toFloat(r), this.toFloat(g), this.toFloat(b));
                float dotProduct = Math.max(0.0f, Vector3f.dot((Vector3f)this.light, (Vector3f)vec));
                frozen.getData().put((byte)(dotProduct * 255.0f));
                ++x;
            }
            ++y;
        }
        frozen.getData().flip();
        return frozen;
    }

    private float toFloat(byte a) {
        float aa = a & 0xFF;
        aa /= 127.5f;
        return aa -= 1.0f;
    }
}

