/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.geometry.storage;

import com.shavenpuppy.jglib.geometry.Box;
import com.shavenpuppy.jglib.geometry.Classifier;
import com.shavenpuppy.jglib.geometry.storage.GeometryStorage;
import com.shavenpuppy.jglib.util.ObjectList;
import java.io.Serializable;
import java.util.ArrayList;
import org.lwjgl.util.vector.Vector3f;

public class QuadTree
implements Serializable,
GeometryStorage {
    protected final QuadTree top_left;
    protected final QuadTree top_right;
    protected final QuadTree bottom_left;
    protected final QuadTree bottom_right;
    protected final float x;
    protected final float y;
    protected final float size;
    protected final float minZ;
    protected final float maxZ;
    protected final GeometryStorage.Geometry[] contents;
    public final int totalGeometry;
    private boolean visible;
    private static final Box g_box;
    private static final transient ArrayList v;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.shavenpuppy.jglib.geometry.storage.QuadTree");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        g_box = new Box();
        v = new ArrayList();
    }

    public QuadTree(ObjectList newContents, int minContents, float minSize, float xpos, float ypos, float size) {
        this.x = xpos;
        this.y = ypos;
        this.size = size;
        float minZ = 0.0f;
        float maxZ = 0.0f;
        if (size <= minSize || newContents.size() <= minContents) {
            int i = 0;
            while (i < newContents.size()) {
                GeometryStorage.Geometry q = (GeometryStorage.Geometry)newContents.get(i);
                q.getCoords(v);
                Box b = Box.computeAABB(v);
                float z = b.pz;
                minZ = Math.min(z, minZ);
                maxZ = Math.max(z, maxZ);
                z = b.ez;
                minZ = Math.min(z, minZ);
                maxZ = Math.max(z, maxZ);
                ++i;
            }
            this.minZ = minZ;
            this.maxZ = maxZ;
            this.totalGeometry = newContents.size();
            this.contents = new GeometryStorage.Geometry[this.totalGeometry];
            newContents.toArray(this.contents);
            this.bottom_left = null;
            this.bottom_right = null;
            this.top_left = null;
            this.top_right = null;
            return;
        }
        float sizeBy2 = size * 0.5f;
        float midX = this.x + sizeBy2;
        float midY = this.y + sizeBy2;
        ObjectList bl = new ObjectList(Math.max(1, newContents.size() >> 2));
        ObjectList br = new ObjectList(Math.max(1, newContents.size() >> 2));
        ObjectList tl = new ObjectList(Math.max(1, newContents.size() >> 2));
        ObjectList tr = new ObjectList(Math.max(1, newContents.size() >> 2));
        ObjectList geom = new ObjectList(Math.max(1, newContents.size() >> 4));
        int i = 0;
        while (i < newContents.size()) {
            GeometryStorage.Geometry q = (GeometryStorage.Geometry)newContents.get(i);
            int c = 0;
            v.clear();
            q.getCoords(v);
            int hitMidX = 0;
            int hitMidY = 0;
            int length = v.size();
            int j = 0;
            while (j < length) {
                Vector3f vec3f = (Vector3f)v.get(j);
                float qx = vec3f.x;
                float qy = vec3f.y;
                if (qx < midX) {
                    if (qy < midY) {
                        c |= 1;
                    } else if (qy > midY) {
                        c |= 2;
                    } else {
                        hitMidX = -1;
                    }
                } else if (qx > midX) {
                    if (qy < midY) {
                        c |= 8;
                    } else if (qy > midY) {
                        c |= 4;
                    } else {
                        hitMidX = 1;
                    }
                } else if (qx == midX) {
                    if (qy < midY) {
                        hitMidY = -1;
                    } else if (qy > midY) {
                        hitMidY = 1;
                    }
                }
                ++j;
            }
            if (c == 1 || c == 0 && hitMidX == -1 && hitMidY == -1) {
                bl.add(q);
            } else if (c == 2 || c == 0 && hitMidX == -1 && hitMidY == 1) {
                tl.add(q);
            } else if (c == 4 || c == 0 && hitMidX == 1 && hitMidY == 1) {
                tr.add(q);
            } else if (c == 8 || c == 0 && hitMidX == 1 && hitMidY == -1) {
                br.add(q);
            } else {
                geom.add(q);
            }
            ++i;
        }
        int totalGeometry = geom.size();
        if (totalGeometry > 0) {
            int i2 = 0;
            while (i2 < totalGeometry) {
                GeometryStorage.Geometry q = (GeometryStorage.Geometry)geom.get(i2);
                q.getCoords(v);
                Box b = Box.computeAABB(v);
                float z = b.pz;
                minZ = Math.min(z, minZ);
                maxZ = Math.max(z, maxZ);
                z = b.ez;
                minZ = Math.min(z, minZ);
                maxZ = Math.max(z, maxZ);
                ++i2;
            }
            this.contents = new GeometryStorage.Geometry[totalGeometry];
            geom.toArray(this.contents);
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        } else {
            this.contents = null;
        }
        bl.trimToSize();
        if (bl.size() > 0) {
            this.bottom_left = new QuadTree(bl, minContents, minSize, this.x, this.y, sizeBy2);
            totalGeometry += this.bottom_left.totalGeometry;
            minZ = Math.min(minZ, this.bottom_left.minZ);
            maxZ = Math.max(maxZ, this.bottom_left.maxZ);
        } else {
            this.bottom_left = null;
        }
        tl.trimToSize();
        if (tl.size() > 0) {
            this.top_left = new QuadTree(tl, minContents, minSize, this.x, this.y + sizeBy2, sizeBy2);
            totalGeometry += this.top_left.totalGeometry;
            minZ = Math.min(minZ, this.top_left.minZ);
            maxZ = Math.max(maxZ, this.top_left.maxZ);
        } else {
            this.top_left = null;
        }
        tr.trimToSize();
        if (tr.size() > 0) {
            this.top_right = new QuadTree(tr, minContents, minSize, this.x + sizeBy2, this.y + sizeBy2, sizeBy2);
            totalGeometry += this.top_right.totalGeometry;
            minZ = Math.min(minZ, this.top_right.minZ);
            maxZ = Math.max(maxZ, this.top_right.maxZ);
        } else {
            this.top_right = null;
        }
        br.trimToSize();
        if (br.size() > 0) {
            this.bottom_right = new QuadTree(br, minContents, minSize, this.x + sizeBy2, this.y, sizeBy2);
            totalGeometry += this.bottom_right.totalGeometry;
            minZ = Math.min(minZ, this.bottom_right.minZ);
            maxZ = Math.max(maxZ, this.bottom_right.maxZ);
        } else {
            this.bottom_right = null;
        }
        this.minZ = minZ;
        this.maxZ = maxZ;
        this.totalGeometry = totalGeometry;
    }

    public void addAll(ObjectList insideContents) {
        this.visible = true;
        if (this.contents != null) {
            insideContents.addAll(this.contents);
        }
        if (this.bottom_left != null) {
            this.bottom_left.addAll(insideContents);
        }
        if (this.top_left != null) {
            this.top_left.addAll(insideContents);
        }
        if (this.top_right != null) {
            this.top_right.addAll(insideContents);
        }
        if (this.bottom_right != null) {
            this.bottom_right.addAll(insideContents);
        }
    }

    public float getMaxZ() {
        return this.maxZ;
    }

    public float getMinZ() {
        return this.minZ;
    }

    public float getSize() {
        return this.size;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void revisible(Classifier frustum, ObjectList visibleContents, int threshold) {
        Classifier.Classification classification;
        if (!this.visible) {
            return;
        }
        if (this.totalGeometry <= threshold) {
            this.addAll(visibleContents);
            return;
        }
        Box box = g_box;
        synchronized (box) {
            g_box.setPosition(this.x, this.y, this.minZ);
            g_box.setExtent(this.x + this.size, this.y + this.size, this.maxZ);
            classification = frustum.classify(g_box);
        }
        if (classification == Classifier.INSIDE) {
            this.addAll(visibleContents);
        } else {
            if (classification == Classifier.OUTSIDE) {
                return;
            }
            if (classification == Classifier.ENCLOSING || classification == Classifier.SPANNING) {
                if (this.contents != null) {
                    visibleContents.addAll(this.contents);
                }
                if (this.bottom_left != null) {
                    this.bottom_left.revisible(frustum, visibleContents, threshold);
                }
                if (this.top_left != null) {
                    this.top_left.revisible(frustum, visibleContents, threshold);
                }
                if (this.top_right != null) {
                    this.top_right.revisible(frustum, visibleContents, threshold);
                }
                if (this.bottom_right != null) {
                    this.bottom_right.revisible(frustum, visibleContents, threshold);
                }
            } else {
                System.out.println("Unknown classification " + classification);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visible(Classifier frustum, ObjectList visibleContents, int threshold) {
        Classifier.Classification classification;
        if (this.totalGeometry <= threshold) {
            this.addAll(visibleContents);
            return;
        }
        Box box = g_box;
        synchronized (box) {
            g_box.setPosition(this.x, this.y, this.minZ);
            g_box.setExtent(this.x + this.size, this.y + this.size, this.maxZ);
            classification = frustum.classify(g_box);
        }
        if (classification == Classifier.INSIDE) {
            this.addAll(visibleContents);
        } else {
            if (classification == Classifier.OUTSIDE) {
                this.visible = false;
                return;
            }
            if (classification == Classifier.ENCLOSING || classification == Classifier.SPANNING) {
                this.visible = true;
                if (this.contents != null) {
                    visibleContents.addAll(this.contents);
                }
                if (this.bottom_left != null) {
                    this.bottom_left.visible(frustum, visibleContents, threshold);
                }
                if (this.top_left != null) {
                    this.top_left.visible(frustum, visibleContents, threshold);
                }
                if (this.top_right != null) {
                    this.top_right.visible(frustum, visibleContents, threshold);
                }
                if (this.bottom_right != null) {
                    this.bottom_right.visible(frustum, visibleContents, threshold);
                }
            } else {
                System.out.println("Unknown classification " + classification);
            }
        }
    }
}

