/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.geometry.storage;

import com.shavenpuppy.jglib.geometry.Box;
import com.shavenpuppy.jglib.geometry.Classifier;
import com.shavenpuppy.jglib.geometry.Frustum;
import com.shavenpuppy.jglib.geometry.Plane;
import com.shavenpuppy.jglib.geometry.storage.GeometryStorage;
import com.shavenpuppy.jglib.opengl.GLFrustum;
import com.shavenpuppy.jglib.util.ObjectList;
import java.io.Serializable;
import java.util.ArrayList;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector3f;

public class BiTree
implements Serializable,
GeometryStorage {
    protected final BiTree[] node;
    protected final Box box;
    protected final GeometryStorage.Geometry[] contents;
    protected final int totalGeometry;
    private boolean visible;
    private static final transient ArrayList v = new ArrayList();
    private static final Plane[] plane = new Plane[]{new Plane(1.0f, 0.0f, 0.0f, 0.0f), new Plane(0.0f, 1.0f, 0.0f, 0.0f), new Plane(0.0f, 0.0f, 1.0f, 0.0f)};

    public BiTree(ObjectList newContents, int minContents, float minSize) {
        Plane p;
        int newContentsSize = newContents.size();
        v.clear();
        int i = 0;
        while (i < newContentsSize) {
            GeometryStorage.Geometry g = (GeometryStorage.Geometry)newContents.get(i);
            g.getCoords(v);
            ++i;
        }
        this.box = Box.computeAABB(v);
        if (this.box.ex - this.box.px <= minSize && this.box.ey - this.box.py <= minSize && this.box.ez - this.box.pz <= minSize || newContentsSize <= minContents) {
            this.totalGeometry = newContents.size();
            this.contents = new GeometryStorage.Geometry[this.totalGeometry];
            newContents.toArray(this.contents);
            this.node = null;
            return;
        }
        float lx = this.box.ex - this.box.px;
        float ly = this.box.ey - this.box.py;
        float lz = this.box.ez - this.box.pz;
        if (lx >= ly) {
            if (lx >= lz) {
                p = plane[0];
                p.d = (this.box.ex + this.box.px) * -0.5f;
            } else {
                p = plane[2];
                p.d = (this.box.ez + this.box.pz) * -0.5f;
            }
        } else if (lz >= ly) {
            p = plane[2];
            p.d = (this.box.ez + this.box.pz) * -0.5f;
        } else {
            p = plane[1];
            p.d = (this.box.ey + this.box.py) * -0.5f;
        }
        ObjectList[] child = new ObjectList[2];
        int i2 = 0;
        while (i2 < 2) {
            child[i2] = new ObjectList(Math.max(1, newContentsSize >> 2));
            ++i2;
        }
        ObjectList geom = new ObjectList(Math.max(1, newContentsSize >> 4));
        int i3 = 0;
        while (i3 < newContentsSize) {
            GeometryStorage.Geometry q = (GeometryStorage.Geometry)newContents.get(i3);
            v.clear();
            q.getCoords(v);
            int length = v.size();
            Plane.Classification classification = Plane.COINCIDENT;
            int j = 0;
            while (j < length) {
                Vector3f vec = (Vector3f)v.get(j);
                classification = classification.add(p.classify(vec));
                ++j;
            }
            if (classification == Plane.IN_FRONT_OF) {
                child[0].add(q);
            } else if (classification == Plane.BEHIND) {
                child[1].add(q);
            } else {
                geom.add(q);
            }
            ++i3;
        }
        int totalGeometry = geom.size();
        if (totalGeometry > 0) {
            this.contents = new GeometryStorage.Geometry[totalGeometry];
            geom.toArray(this.contents);
        } else {
            int i4 = 0;
            while (i4 < 2) {
                if (child[i4].size() == newContentsSize) {
                    this.totalGeometry = newContentsSize;
                    this.contents = new GeometryStorage.Geometry[this.totalGeometry];
                    child[i4].toArray(this.contents);
                    this.node = null;
                    return;
                }
                ++i4;
            }
            this.contents = null;
        }
        int numNodes = 0;
        int i5 = 0;
        while (i5 < 2) {
            if (child[i5].size() > 0) {
                ++numNodes;
            } else {
                child[i5] = null;
            }
            ++i5;
        }
        if (numNodes > 0) {
            this.node = new BiTree[numNodes];
            numNodes = 0;
            i5 = 0;
            while (i5 < 2) {
                if (child[i5] != null) {
                    this.node[numNodes] = new BiTree(child[i5], minContents, minSize);
                    totalGeometry += this.node[numNodes++].totalGeometry;
                }
                ++i5;
            }
        } else {
            this.node = null;
        }
        this.totalGeometry = totalGeometry;
    }

    public void addAll(ObjectList insideContents) {
        this.visible = true;
        if (this.contents != null) {
            insideContents.addAll(this.contents);
        }
        if (this.node != null) {
            int i = 0;
            while (i < this.node.length) {
                if (this.node[i] != null) {
                    this.node[i].addAll(insideContents);
                }
                ++i;
            }
        }
    }

    public void revisible(Classifier frustum, ObjectList visibleContents, int threshold) {
        if (!this.visible) {
            return;
        }
        if (this.totalGeometry <= threshold) {
            this.addAll(visibleContents);
            return;
        }
        Classifier.Classification classification = frustum.classify(this.box);
        if (classification == Frustum.INSIDE) {
            this.addAll(visibleContents);
        } else {
            if (classification == Frustum.OUTSIDE) {
                return;
            }
            if (classification == Frustum.ENCLOSING || classification == Frustum.SPANNING) {
                if (this.contents != null) {
                    visibleContents.addAll(this.contents);
                }
                if (this.node != null) {
                    int i = 0;
                    while (i < this.node.length) {
                        if (this.node[i] != null) {
                            this.node[i].visible(frustum, visibleContents, threshold);
                        }
                        ++i;
                    }
                }
            } else {
                System.out.println("Unknown classification " + classification);
            }
        }
    }

    public void visible(Classifier frustum, ObjectList visibleContents, int threshold) {
        if (this.totalGeometry <= threshold) {
            this.addAll(visibleContents);
            return;
        }
        Classifier.Classification classification = frustum.classify(this.box);
        if (classification == Frustum.INSIDE) {
            this.addAll(visibleContents);
        } else {
            if (classification == Frustum.OUTSIDE) {
                this.visible = false;
                return;
            }
            if (classification == Frustum.ENCLOSING || classification == Frustum.SPANNING) {
                this.visible = true;
                if (this.contents != null) {
                    visibleContents.addAll(this.contents);
                }
                if (this.node != null) {
                    int i = 0;
                    while (i < this.node.length) {
                        if (this.node[i] != null) {
                            this.node[i].visible(frustum, visibleContents, threshold);
                        }
                        ++i;
                    }
                }
            } else {
                System.out.println("Unknown classification " + classification);
            }
        }
    }

    public void render() {
        GLFrustum frustum = new GLFrustum();
        frustum.extract();
        GL11.glEnable((int)3042);
        GL11.glShadeModel((int)7425);
        GL11.glBlendFunc((int)770, (int)771);
        this.render(frustum);
    }

    private void color(GLFrustum f, float x, float y, float z) {
        Classifier.Classification c = f.classify(x, y, z);
        if (c == Classifier.INSIDE) {
            GL11.glColor4ub((byte)0, (byte)-1, (byte)0, (byte)-128);
        } else if (c == Classifier.OUTSIDE) {
            GL11.glColor4ub((byte)-1, (byte)0, (byte)0, (byte)-128);
        } else {
            GL11.glColor4ub((byte)0, (byte)0, (byte)-1, (byte)-128);
        }
        GL11.glVertex3f((float)x, (float)y, (float)z);
    }

    private void render(GLFrustum frustum) {
        GL11.glBegin((int)2);
        this.color(frustum, this.box.px, this.box.py, this.box.pz);
        this.color(frustum, this.box.ex, this.box.py, this.box.pz);
        this.color(frustum, this.box.ex, this.box.ey, this.box.pz);
        this.color(frustum, this.box.px, this.box.ey, this.box.pz);
        GL11.glEnd();
        GL11.glBegin((int)2);
        this.color(frustum, this.box.px, this.box.py, this.box.ez);
        this.color(frustum, this.box.ex, this.box.py, this.box.ez);
        this.color(frustum, this.box.ex, this.box.ey, this.box.ez);
        this.color(frustum, this.box.px, this.box.ey, this.box.ez);
        GL11.glEnd();
        GL11.glBegin((int)1);
        this.color(frustum, this.box.px, this.box.py, this.box.pz);
        this.color(frustum, this.box.px, this.box.py, this.box.ez);
        this.color(frustum, this.box.ex, this.box.py, this.box.pz);
        this.color(frustum, this.box.ex, this.box.py, this.box.ez);
        this.color(frustum, this.box.ex, this.box.ey, this.box.pz);
        this.color(frustum, this.box.ex, this.box.ey, this.box.ez);
        this.color(frustum, this.box.px, this.box.ey, this.box.pz);
        this.color(frustum, this.box.px, this.box.ey, this.box.ez);
        GL11.glEnd();
        if (this.node != null && this.visible) {
            int i = 0;
            while (i < this.node.length) {
                this.node[i].render(frustum);
                ++i;
            }
        }
    }
}

