/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.algorithms;

import com.shavenpuppy.jglib.interpolators.Interpolator;
import com.shavenpuppy.jglib.interpolators.LinearInterpolator;

public class PerlinNoise {
    private final Interpolator interpolator;
    private final float persistence;
    private final int octaves;
    private final int scale;
    private final int seed;

    public PerlinNoise(int seed, int scale, int octaves, float persistence) {
        this(seed, scale, octaves, persistence, LinearInterpolator.instance);
    }

    public PerlinNoise(int seed, int scale, int octaves, float persistence, Interpolator i) {
        this.seed = seed;
        this.scale = scale;
        this.octaves = octaves;
        this.persistence = persistence;
        this.interpolator = i;
    }

    public float fireNoise(int x, int y) {
        float total = 0.0f;
        float amplitude = this.persistence;
        int frequency = 1;
        int i = 0;
        while (i < this.octaves) {
            total += Math.abs(this.interpolatedNoise(x * frequency, y * frequency)) * amplitude;
            amplitude /= 2.0f;
            frequency <<= 1;
            ++i;
        }
        return total;
    }

    public float interpolatedNoise(int x, int y) {
        int iX = x / this.scale;
        float fX = (float)(x % this.scale) / (float)this.scale;
        int iY = y / this.scale;
        float fY = (float)(y % this.scale) / (float)this.scale;
        float v1 = this.noise(iX, iY);
        float v2 = this.noise(iX + 1, iY);
        float v3 = this.noise(iX, iY + 1);
        float v4 = this.noise(iX + 1, iY + 1);
        float i1 = this.interpolator.interpolate(v1, v2, fX);
        float i2 = this.interpolator.interpolate(v3, v4, fX);
        return this.interpolator.interpolate(i1, i2, fY);
    }

    public float noise(int x, int y) {
        int n = x + y * (57 + this.seed);
        n = n << 13 ^ n;
        return 1.0f - (float)(n * (n * n * 15731 + 789221) + 1376312589 & Integer.MAX_VALUE) / 1.0737418E9f;
    }

    public float perlinNoise(int x, int y) {
        float total = 0.0f;
        float amplitude = 1.0f;
        int frequency = 1;
        int i = 0;
        while (i < this.octaves) {
            total += this.interpolatedNoise(x * frequency, y * frequency) * amplitude;
            amplitude *= this.persistence;
            frequency <<= 1;
            ++i;
        }
        return total;
    }

    public float smoothInterpolatedNoise(int x, int y) {
        int iX = x / this.scale;
        float fX = (float)(x % this.scale) / (float)this.scale;
        int iY = y / this.scale;
        float fY = (float)(y % this.scale) / (float)this.scale;
        float v1 = this.smoothNoise(iX, iY);
        float v2 = this.smoothNoise(iX + 1, iY);
        float v3 = this.smoothNoise(iX, iY + 1);
        float v4 = this.smoothNoise(iX + 1, iY + 1);
        float i1 = this.interpolator.interpolate(v1, v2, fX);
        float i2 = this.interpolator.interpolate(v3, v4, fX);
        return this.interpolator.interpolate(i1, i2, fY);
    }

    public float smoothNoise(int x, int y) {
        float corners = (this.noise(x - 1, y - 1) + this.noise(x + 1, y - 1) + this.noise(x - 1, y + 1) + this.noise(x + 1, y + 1)) / 16.0f;
        float sides = (this.noise(x - 1, y) + this.noise(x + 1, y) + this.noise(x, y - 1) + this.noise(x, y + 1)) / 8.0f;
        float center = this.noise(x, y) / 4.0f;
        return corners + sides + center;
    }
}

