/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.algorithms;

public class Noise {
    private final int d = 16;
    private final int size;
    private final float[] n;
    private final int s;

    public Noise(int size) {
        this.size = size;
        this.n = new float[size * size / 256];
        int i = 0;
        while (i < this.n.length) {
            this.n[i] = (float)(Math.random() * 2.0 - 1.0);
            ++i;
        }
        this.s = size / 16;
    }

    public float getNoise(int x, int y, int scale) {
        int yy1;
        int xx = x * scale / 16 % this.s;
        int yy = y * scale / 16 % this.s;
        int xx1 = xx == this.s - 1 ? 0 : xx + 1;
        int n = yy1 = yy == this.s - 1 ? 0 : yy + 1;
        if (scale == 2 || scale == 0) {
            return 0.0f;
        }
        float x0y0 = this.n[xx + yy * this.s];
        float x1y0 = this.n[xx1 + yy * this.s];
        float x1y1 = this.n[xx1 + yy1 * this.s];
        float x0y1 = this.n[xx + yy1 * this.s];
        int xfrac = x * scale % 16;
        float xxfrac = (float)xfrac / 16.0f;
        int yfrac = y * scale % 16;
        float yyfrac = (float)yfrac / 16.0f;
        float n0 = x0y0 * (1.0f - yyfrac) + x0y1 * yyfrac;
        float n1 = x1y0 * (1.0f - yyfrac) + x1y1 * yyfrac;
        float nn = n0 * (1.0f - xxfrac) + n1 * xxfrac;
        return nn / (float)scale + this.getNoise(x, y, scale << 1);
    }
}

