/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.algorithms;

import com.shavenpuppy.jglib.algorithms.PathFinderInt;
import com.shavenpuppy.jglib.util.IntList;
import java.util.Arrays;
import java.util.Comparator;

public class AStarInt
implements PathFinderInt {
    private final int maxNodes;
    private final NodeList openList;
    private final NodeList closedList;
    private final PathFinderInt.Map map;
    private IntList neighbours = new IntList(true, 8);
    private Node end;
    private Node start;
    private int steps;
    private IntList path;
    public static final int SEARCH_STATE_SUCCEEDED = 1;
    public static final int SEARCH_STATE_FAILED = 2;
    public static final int SEARCH_STATE_NOT_INITIALIZED = 3;
    public static final int SEARCH_STATE_INVALID = 4;
    public static final int SEARCH_STATE_CANCELLED = 5;
    public static final int SEARCH_STATE_SEARCHING = 6;
    private int state = 3;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.shavenpuppy.jglib.algorithms.AStarInt");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public AStarInt(PathFinderInt.Map map, int maxNodes) {
        this.map = map;
        this.maxNodes = maxNodes;
        this.openList = new NodeList(maxNodes);
        this.closedList = new NodeList(maxNodes);
    }

    public synchronized void findPath(int startState, int endState, IntList path) {
        this.openList.clear();
        this.closedList.clear();
        this.steps = 0;
        this.path = path;
        this.state = 6;
        this.start = new Node(startState, null);
        this.openList.addNode(this.start);
        this.start.g = 0;
        this.start.f = this.start.h = this.map.getDistance(startState, endState);
        this.end = new Node(endState, null);
    }

    public synchronized void cancel() {
        this.state = 5;
        this.cleanup();
    }

    private void cleanup() {
        this.openList.clear();
        this.closedList.clear();
        this.neighbours.clear();
    }

    public synchronized int nextStep() {
        if (this.state == 2 || this.state == 1 || this.state == 5) {
            return this.state;
        }
        if (!$assertionsDisabled && this.state != 6) {
            throw new AssertionError();
        }
        if (this.openList.isEmpty()) {
            this.state = 2;
            this.cleanup();
            return this.state;
        }
        ++this.steps;
        Node n = this.openList.popHead();
        if (n.equals(this.end)) {
            this.goalFound(n);
        } else {
            this.goalNotFound(n);
        }
        return this.state;
    }

    private void goalFound(Node n) {
        System.out.println("GOAL FOUND in " + this.steps + " steps!");
        this.end.parent = n.parent;
        this.path.clear();
        if (n != this.start) {
            Node nodeChild = n;
            Node nodeParent = n.parent;
            do {
                nodeParent.child = nodeChild;
                nodeChild = nodeParent;
                nodeParent = nodeParent.parent;
            } while (!nodeChild.equals(this.start));
            n = this.start;
            do {
                if ((n = n.child) == null) continue;
                this.path.add(n.userState);
            } while (!n.equals(this.end));
        }
        this.state = 1;
        this.cleanup();
    }

    private void goalNotFound(Node n) {
        this.map.getNeighbours(n.userState, n.parent != null ? n.parent.userState : -1, this.neighbours);
        int numNeighbours = this.neighbours.size();
        int i = 0;
        while (i < numNeighbours) {
            Node foundOnClosedList;
            int newState = this.neighbours.get(i);
            int newg = n.g + this.map.getCost(n.userState, newState);
            Node foundOnOpenList = this.openList.getNode(newState);
            if (!(foundOnOpenList != null && foundOnOpenList.g <= newg || (foundOnClosedList = this.closedList.getNode(newState)) != null && foundOnClosedList.g <= newg)) {
                if (foundOnClosedList != null) {
                    this.closedList.removeNode(foundOnClosedList.userState);
                }
                if (foundOnOpenList != null) {
                    this.openList.removeNode(foundOnOpenList.userState);
                }
                Node newNode = new Node(newState, n);
                newNode.g = newg;
                newNode.h = this.map.getDistance(newState, this.end.userState);
                newNode.f = newNode.g + newNode.h;
                if (!this.openList.addNode(newNode)) {
                    this.state = 2;
                    this.cleanup();
                    break;
                }
            }
            ++i;
        }
        if (!this.closedList.addNode(n)) {
            this.state = 2;
            this.cleanup();
        }
    }

    static interface ComparesF {
        public int getF();
    }

    static interface ComparesUserState {
        public int getUserState();
    }

    private static class NodeList {
        final Node[] node;
        int count;
        boolean f_sorted;
        boolean userState_sorted;
        final IntVal intVal = new IntVal();
        Comparator f_comparator = new Comparator(this){
            final /* synthetic */ NodeList this$1;
            {
                this.this$1 = nodeList;
            }

            public int compare(Object o1, Object o2) {
                ComparesF n1 = (ComparesF)o1;
                ComparesF n2 = (ComparesF)o2;
                if (n1 == n2) {
                    return 0;
                }
                if (n1 == null && n2 != null) {
                    return -1;
                }
                if (n1 != null && n2 == null) {
                    return 1;
                }
                return n1.getF() > n2.getF() ? 1 : (n1.getF() == n2.getF() ? 0 : -1);
            }
        };
        Comparator userState_comparator = new Comparator(this){
            final /* synthetic */ NodeList this$1;
            {
                this.this$1 = nodeList;
            }

            public int compare(Object o1, Object o2) {
                ComparesUserState n1 = (ComparesUserState)o1;
                ComparesUserState n2 = (ComparesUserState)o2;
                if (n1 == n2) {
                    return 0;
                }
                if (n1 == null && n2 != null) {
                    return -1;
                }
                if (n1 != null && n2 == null) {
                    return 1;
                }
                return n1.getUserState() > n2.getUserState() ? 1 : (n1.getUserState() == n2.getUserState() ? 0 : -1);
            }
        };
        static final /* synthetic */ boolean $assertionsDisabled;
        static /* synthetic */ Class class$0;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.shavenpuppy.jglib.algorithms.AStarInt$NodeList");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        NodeList(int size) {
            this.node = new Node[size];
        }

        boolean addNode(Node newNode) {
            if (this.count == this.node.length) {
                return false;
            }
            this.f_sorted = false;
            this.userState_sorted = false;
            this.node[this.count++] = newNode;
            return true;
        }

        void removeNode(int userState) {
            if (!$assertionsDisabled && userState == -1) {
                throw new AssertionError();
            }
            int index = this.findNode(userState);
            if (!$assertionsDisabled && index == -1) {
                throw new AssertionError();
            }
            this.f_sorted = false;
            this.userState_sorted = false;
            this.node[index] = this.node[--this.count];
            this.node[this.count] = null;
        }

        int findNode(int userState) {
            int ret;
            if (!$assertionsDisabled && userState == -1) {
                throw new AssertionError();
            }
            if (this.count > 0 && !this.userState_sorted) {
                Arrays.sort(this.node, 0, this.count, this.userState_comparator);
                this.userState_sorted = true;
                this.f_sorted = false;
            }
            if ((ret = Arrays.binarySearch(this.node, this.intVal.set(userState), this.f_comparator)) < 0 || ret >= this.count) {
                return -1;
            }
            if (this.node[ret].userState != userState) {
                return -1;
            }
            return ret;
        }

        Node getNode(int userState) {
            int index = this.findNode(userState);
            if (index == -1) {
                return null;
            }
            if (this.node[index].userState == userState) {
                return this.node[index];
            }
            return null;
        }

        void clear() {
            int i = 0;
            while (i < this.count) {
                this.node[i] = null;
                ++i;
            }
            this.count = 0;
        }

        int size() {
            return this.count;
        }

        boolean isEmpty() {
            return this.count == 0;
        }

        Node popHead() {
            if (this.count > 0 && !this.f_sorted) {
                Arrays.sort(this.node, 0, this.count, this.f_comparator);
                this.userState_sorted = false;
                this.f_sorted = true;
            }
            Node ret = this.node[0];
            this.node[0] = this.node[--this.count];
            this.node[this.count] = null;
            return ret;
        }

        static class IntVal
        implements ComparesF,
        ComparesUserState {
            int val;

            IntVal() {
            }

            public boolean equals(Object o) {
                return ((Node)o).userState == this.val;
            }

            IntVal set(int v) {
                this.val = v;
                return this;
            }

            public int getF() {
                return this.val;
            }

            public int getUserState() {
                return this.val;
            }
        }
    }

    private static class Node
    implements ComparesF,
    ComparesUserState {
        Node parent;
        Node child;
        int g;
        int h;
        int f;
        int userState;

        Node(int userState, Node parent) {
            this.userState = userState;
            this.parent = parent;
        }

        public int getF() {
            return this.f;
        }

        public int getUserState() {
            return this.userState;
        }

        public boolean equals(Object obj) {
            return ((Node)obj).userState == this.userState;
        }

        void dup(Node src) {
            this.g = src.g;
            this.h = src.h;
            this.f = src.f;
        }
    }
}

