/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib;

import com.shavenpuppy.jglib.Palette;
import com.shavenpuppy.jglib.resources.ImageWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class Image
implements Serializable,
ImageWrapper {
    static final long serialVersionUID = 6L;
    private static JPEGCompressor compressor;
    private static JPEGDecompressor decompressor;
    private transient ByteBuffer data;
    private int width;
    private int height;
    private int type;
    private boolean useJPEG;
    private Palette palette;
    public static final int RGB = 0;
    public static final int RGBA = 1;
    public static final int LUMINANCE = 2;
    public static final int LUMINANCE_ALPHA = 3;
    public static final int ARGB = 4;
    public static final int ABGR = 5;
    public static final int BGR = 6;
    public static final int BGRA = 7;
    public static final int PALETTED = 8;
    private static final int[] typeToSize;
    private static final int MAGIC = 61451;
    private static final int VERSION = 2;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.shavenpuppy.jglib.Image");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        typeToSize = new int[]{3, 4, 1, 2, 4, 4, 3, 4, 1};
    }

    public Image() {
    }

    public void dispose() {
        this.data = null;
        this.palette = null;
    }

    public Image(int width, int height, int type) {
        this.width = width;
        this.height = height;
        this.type = type;
        this.data = ByteBuffer.allocateDirect(width * height * typeToSize[type]).order(ByteOrder.nativeOrder());
        if (type == 8) {
            this.palette = new Palette(3, 256);
        }
    }

    public Image(int width, int height, int type, byte[] img) {
        this.width = width;
        this.height = height;
        this.type = type;
        if (!$assertionsDisabled && width * height * typeToSize[type] != img.length) {
            throw new AssertionError((Object)"Image is incorrect size.");
        }
        this.data = ByteBuffer.allocateDirect(img.length).order(ByteOrder.nativeOrder());
        this.data.put(img);
        this.data.flip();
        if (type == 8) {
            this.palette = new Palette(3, 256);
        }
    }

    public Image(int width, int height, int type, ByteBuffer imageData) {
        this.width = width;
        this.height = height;
        this.type = type;
        if (!$assertionsDisabled && width * height * typeToSize[type] != imageData.remaining()) {
            throw new AssertionError((Object)"Image is incorrect size.");
        }
        if (!$assertionsDisabled && !imageData.isDirect()) {
            throw new AssertionError((Object)"Image must be stored in a direct byte buffer.");
        }
        this.data = imageData.slice();
        if (type == 8) {
            this.palette = new Palette(3, 256);
        }
    }

    public static Image read(InputStream is) throws Exception {
        return (Image)new ObjectInputStream(is).readObject();
    }

    public static void write(Image image, OutputStream os) throws Exception {
        ObjectOutputStream oos = new ObjectOutputStream(os);
        oos.writeObject(image);
        oos.flush();
        oos.reset();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        this.data.rewind();
        if (this.useJPEG && this.hasAlpha() && typeToSize[this.type] == 4) {
            ByteBuffer compressed;
            ByteBuffer bgr = this.extractBGR();
            try {
                compressed = compressor.compress(this.width, this.height, bgr);
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                throw new IOException("Failed to compress: " + e.getMessage());
            }
            stream.writeInt(compressed.capacity());
            System.out.println("Compressed image to " + compressed.capacity() + " bytes, down from " + this.width * this.height * 4);
            stream.write(compressed.array());
            compressed = this.createAlphaDelta();
            stream.write(compressed.array());
        } else {
            ByteBuffer split = this.splitIntoPlanes();
            split.rewind();
            stream.write(split.array());
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int length = this.width * this.height * typeToSize[this.type];
        this.data = ByteBuffer.allocateDirect(length).order(ByteOrder.nativeOrder());
        if (this.useJPEG && this.hasAlpha() && typeToSize[this.type] == 4) {
            int compressedSize = stream.readInt();
            ByteBuffer compressed = ByteBuffer.allocate(compressedSize);
            byte[] buf = new byte[compressedSize];
            stream.readFully(buf);
            compressed.put(buf);
            ByteBuffer uncompressed = ByteBuffer.allocate(this.width * this.height * 3);
            try {
                decompressor.decompress(compressed, uncompressed);
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                throw new IOException("Failed to decompress: " + e.getMessage());
            }
            this.insertBGR(uncompressed);
            ByteBuffer alphaDelta = ByteBuffer.allocate(this.width * this.height);
            buf = null;
            buf = new byte[this.width * this.height];
            stream.readFully(buf);
            alphaDelta.put(buf).rewind();
            this.mergeAlphaDelta(alphaDelta);
        } else {
            ByteBuffer deltaPlanes = ByteBuffer.allocate(length);
            byte[] buf = new byte[length];
            stream.readFully(buf);
            deltaPlanes.put(buf);
            this.mergePlanes(deltaPlanes);
        }
    }

    private static boolean isPowerOf2(int n) {
        int i = 0;
        int p = 1;
        while (i < 32) {
            if ((n & p) == p) break;
            p <<= 1;
            ++i;
        }
        while (i < 31) {
            if ((n & (p <<= 1)) == p) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private ByteBuffer extractBGR() {
        ByteBuffer ret = ByteBuffer.allocate(this.width * this.height * 3);
        int n = this.width * this.height * 4;
        switch (this.type) {
            case 1: {
                int i = 0;
                while (i < n) {
                    ret.put(this.data.get(i + 2));
                    ret.put(this.data.get(i + 1));
                    ret.put(this.data.get(i + 0));
                    i += 4;
                }
                break;
            }
            case 7: {
                int i = 0;
                while (i < n) {
                    ret.put(this.data.get(i + 0));
                    ret.put(this.data.get(i + 1));
                    ret.put(this.data.get(i + 2));
                    i += 4;
                }
                break;
            }
            case 4: {
                int i = 0;
                while (i < n) {
                    ret.put(this.data.get(i + 3));
                    ret.put(this.data.get(i + 2));
                    ret.put(this.data.get(i + 1));
                    i += 4;
                }
                break;
            }
            case 5: {
                int i = 0;
                while (i < n) {
                    ret.put(this.data.get(i + 1));
                    ret.put(this.data.get(i + 2));
                    ret.put(this.data.get(i + 3));
                    i += 4;
                }
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                break;
            }
        }
        return ret;
    }

    private void insertBGR(ByteBuffer buf) {
        int n = this.width * this.height * 4;
        switch (this.type) {
            case 1: {
                int i = 0;
                while (i < n) {
                    this.data.put(i + 2, buf.get());
                    this.data.put(i + 1, buf.get());
                    this.data.put(i + 0, buf.get());
                    i += 4;
                }
                break;
            }
            case 7: {
                int i = 0;
                while (i < n) {
                    this.data.put(i + 0, buf.get());
                    this.data.put(i + 1, buf.get());
                    this.data.put(i + 2, buf.get());
                    i += 4;
                }
                break;
            }
            case 4: {
                int i = 0;
                while (i < n) {
                    this.data.put(i + 3, buf.get());
                    this.data.put(i + 2, buf.get());
                    this.data.put(i + 1, buf.get());
                    i += 4;
                }
                break;
            }
            case 5: {
                int i = 0;
                while (i < n) {
                    this.data.put(i + 1, buf.get());
                    this.data.put(i + 2, buf.get());
                    this.data.put(i + 3, buf.get());
                    i += 4;
                }
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                break;
            }
        }
    }

    private ByteBuffer splitIntoPlanes() {
        ByteBuffer buf = ByteBuffer.allocate(this.data.capacity());
        switch (this.type) {
            case 2: 
            case 8: {
                buf.put(this.data);
                return buf;
            }
            case 3: {
                buf.position(buf.capacity() / 2);
                ByteBuffer alpha = buf.slice();
                buf.position(0);
                int y = 0;
                while (y < this.height) {
                    byte ol = 0;
                    byte oa = 0;
                    byte nl = 0;
                    byte na = 0;
                    int x = 0;
                    while (x < this.width) {
                        nl = this.data.get();
                        na = this.data.get();
                        buf.put((byte)(nl - ol));
                        alpha.put((byte)(na - oa));
                        ol = nl;
                        oa = na;
                        ++x;
                    }
                    ++y;
                }
                break;
            }
            case 0: 
            case 6: {
                buf.position(buf.capacity() / 3);
                ByteBuffer buf1 = buf.slice();
                buf.position(2 * buf.capacity() / 3);
                ByteBuffer buf2 = buf.slice();
                buf.position(0);
                int y = 0;
                while (y < this.height) {
                    byte o0 = 0;
                    byte o1 = 0;
                    byte o2 = 0;
                    byte n0 = 0;
                    byte n1 = 0;
                    byte n2 = 0;
                    int x = 0;
                    while (x < this.width) {
                        n0 = this.data.get();
                        n1 = this.data.get();
                        n2 = this.data.get();
                        buf.put((byte)(n0 - o0));
                        buf1.put((byte)(n1 - o1));
                        buf2.put((byte)(n2 - o2));
                        o0 = n0;
                        o1 = n1;
                        o2 = n2;
                        ++x;
                    }
                    ++y;
                }
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: {
                buf.position(buf.capacity() / 4);
                ByteBuffer buf1 = buf.slice();
                buf.position(2 * buf.capacity() / 4);
                ByteBuffer buf2 = buf.slice();
                buf.position(3 * buf.capacity() / 4);
                ByteBuffer buf3 = buf.slice();
                buf.position(0);
                int y = 0;
                while (y < this.height) {
                    byte o0 = 0;
                    byte o1 = 0;
                    byte o2 = 0;
                    byte o3 = 0;
                    byte n0 = 0;
                    byte n1 = 0;
                    byte n2 = 0;
                    byte n3 = 0;
                    int x = 0;
                    while (x < this.width) {
                        n0 = this.data.get();
                        n1 = this.data.get();
                        n2 = this.data.get();
                        n3 = this.data.get();
                        buf.put((byte)(n0 - o0));
                        buf1.put((byte)(n1 - o1));
                        buf2.put((byte)(n2 - o2));
                        buf3.put((byte)(n3 - o3));
                        o0 = n0;
                        o1 = n1;
                        o2 = n2;
                        o3 = n3;
                        ++x;
                    }
                    ++y;
                }
                break;
            }
        }
        this.data.rewind();
        return buf;
    }

    private ByteBuffer createAlphaDelta() {
        ByteBuffer buf = ByteBuffer.allocate(this.width * this.height);
        int pos = this.type == 1 || this.type == 7 ? 3 : 0;
        int y = 0;
        while (y < this.height) {
            byte o0 = 0;
            byte n0 = 0;
            int x = 0;
            while (x < this.width) {
                n0 = this.data.get(pos);
                buf.put((byte)(n0 - o0));
                o0 = n0;
                pos += 4;
                ++x;
            }
            ++y;
        }
        return buf;
    }

    private void mergePlanes(ByteBuffer buf) {
        buf.flip();
        switch (this.type) {
            case 2: 
            case 8: {
                this.data.put(buf);
                return;
            }
            case 3: {
                buf.position(buf.capacity() / 2);
                ByteBuffer alpha = buf.slice();
                buf.position(0);
                int y = 0;
                while (y < this.height) {
                    int ol = 0;
                    int oa = 0;
                    int x = 0;
                    while (x < this.width) {
                        this.data.put((byte)(ol += buf.get()));
                        this.data.put((byte)(oa += alpha.get()));
                        ++x;
                    }
                    ++y;
                }
                break;
            }
            case 0: 
            case 6: {
                buf.position(buf.capacity() / 3);
                ByteBuffer buf0 = buf.slice();
                buf.position(2 * buf.capacity() / 3);
                ByteBuffer buf1 = buf.slice();
                buf.position(0);
                int y = 0;
                while (y < this.height) {
                    int o0 = 0;
                    int o1 = 0;
                    int o2 = 0;
                    int x = 0;
                    while (x < this.width) {
                        this.data.put((byte)(o0 += buf.get()));
                        this.data.put((byte)(o1 += buf0.get()));
                        this.data.put((byte)(o2 += buf1.get()));
                        ++x;
                    }
                    ++y;
                }
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: {
                buf.position(buf.capacity() / 4);
                ByteBuffer buf0 = buf.slice();
                buf.position(2 * buf.capacity() / 4);
                ByteBuffer buf1 = buf.slice();
                buf.position(3 * buf.capacity() / 4);
                ByteBuffer buf2 = buf.slice();
                buf.position(0);
                int y = 0;
                while (y < this.height) {
                    int o0 = 0;
                    int o1 = 0;
                    int o2 = 0;
                    int o3 = 0;
                    int x = 0;
                    while (x < this.width) {
                        o2 += buf1.get();
                        o3 += buf2.get();
                        this.data.put((byte)(o0 += buf.get()));
                        this.data.put((byte)(o1 += buf0.get()));
                        this.data.put((byte)o2);
                        this.data.put((byte)o3);
                        ++x;
                    }
                    ++y;
                }
                break;
            }
        }
        this.data.flip();
    }

    private void mergeAlphaDelta(ByteBuffer buf) {
        int pos = this.type == 1 || this.type == 7 ? 3 : 0;
        int y = 0;
        while (y < this.height) {
            int o0 = 0;
            int x = 0;
            while (x < this.width) {
                this.data.put(pos, (byte)(o0 += buf.get()));
                pos += 4;
                ++x;
            }
            ++y;
        }
    }

    public ByteBuffer getData() {
        return this.data;
    }

    public int getHeight() {
        return this.height;
    }

    public int getType() {
        return this.type;
    }

    public int getWidth() {
        return this.width;
    }

    public String toString() {
        return "Image[" + this.width + "x" + this.height + " type=" + this.type + " length=" + this.data.capacity() + "]";
    }

    public Palette getPalette() {
        return this.palette;
    }

    public void setPalette(Palette palette) {
        if (!$assertionsDisabled && this.type != 8) {
            throw new AssertionError((Object)"Not a paletted image.");
        }
        if (!$assertionsDisabled && palette == null) {
            throw new AssertionError((Object)"Cannot set a null palette.");
        }
        this.palette = palette;
    }

    public void setUseJPEG(boolean useJPEG) {
        this.useJPEG = useJPEG;
    }

    public static void setCompressor(JPEGCompressor compressor) {
        Image.compressor = compressor;
    }

    public static void setDecompressor(JPEGDecompressor decompressor) {
        Image.decompressor = decompressor;
    }

    public boolean hasAlpha() {
        return this.type == 3 || this.type == 1 || this.type == 4 || this.type == 5 || this.type == 7;
    }

    public Image getImage() {
        return this;
    }

    public static interface JPEGCompressor {
        public ByteBuffer compress(int var1, int var2, ByteBuffer var3) throws Exception;
    }

    public static interface JPEGDecompressor {
        public void decompress(ByteBuffer var1, ByteBuffer var2) throws Exception;
    }
}

