/*
 * Decompiled with CFR 0.152.
 */
package com.kaioa.tools.jnlp.muffin;

import com.kaioa.tools.jnlp.muffin.Muffin;
import com.kaioa.tools.jnlp.muffin.MuffinException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.jnlp.BasicService;
import javax.jnlp.FileContents;
import javax.jnlp.PersistenceService;
import javax.jnlp.ServiceManager;
import javax.jnlp.UnavailableServiceException;

public class WebstartMuffin
implements Muffin {
    private static PersistenceService ps;
    private static BasicService bs;
    private URL muffinURL;
    private static final String e_io = "IO trouble\n";
    private static final String e_url = "Malformed URL\n";
    private static final String e_service = "Service unavailable\n";
    private static final String e_granted = "Not enough bytes granted\n";

    public WebstartMuffin(String muffinName) throws MuffinException {
        WebstartMuffin.init();
        try {
            this.muffinURL = new URL(bs.getCodeBase(), muffinName);
        }
        catch (MalformedURLException mue) {
            throw new MuffinException(e_url + mue.getMessage());
        }
    }

    public WebstartMuffin(URL muffinURL) throws MuffinException {
        WebstartMuffin.init();
        this.muffinURL = muffinURL;
    }

    private static void init() throws MuffinException {
        if (ps == null || bs == null) {
            try {
                ps = (PersistenceService)ServiceManager.lookup((String)"javax.jnlp.PersistenceService");
                bs = (BasicService)ServiceManager.lookup((String)"javax.jnlp.BasicService");
            }
            catch (UnavailableServiceException use) {
                throw new MuffinException(e_service + use.getMessage());
            }
        }
    }

    public String toString() {
        return this.muffinURL.getFile();
    }

    public URL getURL() {
        return this.muffinURL;
    }

    public static String[] getNames() throws MuffinException {
        String[] names = null;
        try {
            WebstartMuffin.init();
            names = ps.getNames(bs.getCodeBase());
        }
        catch (MalformedURLException mue) {
            throw new MuffinException(e_url + mue.getMessage());
        }
        catch (IOException ioe) {
            throw new MuffinException(e_io + ioe.getMessage());
        }
        catch (NullPointerException npe) {
            names = new String[]{};
        }
        return names;
    }

    public static String[] getNames(URL url) throws MuffinException {
        String[] names = null;
        try {
            WebstartMuffin.init();
            names = ps.getNames(url);
        }
        catch (MalformedURLException mue) {
            throw new MuffinException(e_url + mue.getMessage());
        }
        catch (IOException ioe) {
            throw new MuffinException(e_io + ioe.getMessage());
        }
        catch (NullPointerException npe) {
            names = new String[]{};
        }
        return names;
    }

    public boolean exists() throws MuffinException {
        String name = this.muffinURL.getPath();
        try {
            String[] names = ps.getNames(bs.getCodeBase());
            if (names != null) {
                int i = 0;
                while (i < names.length) {
                    if (name.endsWith("/" + names[i])) {
                        return true;
                    }
                    ++i;
                }
            }
        }
        catch (MalformedURLException mue) {
            throw new MuffinException(e_url + mue.getMessage());
        }
        catch (IOException ioe) {
            throw new MuffinException(e_io + ioe.getMessage());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return false;
    }

    public int getTag() throws MuffinException {
        int tag = -1;
        try {
            tag = ps.getTag(this.muffinURL);
        }
        catch (MalformedURLException mue) {
            throw new MuffinException(e_url + mue.getMessage());
        }
        catch (IOException ioe) {
            throw new MuffinException(e_io + ioe.getMessage());
        }
        return tag;
    }

    public void setTag(int tag) throws MuffinException {
        try {
            ps.setTag(this.muffinURL, tag);
        }
        catch (MalformedURLException mue) {
            throw new MuffinException(e_url + mue.getMessage());
        }
        catch (IOException ioe) {
            throw new MuffinException(e_io + ioe.getMessage());
        }
    }

    public void delete() throws MuffinException {
        try {
            ps.delete(this.muffinURL);
        }
        catch (MalformedURLException mue) {
            throw new MuffinException(e_url + mue.getMessage());
        }
        catch (IOException ioe) {
            throw new MuffinException(e_io + ioe.getMessage());
        }
    }

    public String readPlainText() throws MuffinException {
        String text = null;
        try {
            DataInputStream is = new DataInputStream(this.getInputStream());
            text = is.readUTF();
            is.close();
        }
        catch (IOException ioe) {
            throw new MuffinException(e_io + ioe.getMessage());
        }
        return text;
    }

    public void writePlainText(String text) throws MuffinException {
        try {
            DataOutputStream os = new DataOutputStream(this.getOutputStream());
            os.writeUTF(text);
            os.flush();
            os.close();
        }
        catch (IOException ioe) {
            throw new MuffinException(e_io + ioe.getMessage());
        }
    }

    public InputStream getInputStream() throws MuffinException {
        try {
            FileContents fc = ps.get(this.muffinURL);
            return fc.getInputStream();
        }
        catch (MalformedURLException mue) {
            throw new MuffinException(e_url + mue.getMessage());
        }
        catch (IOException ioe) {
            throw new MuffinException(e_io + ioe.getMessage());
        }
    }

    public OutputStream getOutputStream() {
        return new MuffinOutputStream();
    }

    private class MuffinOutputStream
    extends OutputStream {
        private byte[] buffer = new byte[this.size];
        private int position = 0;
        private int size = 512;

        public void write(int b) {
            if (this.position > this.size - 1) {
                byte[] newBuffer = new byte[this.size * 2];
                System.arraycopy(this.buffer, 0, newBuffer, 0, this.size);
                this.size *= 2;
                this.buffer = newBuffer;
            }
            this.buffer[this.position] = (byte)b;
            ++this.position;
        }

        public void close() throws IOException {
            try {
                WebstartMuffin.this.delete();
            }
            catch (MuffinException muffinException) {
                // empty catch block
            }
            long granted = ps.create(WebstartMuffin.this.muffinURL, (long)this.position);
            if (granted < (long)this.position) {
                throw new IOException(WebstartMuffin.e_granted);
            }
            FileContents fc = ps.get(WebstartMuffin.this.muffinURL);
            OutputStream os = fc.getOutputStream(false);
            os.write(this.buffer, 0, this.position);
            os.flush();
            os.close();
        }
    }
}

