/*
 * Decompiled with CFR 0.152.
 */
package com.kaioa.tools.jnlp.muffin;

import com.kaioa.tools.jnlp.muffin.Muffin;
import com.kaioa.tools.jnlp.muffin.MuffinException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;

public class FileMuffin
implements Muffin {
    private static String base;
    private static File baseDir;
    private String muffinName;
    private File file;

    public static void setMuffinDirectory(String dir) {
        System.out.println("FileMuffin directory: " + dir);
        base = dir;
        baseDir = new File(base);
    }

    public FileMuffin(String muffinName) throws MuffinException {
        if (base == null) {
            throw new MuffinException("The muffin directory has not been configured. See MuffinProvider.setMuffinDirectory()");
        }
        this.muffinName = muffinName;
        this.create();
    }

    public FileMuffin(URL muffinURL) throws MuffinException {
        if (base == null) {
            throw new MuffinException("The muffin directory has not been configured. See MuffinProvider.setMuffinDirectory()");
        }
        this.muffinName = muffinURL.getPath();
        this.create();
    }

    private void create() throws MuffinException {
        if (this.file == null) {
            this.file = new File(baseDir, this.muffinName);
        }
        if (!this.file.exists()) {
            try {
                new File(this.file, "..").mkdirs();
                this.file.createNewFile();
            }
            catch (IOException e) {
                throw new MuffinException("Failed to create Muffin " + this.file.getAbsolutePath() + ": " + e.getMessage());
            }
        }
    }

    public String toString() {
        return this.muffinName;
    }

    public URL getURL() {
        try {
            return new URL("http://dummy.kaioa.com/" + this.muffinName);
        }
        catch (MalformedURLException mue) {
            return null;
        }
    }

    public static String[] getNames() throws MuffinException {
        return FileMuffin.getNames("");
    }

    private static void addNames(File dir, ArrayList targetList, String match) {
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory()) {
                FileMuffin.addNames(files[i], targetList, match);
            } else {
                String name = files[i].getAbsolutePath().substring(baseDir.getAbsolutePath().length() + 1);
                if (name.startsWith(match)) {
                    targetList.add(name);
                }
            }
            ++i;
        }
    }

    private static String[] getNames(String match) throws MuffinException {
        if (base == null) {
            throw new MuffinException("The muffin directory has not been configured. See MuffinProvider.setMuffinDirectory()");
        }
        ArrayList names = new ArrayList();
        FileMuffin.addNames(baseDir, names, match);
        String[] retVal = new String[names.size()];
        names.toArray(retVal);
        return retVal;
    }

    public static String[] getNames(URL url) throws MuffinException {
        return FileMuffin.getNames(url.getPath());
    }

    public boolean exists() {
        if (this.file == null) {
            return false;
        }
        return this.file.exists();
    }

    public int getTag() throws MuffinException {
        return -1;
    }

    public void setTag(int tag) throws MuffinException {
    }

    public void delete() throws MuffinException {
        if (this.file != null) {
            this.file.delete();
            this.file = null;
        }
    }

    public String readPlainText() throws MuffinException {
        if (this.file == null) {
            throw new MuffinException("Muffin has been deleted");
        }
        try {
            return new DataInputStream(new FileInputStream(this.file)).readUTF();
        }
        catch (Exception e) {
            throw new MuffinException("Failed to read from Muffin: " + e.getMessage());
        }
    }

    public void writePlainText(String text) throws MuffinException {
        this.create();
        try {
            new DataOutputStream(new FileOutputStream(this.file)).writeUTF(text);
        }
        catch (Exception e) {
            throw new MuffinException("Failed to read from Muffin: " + e.getMessage());
        }
    }

    public InputStream getInputStream() throws MuffinException {
        if (this.file != null) {
            try {
                return new FileInputStream(this.file);
            }
            catch (IOException e) {
                throw new MuffinException("Failed to access Muffin: " + e.getMessage());
            }
        }
        throw new MuffinException("Muffin has been deleted");
    }

    public OutputStream getOutputStream() throws MuffinException {
        this.create();
        if (this.file != null) {
            try {
                return new FileOutputStream(this.file);
            }
            catch (IOException e) {
                throw new MuffinException("Failed to access Muffin: " + e.getMessage());
            }
        }
        throw new MuffinException("Muffin has been deleted");
    }
}

