/*
 * Decompiled with CFR 0.152.
 */
package xap.resources;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.util.FPMath;
import com.shavenpuppy.jglib.util.Util;
import com.shavenpuppy.jglib.util.XMLUtil;
import org.w3c.dom.Element;
import xap.Game;
import xap.Moving;
import xap.ParticleSpawning;

public class ParticleSpawningResource
extends Resource {
    public static final long serialVersionUID = 1L;
    private int minDistance;
    private int maxDistance;
    private int minVelocity;
    private int maxVelocity;

    public void load(Element element, Resource.Loader loader) throws Exception {
        this.minDistance = FPMath.fpValue((float)XMLUtil.getFloat((Element)element, (String)"mindistance"));
        this.maxDistance = FPMath.fpValue((float)XMLUtil.getFloat((Element)element, (String)"maxdistance"));
        this.minVelocity = FPMath.fpValue((float)XMLUtil.getFloat((Element)element, (String)"minvelocity"));
        this.maxVelocity = FPMath.fpValue((float)XMLUtil.getFloat((Element)element, (String)"maxvelocity"));
    }

    public ParticleSpawning spawn() {
        return new ParticleSpawningInstance();
    }

    private final class ParticleSpawningInstance
    implements ParticleSpawning {
        ParticleSpawningInstance() {
        }

        public void init(Moving moving) {
            int distance = Util.random((int)ParticleSpawningResource.this.minDistance, (int)ParticleSpawningResource.this.maxDistance);
            int velocity = Util.random((int)ParticleSpawningResource.this.minVelocity, (int)ParticleSpawningResource.this.maxVelocity) << Game.getOptions().getSpeedShift();
            int a = Util.random((int)0, (int)65535);
            int dx = FPMath.mul((int)FPMath.sin((int)a), (int)distance);
            int dy = FPMath.mul((int)FPMath.cos((int)a), (int)distance);
            int dz = Math.abs(FPMath.mul((int)FPMath.sin((int)FPMath.fpValue((double)(Math.random() * Math.PI * 2.0))), (int)distance));
            moving.getPosition().translate(dx, dy, dz);
            a = Util.random((int)0, (int)65535);
            dx = FPMath.mul((int)FPMath.sin((int)a), (int)velocity);
            dy = FPMath.mul((int)FPMath.cos((int)a), (int)velocity);
            dz = Math.abs(FPMath.mul((int)FPMath.sin((int)FPMath.fpValue((double)(Math.random() * Math.PI * 2.0))), (int)velocity));
            moving.getVelocity().translate(dx, dy, dz);
        }
    }
}

