/*
 * Decompiled with CFR 0.152.
 */
package xap.resources;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.util.FPMath;
import com.shavenpuppy.jglib.util.Util;
import com.shavenpuppy.jglib.util.XMLUtil;
import com.shavenpuppy.jglib.vector.ReadableVector3i;
import com.shavenpuppy.jglib.vector.Vector3i;
import com.shavenpuppy.jglib.vector.WritableVector3i;
import org.w3c.dom.Element;
import xap.Game;
import xap.Moving;
import xap.ParticleMovement;

public class ParticleMovementResource
extends Resource {
    public static final long serialVersionUID = 1L;
    private int minMass;
    private int maxMass;
    private int minBounce;
    private int maxBounce;
    private int minFriction;
    private int maxFriction;

    public void load(Element element, Resource.Loader loader) throws Exception {
        this.minMass = FPMath.fpValue((float)XMLUtil.getFloat((Element)element, (String)"minmass"));
        this.maxMass = FPMath.fpValue((float)XMLUtil.getFloat((Element)element, (String)"maxmass"));
        this.minFriction = FPMath.fpValue((float)XMLUtil.getFloat((Element)element, (String)"minfriction"));
        this.maxFriction = FPMath.fpValue((float)XMLUtil.getFloat((Element)element, (String)"maxfriction"));
        this.minBounce = FPMath.fpValue((float)XMLUtil.getFloat((Element)element, (String)"minbounce"));
        this.maxBounce = FPMath.fpValue((float)XMLUtil.getFloat((Element)element, (String)"maxbounce"));
    }

    public ParticleMovement spawn() {
        return new ParticleMovementInstance();
    }

    private final class ParticleMovementInstance
    implements ParticleMovement {
        private Moving moving;
        private int mass;
        private int friction;
        private int bounce;

        ParticleMovementInstance() {
        }

        public void init(Moving moving) {
            this.moving = moving;
            this.mass = Util.random((int)ParticleMovementResource.this.minMass, (int)ParticleMovementResource.this.maxMass);
            this.friction = Util.random((int)ParticleMovementResource.this.minFriction, (int)ParticleMovementResource.this.maxFriction);
            this.bounce = Util.random((int)ParticleMovementResource.this.minBounce, (int)ParticleMovementResource.this.maxBounce);
        }

        public void tick() {
            Vector3i pos = this.moving.getPosition();
            Vector3i vel = this.moving.getVelocity();
            vel.setZ(vel.getZ() - this.mass << Game.getOptions().getSpeedShift());
            if (this.friction != 0) {
                int len = vel.length();
                int newLen = len - (this.friction << Game.getOptions().getSpeedShift());
                vel.scale(FPMath.div((int)newLen, (int)len));
            }
            Vector3i.add((ReadableVector3i)pos, (ReadableVector3i)vel, (WritableVector3i)pos);
            if (pos.getZ() <= 0) {
                vel.setZ(-FPMath.mul((int)vel.getZ(), (int)this.bounce));
                pos.setZ(Math.max(0, pos.getZ() + vel.getZ()));
            }
        }

        public int getBounce() {
            return this.bounce;
        }

        public int getFriction() {
            return this.friction;
        }

        public int getMass() {
            return this.mass;
        }

        public void setBounce(int bounce) {
            this.bounce = bounce;
        }

        public void setFriction(int friction) {
            this.friction = friction;
        }

        public void setMass(int mass) {
            this.mass = mass;
        }
    }
}

