/*
 * Decompiled with CFR 0.152.
 */
package xap.resources;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.sprites.Animation;
import com.shavenpuppy.jglib.sprites.SpriteImage;
import com.shavenpuppy.jglib.util.XMLUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import xap.Feature;

public class InstructionResource
extends Feature {
    public static final long serialVersionUID = 1L;
    private static final HashMap instructionComponentMap = new HashMap();
    private InstructionComponent[] instruction;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("xap.resources.InstructionResource$Paragraph");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        instructionComponentMap.put("text", clazz);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("xap.resources.InstructionResource$SpriteObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        instructionComponentMap.put("sprite", clazz2);
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        super.load(element, loader);
        try {
            loader.pushMap((Map)instructionComponentMap);
            NodeList childTagList = element.getChildNodes();
            if (childTagList.getLength() > 0) {
                ArrayList<Resource> children = new ArrayList<Resource>(childTagList.getLength());
                int i = 0;
                while (i < childTagList.getLength()) {
                    if (childTagList.item(i) instanceof Element) {
                        Element childElement = (Element)childTagList.item(i);
                        Resource childResource = loader.load(childElement);
                        if (!(childResource instanceof InstructionComponent)) {
                            throw new Exception("Only InstructionComponent resources are allowed inside an InstructionFeature");
                        }
                        children.add(childResource);
                    }
                    ++i;
                }
                this.instruction = new InstructionComponent[children.size()];
                children.toArray(this.instruction);
            }
        }
        finally {
            loader.popMap();
        }
    }

    protected void doCreate() throws Exception {
        super.doCreate();
        int i = 0;
        while (i < this.instruction.length) {
            this.instruction[i].create();
            ++i;
        }
    }

    protected void doDestroy() {
        super.doDestroy();
        int i = 0;
        while (i < this.instruction.length) {
            this.instruction[i].destroy();
            ++i;
        }
    }

    public void draw(InstructionViewer viewer) {
        int i = 0;
        while (i < this.instruction.length) {
            this.instruction[i].view(viewer);
            ++i;
        }
    }

    public static interface InstructionComponent {
        public void view(InstructionViewer var1);

        public void create() throws Exception;

        public void destroy();
    }

    public static class Paragraph
    extends Resource
    implements InstructionComponent {
        public static final long serialVersionUID = 1L;
        private String text;
        private int width;
        private int x;
        private int y;

        public void view(InstructionViewer viewer) {
            viewer.addText(this.text, this.x, this.y, this.width);
        }

        public void load(Element element, Resource.Loader loader) throws Exception {
            super.load(element, loader);
            NodeList childNodes = element.getChildNodes();
            if (childNodes.getLength() != 1) {
                throw new Exception("Text node must have text present!");
            }
            if (!(childNodes.item(0) instanceof Text)) {
                throw new Exception("Text node can only have text as its child node!");
            }
            this.text = childNodes.item(0).getNodeValue().trim();
            while (this.text.endsWith("\n")) {
                this.text = this.text.substring(0, this.text.length() - 1);
            }
            this.width = XMLUtil.getInt((Element)element, (String)"width");
            this.x = XMLUtil.getInt((Element)element, (String)"x", (int)0);
            this.y = XMLUtil.getInt((Element)element, (String)"y", (int)0);
        }
    }

    public static interface InstructionViewer {
        public void addText(String var1, int var2, int var3, int var4);

        public void addSprite(SpriteImage var1, Animation var2, int var3, int var4);
    }

    public static class SpriteObject
    extends Resource
    implements InstructionComponent {
        public static final long serialVersionUID = 1L;
        private int x;
        private int y;
        private String animation;
        private String image;
        private Animation animationResource;
        private SpriteImage spriteImageResource;

        protected void doCreate() throws Exception {
            if (this.animation != null) {
                this.animationResource = (Animation)Resources.get((String)this.animation);
            }
            if (this.image != null) {
                this.spriteImageResource = (SpriteImage)Resources.get((String)this.image);
            }
        }

        protected void doDestroy() {
            this.animationResource = null;
            this.spriteImageResource = null;
        }

        public void load(Element element, Resource.Loader loader) throws Exception {
            super.load(element, loader);
            this.animation = XMLUtil.getString((Element)element, (String)"animation", null);
            this.image = XMLUtil.getString((Element)element, (String)"image", null);
            this.x = XMLUtil.getInt((Element)element, (String)"x");
            this.y = XMLUtil.getInt((Element)element, (String)"y");
        }

        public void view(InstructionViewer viewer) {
            viewer.addSprite(this.spriteImageResource, this.animationResource, this.x, this.y);
        }
    }
}

