/*
 * Decompiled with CFR 0.152.
 */
package xap.particles;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.sprites.Animation;
import com.shavenpuppy.jglib.sprites.Sprite;
import com.shavenpuppy.jglib.sprites.SpriteImage;
import com.shavenpuppy.jglib.util.FPMath;
import com.shavenpuppy.jglib.util.XMLUtil;
import org.w3c.dom.Element;
import xap.Game;
import xap.features.ParticleFeature;

public abstract class SpriteParticleFeature
extends ParticleFeature {
    public static final long serialVersionUID = 1L;
    private String animation;
    private String image;
    private int layer;
    private transient SpriteImage imageResource;
    private transient Animation animationResource;

    public SpriteParticleFeature() {
    }

    public SpriteParticleFeature(String name) {
        super(name);
    }

    protected void doCreate() throws Exception {
        super.doCreate();
        if (this.animation != null) {
            this.animationResource = (Animation)Resources.get((String)this.animation);
        } else if (this.image != null) {
            this.imageResource = (SpriteImage)Resources.get((String)this.image);
        }
    }

    protected void doDestroy() {
        super.doDestroy();
        this.animationResource = null;
        this.imageResource = null;
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        super.load(element, loader);
        this.animation = XMLUtil.getString((Element)element, (String)"animation", null);
        this.image = XMLUtil.getString((Element)element, (String)"image", null);
        this.layer = XMLUtil.getInt((Element)element, (String)"layer", (int)0);
        if (this.animation == null && this.image == null) {
            throw new Exception("Particle feature " + this + " has no animation or image.");
        }
        if (this.animation != null && this.image != null) {
            throw new Exception("Particle feature " + this + " must have either an animation or image but not both.");
        }
    }

    protected abstract class SpriteParticleInstance
    extends ParticleFeature.ParticleInstance {
        protected Sprite sprite;

        protected SpriteParticleInstance() {
        }

        protected final void doSpawn() {
            this.sprite = Game.allocateSprite(this);
            if (SpriteParticleFeature.this.animationResource != null) {
                this.sprite.setAnimation(SpriteParticleFeature.this.animationResource);
            } else {
                this.sprite.setImage(SpriteParticleFeature.this.imageResource);
            }
            this.sprite.setActive(true);
            this.sprite.setLayer(SpriteParticleFeature.this.layer);
            this.doSpriteParticleSpawn();
        }

        protected final boolean isActive() {
            return this.getTick() <= 0 || this.sprite != null && this.sprite.isActive();
        }

        protected abstract void doSpriteParticleSpawn();

        protected final void doDeallocate() {
            if (this.sprite != null) {
                this.sprite.deallocate();
                this.sprite = null;
            }
            this.doSpriteParticleDeallocate();
        }

        protected abstract void doSpriteParticleDeallocate();

        protected final Sprite getSprite() {
            return this.sprite;
        }

        protected final void doTick() {
            this.doSpriteParticleTick();
            this.sprite.setLocation(FPMath.intValue((int)this.position.getX()), FPMath.intValue((int)this.position.getY()), FPMath.intValue((int)this.position.getZ()));
        }

        protected abstract void doSpriteParticleTick();
    }
}

