/*
 * Decompiled with CFR 0.152.
 */
package xap.modes.standard;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.opengl.GLFont;
import com.shavenpuppy.jglib.opengl.GLRenderable;
import com.shavenpuppy.jglib.resources.ColorSequenceResource;
import com.shavenpuppy.jglib.util.FPMath;
import com.shavenpuppy.jglib.util.Util;
import com.shavenpuppy.jglib.util.XMLUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.prefs.Preferences;
import org.lwjgl.util.Timer;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import xap.Bindings;
import xap.Blob;
import xap.Bullet;
import xap.Game;
import xap.GameMode;
import xap.Gidrah;
import xap.Gunner;
import xap.Laser;
import xap.Level;
import xap.Player;
import xap.Score;
import xap.effects.LabelEffect;
import xap.features.BlobFeature;
import xap.features.GameModeFeature;
import xap.features.GidrahFeature;
import xap.features.PowerupFeature;
import xap.gui.CheckBox;
import xap.gui.Component;
import xap.gui.MessageBox;
import xap.gui.MessageBoxListener;
import xap.menu.EnterNameWindow;
import xap.menu.HiScoreDialog;
import xap.modes.standard.StandardGameModeFeature;
import xap.modes.standard.StandardHiScoreComponent;
import xap.modes.standard.StandardHiScoreServerResource;
import xap.modes.standard.StandardHiScoreTable;
import xap.modes.standard.StandardLevelResource;
import xap.modes.standard.StandardScore;

public class StandardGameModeFeature
extends GameModeFeature {
    public static final long serialVersionUID = 1L;
    private static final int STATE_TRUE = 0;
    private static final int STATE_FALSE = 1;
    private static final int STATE_UNSET = 2;
    private int extraLife;
    private int extraSmartBomb;
    private int powerupDue;
    private ArrayList levels;
    private int gunnerArrivalTime;
    private int minGunnerArrivalTime;
    private int gunnerDifficulty;
    private String gunner;
    private String bubbles;
    private ArrayList heartbeats;
    private ArrayList randomGidrahs;
    private String unlockKey;
    private String completionUnlocks;
    private int completionLevel;
    private int autoShields;
    private int autoSmarts;
    private boolean blobsImmune;
    private ArrayList randomEOLGs;
    private String hiscoreFile;
    private int demoLevelLimit;
    private Map minLevelMap;
    private transient int lastExtraLife;
    private transient int lastExtraSmart;
    private transient int lastPowerup;
    private transient StandardScore score;
    private transient boolean extraLifeDue;
    private transient boolean extraSmartBombDue;
    private transient boolean newPowerupDue;
    private transient int tick;
    private transient Level level;
    private transient GidrahFeature gunnerFeature;
    private transient StandardHiScoreTable hiscores;
    private transient Timer timer;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public StandardGameModeFeature(String name) {
        super(name);
    }

    private int decodeTriState(String state) {
        if (state.equals("true")) {
            return 0;
        }
        if (state.equals("false")) {
            return 1;
        }
        return 2;
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        Text tn;
        Element child;
        super.load(element, loader);
        this.hiscoreFile = XMLUtil.getString((Element)element, (String)"hiscorefile");
        this.extraLife = XMLUtil.getInt((Element)element, (String)"extralife");
        this.extraSmartBomb = XMLUtil.getInt((Element)element, (String)"extrasmartbomb");
        this.powerupDue = XMLUtil.getInt((Element)element, (String)"powerupdue");
        this.completionUnlocks = XMLUtil.getString((Element)element, (String)"completionunlocks", null);
        if (this.completionUnlocks != null) {
            this.completionLevel = XMLUtil.getInt((Element)element, (String)"completionlevel");
        }
        this.autoShields = this.decodeTriState(XMLUtil.getString((Element)element, (String)"autoshields"));
        this.autoSmarts = this.decodeTriState(XMLUtil.getString((Element)element, (String)"autosmarts"));
        this.blobsImmune = XMLUtil.getBoolean((Element)element, (String)"blobsimmune", (boolean)false);
        if (this.needsUnlock()) {
            this.unlockKey = XMLUtil.getString((Element)element, (String)"unlockkey");
        }
        this.gunnerArrivalTime = XMLUtil.getInt((Element)element, (String)"gunnerarrivaltime", (int)-1);
        if (this.gunnerArrivalTime != -1) {
            this.minGunnerArrivalTime = XMLUtil.getInt((Element)element, (String)"mingunnerarrivaltime");
            this.gunnerDifficulty = XMLUtil.getInt((Element)element, (String)"gunnerdifficulty");
            this.gunner = XMLUtil.getString((Element)element, (String)"gunner");
        }
        this.bubbles = XMLUtil.getString((Element)element, (String)"bubbles", null);
        NodeList childNodes = element.getElementsByTagName("level");
        this.levels = new ArrayList(childNodes.getLength());
        int i = 0;
        while (i < childNodes.getLength()) {
            child = (Element)childNodes.item(i);
            tn = (Text)child.getFirstChild();
            this.levels.add(tn.getData());
            ++i;
        }
        childNodes = element.getElementsByTagName("heartbeat");
        this.heartbeats = new ArrayList(childNodes.getLength());
        i = 0;
        while (i < childNodes.getLength()) {
            child = (Element)childNodes.item(i);
            tn = (Text)child.getFirstChild();
            this.heartbeats.add(tn.getData());
            ++i;
        }
        childNodes = element.getElementsByTagName("gidrah");
        this.randomGidrahs = new ArrayList();
        this.minLevelMap = new HashMap();
        i = 0;
        while (i < childNodes.getLength()) {
            child = (Element)childNodes.item(i);
            int num = XMLUtil.getInt((Element)child, (String)"freq", (int)1);
            int minLevel = XMLUtil.getInt((Element)child, (String)"minlevel", (int)0);
            Text tn2 = (Text)child.getFirstChild();
            String gid = tn2.getData();
            this.minLevelMap.put(gid, new Integer(minLevel));
            int j = 0;
            while (j < num) {
                this.randomGidrahs.add(gid);
                ++j;
            }
            ++i;
        }
        childNodes = element.getElementsByTagName("eolg");
        this.randomEOLGs = new ArrayList(childNodes.getLength());
        i = 0;
        while (i < childNodes.getLength()) {
            child = (Element)childNodes.item(i);
            Text tn3 = (Text)child.getFirstChild();
            this.randomEOLGs.add(tn3.getData());
            ++i;
        }
        this.demoLevelLimit = XMLUtil.getInt((Element)element, (String)"demolevellimit");
    }

    protected void doCreate() throws Exception {
        block22: {
            super.doCreate();
            this.timer = new Timer();
            if (this.gunner != null) {
                this.gunnerFeature = (GidrahFeature)Resources.get((String)this.gunner);
            }
            FileInputStream fis = null;
            BufferedInputStream bis = null;
            ObjectInputStream ois = null;
            try {
                try {
                    File hiScoreFile = new File(this.hiscoreFile);
                    if (!hiScoreFile.exists()) {
                        this.hiscores = new StandardHiScoreTable(10);
                        break block22;
                    }
                    fis = new FileInputStream(this.hiscoreFile);
                    bis = new BufferedInputStream(fis);
                    ois = new ObjectInputStream(bis);
                    this.hiscores = (StandardHiScoreTable)ois.readObject();
                }
                catch (Exception e) {
                    this.hiscores = new StandardHiScoreTable(10);
                }
            }
            finally {
                try {
                    if (ois != null) {
                        ois.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (bis != null) {
                        bis.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    protected void doDestroy() {
        super.doDestroy();
        this.gunnerFeature = null;
        this.hiscores = null;
    }

    public void handleCollision(Laser.Collider laser, Blob blob) {
        if (!this.blobsImmune) {
            laser.fade();
        }
    }

    public void handleCollision(Player.Collider player, Bullet bullet) {
        if (player.isInvulnerable()) {
            return;
        }
        if (player.isShieldUp()) {
            player.useShields(5);
            player.spawnRicochet();
            return;
        }
        if (Game.developer) {
            return;
        }
        player.kill();
    }

    public void handleCollision(Player.Collider player, Gidrah gidrah) {
        if (player.isInvulnerable()) {
            return;
        }
        if (player.isShieldUp()) {
            player.useShields(gidrah.getHitPoints());
            player.spawnRicochet();
            return;
        }
        if (Game.developer) {
            return;
        }
        player.kill();
    }

    public void handleCollision(Gidrah.Collider gidrah, Player player) {
        if (player.isShieldUp()) {
            gidrah.kill();
        }
    }

    public void handleCollision(Blob.Collider blob, Laser laser) {
        if (!this.blobsImmune) {
            blob.kill();
        }
    }

    public void handleCollision(Bullet.Collider bullet, Player player) {
        bullet.remove();
    }

    public void handleCollision(Gidrah.Collider gidrah, Laser laser) {
        gidrah.damage(laser.getDamage(), laser.getPosition().getX(), laser.getPosition().getY());
    }

    public void handleCollision(Laser.Collider laser, Gidrah gidrah) {
        this.score.incHits();
        laser.fade();
    }

    public boolean isCheckPointLevel() {
        return this.getCurrentLevel() % 5 == 0;
    }

    public boolean isUnlocked() {
        if (this.unlockKey == null) {
            return true;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("xap.modes.standard.StandardGameModeFeature");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Preferences prefs = Preferences.userNodeForPackage(clazz);
        return prefs.getBoolean(this.unlockKey, false);
    }

    public void unlock() {
        if (this.unlockKey == null) {
            return;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("xap.modes.standard.StandardGameModeFeature");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Preferences prefs = Preferences.userNodeForPackage(clazz);
        prefs.putBoolean(this.unlockKey, true);
        try {
            LabelEffect.spawn(FPMath.fpValue((int)400), FPMath.fpValue((int)400), 0, 0, (GLFont)Resources.get((String)"impact-plain-24.glfont"), (ColorSequenceResource)Resources.get((String)"unlock.colorseq"), String.valueOf(this.getDisplay()) + " game mode unlocked!", true);
        }
        catch (Exception e) {
            Game.handleException(e);
        }
    }

    public GLRenderable getCurrentBackground() {
        if (this.level != null) {
            return this.level.getBackground();
        }
        return null;
    }

    public boolean isDifficult() {
        return this.getCurrentLevel() > this.getDifficultyLevel() || this.getCurrentLevel() % 5 == 4;
    }

    public void onBlobDeath(Blob blob) {
        if (blob.isCaptured()) {
            this.score.incBungles();
        } else {
            this.score.incMurders();
        }
    }

    public void onBlobRelease(Blob blob) {
        this.score.incStyle();
    }

    public void onBlobRescue(Blob blob) {
        this.score.incRescues();
    }

    public void onBlobBonus() {
        this.score.incFluffies();
    }

    public void onNewGame() throws Exception {
        super.onNewGame();
        if (!this.isCreated()) {
            this.create();
        }
        this.score = new StandardScore(Game.getRegistrationDetails(), this.getMode());
        this.extraLifeDue = false;
        this.extraSmartBombDue = false;
        this.newPowerupDue = false;
        this.lastPowerup = this.powerupDue;
        this.timer.reset();
        this.timer.resume();
    }

    public void onNewLevel() throws Exception {
        GameMode unlockedMode;
        super.onNewLevel();
        this.score.setLevel(this.getCurrentLevel());
        if (this.getCurrentLevel() >= this.completionLevel && this.completionUnlocks != null && !(unlockedMode = (GameMode)Resources.get((String)this.completionUnlocks)).isUnlocked()) {
            unlockedMode.unlock();
        }
        this.tick = -240;
        int n = this.getCurrentLevel();
        if (n >= this.levels.size()) {
            String heartbeat = (String)this.heartbeats.get(n % this.heartbeats.size());
            this.level = StandardLevelResource.createRandomLevel(n, heartbeat, this.bubbles, this.randomEOLGs, this);
        } else {
            this.level = (Level)Resources.get((String)((String)this.levels.get(n)));
        }
        this.level.begin();
    }

    public void onEndGame() throws Exception {
        Class<?> clazz;
        super.onEndGame();
        float requiredTicks = 50.0f * this.timer.getTime();
        if ((float)this.score.getTime() < requiredTicks) {
            this.invalidateScore();
        }
        if ((clazz = class$1) == null) {
            try {
                clazz = class$1 = Class.forName("xap.Game");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Preferences prefs = Preferences.userNodeForPackage(clazz);
        int tix = prefs.getInt("tix", 0);
        prefs.putInt("tix", tix += this.score.getTime() / 60);
        this.submitHiScore();
    }

    public void onEndLevel() throws Exception {
        this.level.finish();
        this.timer.pause();
    }

    public void onPlayerDeath() throws Exception {
        this.timer.pause();
    }

    public void onPlayerSpawn() throws Exception {
        this.timer.resume();
    }

    public void invalidateScore() {
        this.score.invalidate();
    }

    public void displayStats(GameMode.StatsDisplay display) {
        super.displayStats(display);
        display.setScore(this.score.getScore());
    }

    public boolean tick() {
        this.tick += Game.getOptions().getTicksPerFrame();
        if (this.level.isFinished()) {
            return false;
        }
        try {
            if (this.extraLifeDue) {
                this.extraLifeDue = false;
                ((PowerupFeature)Resources.get((String)"extralife.powerup")).spawn();
            }
            if (this.extraSmartBombDue) {
                this.extraSmartBombDue = false;
                ((PowerupFeature)Resources.get((String)"extrasmartbomb.powerup")).spawn();
            }
            if (this.newPowerupDue) {
                this.newPowerupDue = false;
                PowerupFeature randomPowerup = BlobFeature.getNumBlobs() <= 1 && Math.random() < 0.5 ? (PowerupFeature)Resources.get((String)"extrablob.powerup") : (Game.getPlayer().isShieldEmpty() && Math.random() < 0.5 ? (PowerupFeature)Resources.get((String)"powerupshield.powerup") : (Game.getPlayer().isPathetic() && Math.random() < 0.5 ? PowerupFeature.getRandomGunPowerup() : PowerupFeature.getRandomPowerup()));
                randomPowerup.spawn();
            }
        }
        catch (Exception e) {
            Game.handleException(e);
        }
        if (this.tick < 0) {
            return true;
        }
        this.level.tick();
        int extraTime = this.isDifficult() ? 3600 : 0;
        int wga = this.whenGunnerArrives();
        if (this.gunnerFeature != null && wga != -1 && this.tick > extraTime + wga) {
            Gunner gunner = (Gunner)this.gunnerFeature.spawn();
            gunner.hatch();
            this.tick -= Math.max(600, 1200 - Game.getGameMode().getCurrentLevel() * 25);
        }
        return true;
    }

    private void submitHiScore() throws Exception {
        if (this.score.getScore() == 0) {
            return;
        }
        class Submission {
            boolean askForName;
            boolean submitRemote;
            boolean localscore;
            final /* synthetic */ StandardGameModeFeature this$0;

            Submission(StandardGameModeFeature standardGameModeFeature) {
                this.this$0 = standardGameModeFeature;
                this.askForName = false;
                this.submitRemote = false;
                this.localscore = false;
                if (Game.isRegistered()) {
                    if (Game.getOptions().getAskUseInternet() && StandardGameModeFeature.access$0(standardGameModeFeature).isValid()) {
                        try {
                            CheckBox dontAskCheckBox = new CheckBox("Don't ask me again (change this back in Options screen)");
                            dontAskCheckBox.pack();
                            new MessageBox("Online scores", "Would you like to submit your score to the online score server? (Please ensure you have a connection to the internet first)", dontAskCheckBox, 0, 3, new MessageBoxListener(this, dontAskCheckBox){
                                final /* synthetic */ Submission this$1;
                                private final /* synthetic */ CheckBox val$dontAskCheckBox;
                                {
                                    this.this$1 = submission;
                                    this.val$dontAskCheckBox = checkBox;
                                }

                                public void messageBoxChoiceMade(MessageBox mbox, int choice) {
                                    if (choice == 2) {
                                        this.this$1.askForName = true;
                                        this.this$1.submitRemote = true;
                                    }
                                    if (this.val$dontAskCheckBox.isChecked()) {
                                        Game.getOptions().setAskUseInternet(false);
                                        Game.getOptions().setUseInternet(this.this$1.submitRemote);
                                        Game.saveOptions();
                                    }
                                    this.this$1.submitLocal();
                                }
                            }).open();
                        }
                        catch (Exception e) {
                            Game.handleException(e);
                            this.submitLocal();
                        }
                    } else {
                        this.submitRemote = Game.getOptions().getUseInternet() && StandardGameModeFeature.access$0(standardGameModeFeature).isValid();
                        this.submitLocal();
                    }
                } else {
                    this.submitLocal();
                }
            }

            void submitLocal() {
                try {
                    this.localscore = StandardGameModeFeature.access$1(this.this$0).submit(StandardGameModeFeature.access$0(this.this$0));
                    this.askForName |= this.localscore;
                    if (this.askForName) {
                        new EnterNameWindow(this, (Score)StandardGameModeFeature.access$0(this.this$0)){
                            final /* synthetic */ Submission this$1;
                            {
                                this.this$1 = submission;
                                super($anonymous0);
                            }

                            public void close() {
                                super.close();
                                if (this.this$1.localscore) {
                                    FileOutputStream fos = null;
                                    FilterOutputStream bos = null;
                                    ObjectOutputStream oos = null;
                                    try {
                                        try {
                                            fos = new FileOutputStream(StandardGameModeFeature.access$2(Submission.access$0(this.this$1)));
                                            bos = new BufferedOutputStream(fos);
                                            oos = new ObjectOutputStream(bos);
                                            oos.writeObject(StandardGameModeFeature.access$1(Submission.access$0(this.this$1)));
                                            oos.flush();
                                        }
                                        catch (Exception e) {
                                            Game.handleException(e);
                                        }
                                    }
                                    finally {
                                        try {
                                            if (oos != null) {
                                                oos.close();
                                            }
                                        }
                                        catch (Exception exception) {}
                                        try {
                                            if (bos != null) {
                                                bos.close();
                                            }
                                        }
                                        catch (Exception exception) {}
                                        try {
                                            if (fos != null) {
                                                fos.close();
                                            }
                                        }
                                        catch (Exception exception) {}
                                    }
                                }
                                this.this$1.maybeSubmitRemote();
                            }
                        }.open();
                    } else {
                        this.maybeSubmitRemote();
                    }
                }
                catch (Exception e) {
                    Game.handleException(e);
                }
            }

            void maybeSubmitRemote() {
                if (this.submitRemote && StandardGameModeFeature.access$0(this.this$0).isValid() && StandardGameModeFeature.access$0(this.this$0).getName() != null && !StandardGameModeFeature.access$0(this.this$0).getName().trim().equals("")) {
                    new Thread(this){
                        final /* synthetic */ Submission this$1;
                        {
                            this.this$1 = submission;
                            this.setDaemon(true);
                        }

                        public void run() {
                            try {
                                if (!StandardHiScoreServerResource.submitHiScores(StandardGameModeFeature.access$1(Submission.access$0(this.this$1)))) {
                                    Game.getRegistrationDetails().deregister();
                                }
                            }
                            catch (Throwable t) {
                                System.out.println("Failed to submit score:");
                                t.printStackTrace();
                            }
                        }
                    }.start();
                    this.maybeDisplayscores();
                } else {
                    this.maybeDisplayscores();
                }
            }

            void maybeDisplayscores() {
                if (this.localscore) {
                    try {
                        new HiScoreDialog(this.this$0).open();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }

            static /* synthetic */ StandardGameModeFeature access$0(Submission submission) {
                return submission.this$0;
            }
        }
        new Submission(this);
    }

    private int whenGunnerArrives() {
        int currentLevel = this.getCurrentLevel();
        if (currentLevel + Game.getGameMode().getDifficultyOffset() == 0) {
            return -1;
        }
        int ticks = currentLevel < this.getDifficultyLevel() ? this.gunnerArrivalTime : Math.max(this.minGunnerArrivalTime, this.gunnerArrivalTime - this.gunnerDifficulty * (currentLevel - this.getDifficultyLevel()));
        return ticks;
    }

    public void addScore(int points) {
        int nextExtraSmart;
        this.score.addScore(points);
        int currentScore = this.score.getScore();
        int nextExtraLife = currentScore / this.extraLife;
        if (nextExtraLife > this.lastExtraLife) {
            this.extraLifeDue = true;
            ++this.lastExtraLife;
        }
        if ((nextExtraSmart = currentScore / this.extraSmartBomb) > this.lastExtraSmart) {
            this.extraSmartBombDue = true;
            ++this.lastExtraSmart;
        }
        if (currentScore > this.lastPowerup) {
            this.newPowerupDue = true;
            this.lastPowerup += this.powerupDue + Game.getCurrentLevel() * 250;
        }
    }

    public Score getScore() {
        return this.score;
    }

    String getRandomGidrahFeature() {
        int idx;
        String gidrah = null;
        int minLevel = 0;
        while ((minLevel = ((Integer)this.minLevelMap.get(gidrah = (String)this.randomGidrahs.get(idx = Util.random((int)0, (int)(this.randomGidrahs.size() - 1))))).intValue()) > this.getCurrentLevel()) {
        }
        return gidrah;
    }

    public boolean checkNextLevel() {
        if (this.getCurrentLevel() >= this.demoLevelLimit && !Game.isRegistered()) {
            Game.endDemo();
            return false;
        }
        return true;
    }

    public Component getHiScoreComponent() {
        try {
            if (!this.isCreated()) {
                this.create();
            }
            StandardHiScoreComponent c = new StandardHiScoreComponent();
            this.hiscores.display((StandardHiScoreTable.Display)c, 10);
            return c;
        }
        catch (Exception e) {
            Game.handleException(e);
            return null;
        }
    }

    public boolean isUsingAutoShield() {
        switch (this.autoShields) {
            case 0: {
                return true;
            }
            case 1: {
                return false;
            }
        }
        return Bindings.getAutoShield();
    }

    public boolean isUsingAutoSmartbomb() {
        switch (this.autoSmarts) {
            case 0: {
                return true;
            }
            case 1: {
                return false;
            }
        }
        return Bindings.getAutoSmartBomb();
    }

    static /* synthetic */ StandardScore access$0(StandardGameModeFeature standardGameModeFeature) {
        return standardGameModeFeature.score;
    }

    static /* synthetic */ StandardHiScoreTable access$1(StandardGameModeFeature standardGameModeFeature) {
        return standardGameModeFeature.hiscores;
    }

    static /* synthetic */ String access$2(StandardGameModeFeature standardGameModeFeature) {
        return standardGameModeFeature.hiscoreFile;
    }
}

