/*
 * Decompiled with CFR 0.152.
 */
package xap.menu;

import org.lwjgl.util.Color;
import xap.gui.CommandButton;
import xap.gui.CommandButtonListener;
import xap.gui.Component;
import xap.gui.Interface;
import xap.gui.TextArea;
import xap.gui.Window;
import xap.menu.Wizard;
import xap.menu.WizardGUI;

public class WizardDialog
extends Window {
    private Wizard wizard;
    private WizardDialog nextWizard;
    private WizardDialog prevWizard;
    private CommandButton nextButton;
    private CommandButton backButton;
    private CommandButton cancelButton;
    private TextArea instructionsTextArea;
    private WizardGUI controls;
    private final EventHandler eventHandler = new EventHandler();

    public WizardDialog(WizardGUI controls) throws Exception {
        super(" ");
        this.controls = controls;
        controls.setWizardDialog(this);
        this.nextButton = new CommandButton("Next");
        this.backButton = new CommandButton("Back");
        this.cancelButton = new CommandButton("Cancel");
        this.instructionsTextArea = new TextArea();
        this.layout();
        this.instructionsTextArea.setBackgroundColor(new Color(255, 0, 0, 50));
        this.instructionsTextArea.setForegroundColor(Interface.getControlEnabledTextColor());
        Component controlsComponent = controls.getComponent();
        this.instructionsTextArea.setWidth(controlsComponent.getWidth());
        this.instructionsTextArea.setText(controls.getInstructions());
        this.instructionsTextArea.layout();
        this.instructionsTextArea.setY(controlsComponent.getHeight() + 70);
        controlsComponent.setY(50);
        this.cancelButton.setWidth(100);
        this.nextButton.setWidth(100);
        this.backButton.setWidth(100);
        this.cancelButton.setLocation(controlsComponent.getWidth() - this.cancelButton.getWidth(), 0);
        this.nextButton.setLocation(this.cancelButton.getX() - this.nextButton.getWidth() - 10, 0);
        this.backButton.setLocation(this.nextButton.getX() - this.backButton.getWidth() - 10, 0);
        this.addChild(this.instructionsTextArea);
        this.addChild(controlsComponent);
        this.addChild(this.backButton);
        this.addChild(this.nextButton);
        this.addChild(this.cancelButton);
        this.layout();
        this.pack();
        this.setBorder(5, 5, 5, 5);
        this.centre();
        this.initEvents();
    }

    private void initEvents() {
        this.cancelButton.addCommandButtonListener(this.eventHandler);
        this.nextButton.addCommandButtonListener(this.eventHandler);
        this.backButton.addCommandButtonListener(this.eventHandler);
    }

    public WizardDialog getNextWizard() {
        return this.nextWizard;
    }

    public void setNextWizard(WizardDialog nextWizard) {
        this.nextWizard = nextWizard;
        this.nextButton.setText(nextWizard == null ? "Finish" : "Next");
    }

    public WizardDialog getPrevWizard() {
        return this.prevWizard;
    }

    public void setPrevWizard(WizardDialog prevWizard) {
        this.prevWizard = prevWizard;
        this.backButton.setVisible(prevWizard != null);
    }

    public void setWizard(Wizard wizard) {
        this.wizard = wizard;
    }

    public Wizard getWizard() {
        return this.wizard;
    }

    public void setNextEnabled(boolean enabled) {
        this.nextButton.setEnabled(enabled);
    }

    public WizardGUI getControls() {
        return this.controls;
    }

    private class EventHandler
    implements CommandButtonListener {
        EventHandler() {
        }

        public boolean selected(CommandButton cb) {
            if (cb == WizardDialog.this.nextButton) {
                if (!WizardDialog.this.controls.validate()) {
                    return false;
                }
                if (WizardDialog.this.nextWizard != null) {
                    WizardDialog.this.close();
                    WizardDialog.this.nextWizard.controls.checkValid();
                    WizardDialog.this.nextWizard.setVisible(true);
                } else {
                    WizardDialog.this.wizard.finish();
                }
            } else if (cb == WizardDialog.this.backButton) {
                WizardDialog.this.close();
                WizardDialog.this.prevWizard.controls.checkValid();
                WizardDialog.this.prevWizard.setVisible(true);
            } else if (cb == WizardDialog.this.cancelButton) {
                WizardDialog.this.close();
            }
            return false;
        }
    }
}

