/*
 * Decompiled with CFR 0.152.
 */
package xap.menu;

import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.TextLayout;
import com.shavenpuppy.jglib.opengl.GLFont;
import com.shavenpuppy.jglib.resources.TextResource;
import com.shavenpuppy.jglib.sprites.Sprite;
import com.shavenpuppy.jglib.sprites.SpriteImage;
import com.shavenpuppy.jglib.sprites.StaticSpriteEngine;
import org.lwjgl.util.Color;
import xap.Game;
import xap.gui.CommandButton;
import xap.gui.CommandButtonListener;
import xap.gui.Label;
import xap.gui.TextArea;
import xap.gui.Window;

public class NagWindow
extends Window {
    private CommandButton cbContinue;
    private CommandButton cbOrderOnline = new CommandButton("Order Alien Flux now!");
    private Label taStrapLine = new Label("Get Alien Flux for only USD19.95 / EUR19.95 / GBP14.95!");
    private TextArea taBenefits = new TextArea();
    private StaticSpriteEngine spriteEngine;
    private int count;
    private final Runnable continueCode;
    private final EventHandler eventHandler = new EventHandler();
    private final String closeButtonText;

    public NagWindow(String closeButtonText, Runnable continueCode) throws Exception {
        this("Thank you for downloading Alien Flux!", closeButtonText, continueCode);
    }

    public NagWindow(String title, String closeButtonText, Runnable continueCode) throws Exception {
        super(title);
        this.continueCode = continueCode;
        this.closeButtonText = closeButtonText;
        this.cbContinue = new CommandButton(closeButtonText);
        this.createGUI();
        this.initEvents();
    }

    private void createGUI() throws Exception {
        this.addChild(this.cbContinue);
        this.addChild(this.cbOrderOnline);
        this.addChild(this.taStrapLine);
        this.addChild(this.taBenefits);
        this.cbContinue.setEnabled(false);
        this.taStrapLine.setLocation(50, 480);
        this.taStrapLine.setFont((GLFont)Resources.get((String)"impact-plain-32.glfont"));
        this.taStrapLine.setAlignment(1);
        this.taStrapLine.setBackgroundColor(new Color(0, 0, 255, 128));
        this.taStrapLine.setForegroundColor(new Color(255, 255, 255, 255));
        this.taStrapLine.layout().pack().setWidth(700);
        this.taBenefits.setText(((TextResource)Resources.get((String)"nag.text")).getText());
        this.taBenefits.setFormat(TextLayout.WORD_WRAP);
        this.taBenefits.setWidth(340).layout().setLocation(50, 70);
        this.spriteEngine = new StaticSpriteEngine(true, 4, Game.getOptions().getTicksPerFrame());
        this.spriteEngine.create();
        Sprite screenshot0 = this.spriteEngine.allocate((Object)this);
        SpriteImage si = (SpriteImage)Resources.get((String)"spriteimage.screenshot0");
        int NUM_SCREENSHOTS = 3;
        int screenShotSpread = (this.taBenefits.getHeight() - si.getHeight()) / 3;
        screenshot0.setImage(si);
        screenshot0.setLocation(400, this.taBenefits.getY(), 0);
        Sprite screenshot1 = this.spriteEngine.allocate((Object)this);
        si = (SpriteImage)Resources.get((String)"spriteimage.screenshot1");
        screenshot1.setImage(si);
        screenshot1.setLocation(750 - si.getWidth(), this.taBenefits.getY() + screenShotSpread, 0);
        Sprite screenshot2 = this.spriteEngine.allocate((Object)this);
        si = (SpriteImage)Resources.get((String)"spriteimage.screenshot2");
        screenshot2.setImage(si);
        screenshot2.setLocation(400, this.taBenefits.getY() + 2 * screenShotSpread, 0);
        Sprite screenshot3 = this.spriteEngine.allocate((Object)this);
        si = (SpriteImage)Resources.get((String)"spriteimage.screenshot3");
        screenshot3.setImage(si);
        screenshot3.setLocation(750 - si.getWidth(), this.taBenefits.getY() + 3 * screenShotSpread, 0);
        this.cbContinue.pack().setWidth(200).setLocation(550, 10);
        this.cbOrderOnline.pack().setWidth(200).setLocation(50, 10);
        this.setBorder(5, 5, 5, 5).setSize(790, 590).centre();
    }

    private void initEvents() {
        this.cbContinue.addCommandButtonListener(this.eventHandler);
        this.cbOrderOnline.addCommandButtonListener(this.eventHandler);
    }

    protected boolean doTick() {
        this.count += Game.getOptions().getTicksPerFrame();
        if (this.count == 200) {
            this.cbContinue.setEnabled(true);
            this.cbContinue.setText(this.closeButtonText);
        } else if (this.count < 200) {
            this.cbContinue.setText(String.valueOf(1 + (200 - this.count) / 60) + " " + this.closeButtonText);
        }
        super.doTick();
        this.spriteEngine.tick();
        return true;
    }

    protected void renderForeground() {
        this.spriteEngine.render();
    }

    private class EventHandler
    implements CommandButtonListener {
        EventHandler() {
        }

        public boolean selected(CommandButton cb) {
            if (cb == NagWindow.this.cbContinue) {
                NagWindow.this.close();
                if (NagWindow.this.continueCode != null) {
                    NagWindow.this.continueCode.run();
                }
            } else if (cb == NagWindow.this.cbOrderOnline) {
                Game.buy();
            }
            return false;
        }
    }
}

