/*
 * Decompiled with CFR 0.152.
 */
package xap.gui;

import com.shavenpuppy.jglib.opengl.GLRenderable;
import com.shavenpuppy.jglib.opengl.GLTexture;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Color;
import xap.gui.Component;
import xap.gui.Dialog;
import xap.gui.Interface;

public class SwirlyBackground
implements GLRenderable {
    private byte[] red = new byte[4];
    private byte[] green = new byte[4];
    private byte[] blue = new byte[4];
    private byte[] alpha = new byte[4];
    private float[][] phase = new float[][]{new float[4], new float[4], new float[4], new float[4]};
    private final float colorVariation;
    private final float alphaVariation;
    private final Component target;
    private final GLTexture texture;

    public SwirlyBackground(Component target, float colorVariation, float alphaVariation, GLTexture texture) {
        this.target = target;
        this.colorVariation = colorVariation;
        this.alphaVariation = alphaVariation;
        this.texture = texture;
        int i = 0;
        while (i < 4) {
            int j = 0;
            while (j < 4) {
                this.phase[i][j] = (float)(Math.random() * 3.0 + 1.0);
                ++j;
            }
            ++i;
        }
    }

    public boolean doTick() {
        Color c = this.target.getBackgroundColor();
        if (this.target.hasFocus() || this.target instanceof Dialog) {
            if (c != null) {
                float time = Interface.getTime();
                int i = 0;
                while (i < 4) {
                    this.red[i] = (byte)Math.max(Math.min(255.0f, (float)Math.cos(time * this.phase[i][0]) * this.colorVariation + (float)c.getRed()), 0.0f);
                    this.green[i] = (byte)Math.max(Math.min(255.0f, (float)Math.cos(time * this.phase[i][1]) * this.colorVariation + (float)c.getGreen()), 0.0f);
                    this.blue[i] = (byte)Math.max(Math.min(255.0f, (float)Math.cos(time * this.phase[i][2]) * this.colorVariation + (float)c.getBlue()), 0.0f);
                    this.alpha[i] = (byte)Math.max(Math.min(255.0f, (float)Math.cos(time * this.phase[i][3]) * this.alphaVariation + (float)c.getAlpha()), 0.0f);
                    ++i;
                }
            }
            return true;
        }
        if (c != null) {
            int i = 0;
            while (i < 4) {
                this.red[i] = (byte)c.getRed();
                this.green[i] = (byte)c.getGreen();
                this.blue[i] = (byte)c.getBlue();
                this.alpha[i] = (byte)c.getAlpha();
                ++i;
            }
        }
        return false;
    }

    public void render() {
        Color backgroundColor = this.target.getBackgroundColor();
        if (backgroundColor != null) {
            GL11.glEnable((int)3042);
            GL11.glShadeModel((int)7425);
            GL11.glBlendFunc((int)770, (int)771);
            if (this.texture == null) {
                GL11.glDisable((int)3553);
            } else {
                GL11.glEnable((int)3553);
                GL11.glTexEnvi((int)8960, (int)8704, (int)8448);
                this.texture.render();
            }
            GL11.glBegin((int)7);
            this.target.setGLColor(this.red[0], this.green[0], this.blue[0], this.alpha[0]);
            if (this.texture != null) {
                GL11.glTexCoord2f((float)0.0f, (float)0.0f);
            }
            GL11.glVertex2f((float)0.0f, (float)0.0f);
            this.target.setGLColor(this.red[1], this.green[1], this.blue[1], this.alpha[1]);
            if (this.texture != null) {
                GL11.glTexCoord2f((float)((float)this.target.getWidth() / (float)this.texture.getWidth()), (float)0.0f);
            }
            GL11.glVertex2f((float)this.target.getWidth(), (float)0.0f);
            this.target.setGLColor(this.red[2], this.green[2], this.blue[2], this.alpha[2]);
            if (this.texture != null) {
                GL11.glTexCoord2f((float)((float)this.target.getWidth() / (float)this.texture.getWidth()), (float)((float)this.target.getHeight() / (float)this.texture.getHeight()));
            }
            GL11.glVertex2f((float)this.target.getWidth(), (float)this.target.getHeight());
            this.target.setGLColor(this.red[3], this.green[3], this.blue[3], this.alpha[3]);
            if (this.texture != null) {
                GL11.glTexCoord2f((float)0.0f, (float)((float)this.target.getHeight() / (float)this.texture.getHeight()));
            }
            GL11.glVertex2f((float)0.0f, (float)this.target.getHeight());
            GL11.glEnd();
            if (this.texture != null) {
                GL11.glDisable((int)3553);
            }
        }
    }
}

