/*
 * Decompiled with CFR 0.152.
 */
package xap.gui;

import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.interpolators.LinearInterpolator;
import com.shavenpuppy.jglib.opengl.GLString;
import com.shavenpuppy.jglib.opengl.GLTexture;
import java.util.ArrayList;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Color;
import org.lwjgl.util.ReadablePoint;
import org.lwjgl.util.Rectangle;
import xap.gui.Component;
import xap.gui.GroupButton;
import xap.gui.GroupButtonListener;
import xap.gui.Interface;
import xap.gui.MouseAdapter;

public abstract class GroupButton
extends Component {
    private final GLString label;
    protected GLTexture radioButtonsTexture;
    private final ArrayList listeners = new ArrayList();
    protected boolean checked;
    private boolean leftText;
    private boolean justified;
    protected int checkX;
    protected int checkY;
    private static final int MARGIN = 8;
    private static final int DEFAULT = 0;
    private static final int HIGHLIGHTED = 1;
    private int currentState = 0;
    private int newState = 0;
    private static final int TRANSITION_SPEED = 12;
    private static final int TOTAL_TRANSITION = 24;
    private int ticker = 1;
    private final Color textColor = new Color();

    public GroupButton(String text) throws Exception {
        this.radioButtonsTexture = (GLTexture)Resources.get((String)"radioButtons.texture");
        this.label = new GLString(text.length());
        this.label.setText(text);
        this.label.setLocation(10, 0);
        this.setBackgroundColor(Interface.getControlBackgroundColor());
        class EventHandler
        extends MouseAdapter {
            final /* synthetic */ GroupButton this$0;

            EventHandler(GroupButton groupButton) {
                this.this$0 = groupButton;
            }

            public boolean mouseEntered(Component src, int x, int y, int buttonFlags) {
                GroupButton.access$0(this.this$0, 1);
                GroupButton.access$2(this.this$0, 12 - Math.min(12, GroupButton.access$1(this.this$0)));
                return false;
            }

            public boolean mouseExited(Component src, int x, int y, int buttonFlags) {
                GroupButton.access$0(this.this$0, 0);
                GroupButton.access$2(this.this$0, 24 - GroupButton.access$1(this.this$0));
                return false;
            }
        }
        EventHandler eventHandler = new EventHandler(this);
        this.addMouseListener(eventHandler);
    }

    public void doLayout() {
        this.label.setFont(this.getFont());
        this.label.layout();
    }

    protected boolean doTick() {
        boolean ret = false;
        if (this.currentState != this.newState || this.ticker > 0) {
            if (this.ticker > 0) {
                --this.ticker;
            }
            if (this.ticker == 0) {
                this.currentState = this.newState;
            }
            float transition = (float)Math.min(12, this.ticker) / 12.0f;
            Color fg = Interface.getDefaultForeground();
            switch (this.newState) {
                case 0: {
                    this.textColor.set((int)LinearInterpolator.instance.interpolate((float)fg.getRed(), 255.0f, transition), (int)LinearInterpolator.instance.interpolate((float)fg.getGreen(), 255.0f, transition), (int)LinearInterpolator.instance.interpolate((float)fg.getBlue(), 255.0f, transition));
                    this.setForegroundColor(this.textColor);
                    break;
                }
                case 1: {
                    this.textColor.set((int)LinearInterpolator.instance.interpolate(255.0f, (float)fg.getRed(), transition), (int)LinearInterpolator.instance.interpolate(255.0f, (float)fg.getGreen(), transition), (int)LinearInterpolator.instance.interpolate(255.0f, (float)fg.getBlue(), transition));
                    this.setForegroundColor(this.textColor);
                    break;
                }
            }
            ret = true;
        }
        if (this.isChanged()) {
            this.label.setFont(this.getFont());
            this.label.setLocation(0, 0);
            this.label.layout();
            this.checkY = (this.getFont().getHeight() - 16) / 2;
            Rectangle r = new Rectangle();
            this.label.getBounds(r);
            if (this.leftText) {
                this.checkX = this.size.getWidth() - 16;
                if (!this.justified) {
                    this.label.setLocation(this.checkX - (r.getWidth() + 8), this.getFont().getDescent());
                    this.label.layout();
                }
            } else {
                this.checkX = 0;
                if (this.justified) {
                    this.label.setLocation(this.size.getWidth() - r.getWidth(), this.getFont().getDescent());
                    this.label.layout();
                } else {
                    this.label.setLocation(24, this.getFont().getDescent());
                    this.label.layout();
                }
            }
            ret = true;
        }
        return ret;
    }

    public boolean isChecked() {
        return this.checked;
    }

    public boolean isJustified() {
        return this.justified;
    }

    public boolean isLeftText() {
        return this.leftText;
    }

    protected abstract void renderButton();

    protected void renderSelf() {
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glTexEnvi((int)8960, (int)8704, (int)8448);
        Color c = this.getForegroundColor();
        if (c == null) {
            c = Interface.getDefaultForeground();
        }
        if (!this.isEnabled()) {
            c = Interface.getControlDisabledTextColor();
        }
        this.setGLColor(c);
        this.label.render();
        this.postRender();
        this.renderButton();
        this.preRender();
    }

    protected void postRender() {
        if (this.hasFocus()) {
            GL11.glPopMatrix();
        }
    }

    protected void preRender() {
        if (this.hasFocus()) {
            GL11.glPushMatrix();
            float scale = (float)Math.cos(Interface.getTime() * 8.0f) / 16.0f + 1.0f;
            GL11.glTranslatef((float)((float)this.getWidth() / 2.0f), (float)((float)this.getHeight() / 2.0f), (float)0.0f);
            GL11.glScalef((float)scale, (float)scale, (float)1.0f);
            GL11.glTranslatef((float)((float)this.getWidth() / -2.0f), (float)((float)this.getHeight() / -2.0f), (float)0.0f);
        }
    }

    public abstract void setChecked(boolean var1);

    public void setJustified(boolean newJustified) {
        if (this.justified != newJustified) {
            this.justified = newJustified;
            this.setChanged(true);
        }
    }

    public void setLeftText(boolean newLeftText) {
        if (this.leftText != newLeftText) {
            this.leftText = newLeftText;
            this.setChanged(true);
        }
    }

    public String toString() {
        return "GroupButton " + this.label.getText() + (this.isChecked() ? " (checked)" : "");
    }

    public Component pack() {
        this.layout();
        Rectangle bounds = new Rectangle();
        Rectangle r = new Rectangle();
        this.label.getBounds(r);
        bounds.setSize(r.getWidth(), this.getFont().getHeight());
        bounds.setWidth(bounds.getWidth() + 26);
        bounds.setHeight(Math.max(16, bounds.getHeight()));
        bounds.setLocation((ReadablePoint)this.location);
        this.setBounds(bounds);
        return this;
    }

    public void addGroupButtonListener(GroupButtonListener listener) {
        this.listeners.add(listener);
    }

    public void removeGroupButtonListener(GroupButtonListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireGroupButtonChanged() {
        int n = this.listeners.size();
        int i = 0;
        while (i < n) {
            if (((GroupButtonListener)this.listeners.get(i)).groupButtonChanged(this, this.isChecked())) break;
            ++i;
        }
    }

    static /* synthetic */ void access$0(GroupButton groupButton, int n) {
        groupButton.newState = n;
    }

    static /* synthetic */ int access$1(GroupButton groupButton) {
        return groupButton.ticker;
    }

    static /* synthetic */ void access$2(GroupButton groupButton, int n) {
        groupButton.ticker = n;
    }
}

