/*
 * Decompiled with CFR 0.152.
 */
package xap.gidrahs.full;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.openal.ALBuffer;
import com.shavenpuppy.jglib.sprites.Animation;
import com.shavenpuppy.jglib.util.FPMath;
import com.shavenpuppy.jglib.util.Util;
import com.shavenpuppy.jglib.util.XMLUtil;
import com.shavenpuppy.jglib.vector.ReadableVector3i;
import com.shavenpuppy.jglib.vector.Vector3i;
import com.shavenpuppy.jglib.vector.WritableVector3i;
import org.w3c.dom.Element;
import xap.Game;
import xap.features.EntityFeature;
import xap.gidrahs.BasicGidrahFeature;

public class WormFeature
extends BasicGidrahFeature {
    public static final long serialVersionUID = 1L;
    private static final Vector3i scratchVector = new Vector3i();
    private static final int WRIGGLING = 0;
    private static final int STILL = 1;
    private int speed;
    private int splitChance;
    private int homingAccuracy;
    private int speedDifficultyFactor;
    private float splitDifficultyFactor;
    private int minPause;
    private int maxPause;
    private float pauseDifficultyFactor;
    private int maxChildren;
    private String splitSoundEffect;
    private int maxWorms;
    private transient Animation[] animation;
    private transient Animation[] shadowAnimation;
    private transient ALBuffer splitSoundEffectResource;
    private transient int totalWorms;

    public WormFeature(String name) {
        super(name);
    }

    protected EntityFeature.EntityInstance doSpawn() {
        return new WormInstance();
    }

    protected void doCreate() throws Exception {
        super.doCreate();
        this.animation = new Animation[32];
        int i = 0;
        while (i < 32) {
            this.animation[i] = (Animation)Resources.get((String)("worm" + i + ".animation"));
            ++i;
        }
        this.shadowAnimation = new Animation[32];
        i = 0;
        while (i < 32) {
            this.shadowAnimation[i] = (Animation)Resources.get((String)("worm" + i + "_shadow.animation"));
            ++i;
        }
        if (Game.hasSound()) {
            this.splitSoundEffectResource = (ALBuffer)Resources.get((String)this.splitSoundEffect);
        }
    }

    protected void doDestroy() {
        super.doDestroy();
        this.animation = null;
        this.shadowAnimation = null;
        this.splitSoundEffectResource = null;
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        super.load(element, loader);
        this.speed = FPMath.fpValue((float)XMLUtil.getFloat((Element)element, (String)"speed"));
        this.splitChance = XMLUtil.getInt((Element)element, (String)"splitchance");
        this.homingAccuracy = XMLUtil.getInt((Element)element, (String)"homingaccuracy");
        this.speedDifficultyFactor = FPMath.fpValue((float)XMLUtil.getFloat((Element)element, (String)"speeddifficultyfactor"));
        this.splitDifficultyFactor = XMLUtil.getFloat((Element)element, (String)"splitdifficultyfactor");
        this.minPause = XMLUtil.getInt((Element)element, (String)"minpause");
        this.maxPause = XMLUtil.getInt((Element)element, (String)"maxpause");
        this.pauseDifficultyFactor = XMLUtil.getFloat((Element)element, (String)"pausedifficultyfactor");
        this.maxChildren = XMLUtil.getInt((Element)element, (String)"maxchildren");
        this.splitSoundEffect = XMLUtil.getString((Element)element, (String)"splitsoundeffect");
        this.maxWorms = XMLUtil.getInt((Element)element, (String)"maxworms");
    }

    public void onNewLevel() throws Exception {
        super.onNewLevel();
        this.totalWorms = 0;
    }

    private class WormInstance
    extends BasicGidrahFeature.BasicGidrahInstance {
        private int direction;
        private int children;
        private int tick;
        private int phase;
        private final int newSpeed;
        static final /* synthetic */ boolean $assertionsDisabled;
        static /* synthetic */ Class class$0;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("xap.gidrahs.full.WormFeature$WormInstance");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        WormInstance() {
            int level = Game.getCurrentLevel();
            this.newSpeed = level < Game.getGameMode().getDifficultyLevel() ? WormFeature.this.speed : WormFeature.this.speed + WormFeature.this.speedDifficultyFactor * (Game.getCurrentLevel() - Game.getGameMode().getDifficultyLevel());
        }

        private void setDirection(int direction) {
            this.direction = direction;
            this.velocity.set(FPMath.mul((int)this.newSpeed, (int)FPMath.cos((int)(direction * 2048))) << Game.getOptions().getSpeedShift(), FPMath.mul((int)this.newSpeed, (int)FPMath.sin((int)(direction * 2048))) << Game.getOptions().getSpeedShift(), 0);
            int ad = 31 - direction;
            ad += 24;
            this.sprite.setAnimation(WormFeature.this.animation[ad %= 32]);
            this.shadowSprite.setAnimation(WormFeature.this.shadowAnimation[ad]);
        }

        protected void initSprite() {
            this.setDirection(Util.random((int)0, (int)31));
            this.shadowSprite.setScale(FPMath.TWO);
        }

        protected void doGidrahTick() {
            super.doGidrahTick();
            switch (this.phase) {
                case 1: {
                    this.tick -= 1 + Game.getOptions().getSpeedShift();
                    if (this.tick > 0) break;
                    this.phase = 0;
                    this.setDirection(this.direction);
                }
                case 0: {
                    WormInstance worm;
                    Vector3i.add((ReadableVector3i)this.position, (ReadableVector3i)this.velocity, (WritableVector3i)this.position);
                    if (this.sprite.getEvent() != 1) break;
                    this.sprite.setEvent(0);
                    if (Math.random() < 0.5) {
                        this.tick = Util.random((int)WormFeature.this.minPause, (int)this.getMaxPauseTime());
                        this.sprite.setAnimation(null);
                        this.shadowSprite.setAnimation(null);
                        this.phase = 1;
                        break;
                    }
                    if (Util.random((int)0, (int)100) < WormFeature.this.homingAccuracy) {
                        Vector3i.sub((ReadableVector3i)Game.getPlayer().getLastKnownPosition(), (ReadableVector3i)this.position, (WritableVector3i)scratchVector);
                        double angle = Math.atan2(scratchVector.getY(), scratchVector.getX());
                        int newDirection = (int)(32.0 * angle / (Math.PI * 2));
                        newDirection += 32;
                        this.setDirection(newDirection %= 32);
                    }
                    if (this.children >= WormFeature.this.maxChildren || WormFeature.this.totalWorms >= WormFeature.this.maxWorms || Util.random((int)0, (int)100) >= this.getSplitChance() || (worm = (WormInstance)WormFeature.this.spawn()) == null) break;
                    ++this.children;
                    this.getPosition(worm.position);
                    worm.hatch();
                    Game.allocateSound(WormFeature.this.splitSoundEffectResource, this.position, null, this);
                    worm.children = this.children;
                    break;
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    break;
                }
            }
            this.sprite.setLocation(FPMath.intValue((int)this.position.getX()), FPMath.intValue((int)this.position.getY()), 0);
            this.shadowSprite.setLocation(FPMath.intValue((int)this.position.getX()), FPMath.intValue((int)this.position.getY()), 0);
        }

        protected void doResIn() {
            this.randomLocation(this.position);
        }

        private int getSplitChance() {
            int level = Game.getCurrentLevel();
            if (level < Game.getGameMode().getDifficultyLevel()) {
                return WormFeature.this.splitChance;
            }
            return (int)((float)WormFeature.this.splitChance + WormFeature.this.splitDifficultyFactor * (float)(level - Game.getGameMode().getDifficultyLevel()));
        }

        private int getMaxPauseTime() {
            int level = Game.getCurrentLevel();
            if (level < Game.getGameMode().getDifficultyLevel()) {
                return WormFeature.this.maxPause;
            }
            return WormFeature.this.maxPause - (int)(WormFeature.this.pauseDifficultyFactor * (float)(level - Game.getGameMode().getDifficultyLevel()));
        }

        protected void doGidrahBirth() {
            super.doGidrahBirth();
            WormFeature wormFeature = WormFeature.this;
            wormFeature.totalWorms = wormFeature.totalWorms + 1;
        }

        protected void doGidrahRemove() {
            super.doGidrahRemove();
            WormFeature wormFeature = WormFeature.this;
            wormFeature.totalWorms = wormFeature.totalWorms - 1;
        }
    }
}

