/*
 * Decompiled with CFR 0.152.
 */
package xap.gidrahs.full;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.sprites.Animation;
import com.shavenpuppy.jglib.util.FPMath;
import com.shavenpuppy.jglib.util.XMLUtil;
import com.shavenpuppy.jglib.vector.ReadableVector3i;
import com.shavenpuppy.jglib.vector.Vector3i;
import com.shavenpuppy.jglib.vector.WritableVector3i;
import org.w3c.dom.Element;
import xap.Game;
import xap.features.EntityFeature;
import xap.gidrahs.BasicGidrahFeature;

public class RovingEyeFeature
extends BasicGidrahFeature {
    public static final long serialVersionUID = 1L;
    private static final Vector3i scratchVector = new Vector3i();
    private int minDistanceFromPlayer;
    private int maxDistanceFromPlayer;
    private int difficultyFactor;
    private int speed;
    private String wobbleAnimation;
    private String wobbleShadowAnimation;
    private String shootAnimation;
    private String shootShadowAnimation;
    private transient Animation wobbleAnimationResource;
    private transient Animation wobbleShadowAnimationResource;
    private transient Animation shootAnimationResource;
    private transient Animation shootShadowAnimationResource;
    private static final int PHASE_WOBBLING = 0;
    private static final int PHASE_SHOOTING = 1;

    public RovingEyeFeature(String name) {
        super(name);
    }

    protected EntityFeature.EntityInstance doSpawn() {
        return new RovingEyeInstance();
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        super.load(element, loader);
        this.minDistanceFromPlayer = XMLUtil.getInt((Element)element, (String)"mindistancefromplayer");
        this.maxDistanceFromPlayer = XMLUtil.getInt((Element)element, (String)"maxdistancefromplayer");
        this.difficultyFactor = XMLUtil.getInt((Element)element, (String)"difficultyfactor");
        this.speed = FPMath.fpValue((int)XMLUtil.getInt((Element)element, (String)"speed"));
        this.wobbleAnimation = XMLUtil.getString((Element)element, (String)"wobbleanimation");
        this.wobbleShadowAnimation = XMLUtil.getString((Element)element, (String)"wobbleshadowanimation");
        this.shootAnimation = XMLUtil.getString((Element)element, (String)"shootanimation");
        this.shootShadowAnimation = XMLUtil.getString((Element)element, (String)"shootshadowanimation");
    }

    protected void doCreate() throws Exception {
        super.doCreate();
        this.wobbleAnimationResource = (Animation)Resources.get((String)this.wobbleAnimation);
        this.wobbleShadowAnimationResource = (Animation)Resources.get((String)this.wobbleShadowAnimation);
        this.shootAnimationResource = (Animation)Resources.get((String)this.shootAnimation);
        this.shootShadowAnimationResource = (Animation)Resources.get((String)this.shootShadowAnimation);
    }

    protected void doDestroy() {
        super.doDestroy();
        this.wobbleAnimationResource = null;
        this.wobbleShadowAnimationResource = null;
        this.shootAnimationResource = null;
        this.shootShadowAnimationResource = null;
    }

    private class RovingEyeInstance
    extends BasicGidrahFeature.BasicGidrahInstance {
        private final Vector3i target = new Vector3i();
        private int phase;
        private int tick;
        static final /* synthetic */ boolean $assertionsDisabled;
        static /* synthetic */ Class class$0;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("xap.gidrahs.full.RovingEyeFeature$RovingEyeInstance");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        RovingEyeInstance() {
        }

        protected void initSprite() {
            this.sprite.setAnimation(RovingEyeFeature.this.wobbleAnimationResource);
            this.shadowSprite.setAnimation(RovingEyeFeature.this.wobbleShadowAnimationResource);
            this.shadowSprite.setScale(FPMath.TWO);
        }

        protected void doGidrahTick() {
            super.doGidrahTick();
            block0 : switch (this.phase) {
                case 0: {
                    --this.tick;
                    if (this.tick > 0) {
                        Vector3i.add((ReadableVector3i)this.position, (ReadableVector3i)this.velocity, (WritableVector3i)this.position);
                        break;
                    }
                    this.sprite.setAnimation(RovingEyeFeature.this.shootAnimationResource);
                    this.shadowSprite.setAnimation(RovingEyeFeature.this.shootShadowAnimationResource);
                    this.phase = 1;
                    this.velocity.set(0, 0, 0);
                }
                case 1: {
                    switch (this.sprite.getEvent()) {
                        case 0: {
                            break block0;
                        }
                        case 1: {
                            this.fire();
                            this.sprite.setEvent(0);
                            break block0;
                        }
                        case 2: {
                            this.phase = 0;
                            this.sprite.setEvent(0);
                            this.selectNewTarget();
                            this.sprite.setAnimation(RovingEyeFeature.this.wobbleAnimationResource);
                            this.shadowSprite.setAnimation(RovingEyeFeature.this.wobbleShadowAnimationResource);
                            break block0;
                        }
                    }
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    break;
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    break;
                }
            }
            this.sprite.setLocation(FPMath.intValue((int)this.position.getX()), FPMath.intValue((int)this.position.getY()), 0);
            this.shadowSprite.setLocation(FPMath.intValue((int)this.position.getX()), FPMath.intValue((int)this.position.getY()), 0);
        }

        protected void doResIn() {
            this.selectNewTarget();
            this.position.set((ReadableVector3i)this.target);
            this.selectNewTarget();
        }

        private void selectNewTarget() {
            this.randomLocation(Game.getPlayer().getLastKnownPosition(), this.getDistanceFromPlayer(), this.target);
            this.tick = this.constantVelocity(this.position, this.target, RovingEyeFeature.this.speed, this.velocity);
        }

        private float getDistanceFromPlayer() {
            int level = Game.getCurrentLevel();
            if (level < Game.getGameMode().getDifficultyLevel()) {
                return RovingEyeFeature.this.maxDistanceFromPlayer;
            }
            return Math.max(RovingEyeFeature.this.minDistanceFromPlayer, RovingEyeFeature.this.maxDistanceFromPlayer - (level - Game.getGameMode().getDifficultyLevel()) * RovingEyeFeature.this.difficultyFactor);
        }
    }
}

