/*
 * Decompiled with CFR 0.152.
 */
package xap.gidrahs.full;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.util.FPMath;
import com.shavenpuppy.jglib.util.XMLUtil;
import com.shavenpuppy.jglib.vector.ReadableVector3i;
import org.w3c.dom.Element;
import xap.features.EntityFeature;
import xap.gidrahs.TringleFeature;

public class PyramidFeature
extends TringleFeature {
    public static final long serialVersionUID = 1L;
    private int splitDepth;
    private int splitCount;
    private int defaultRadius;

    public PyramidFeature(String name) {
        super(name);
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        super.load(element, loader);
        this.splitDepth = XMLUtil.getInt((Element)element, (String)"splitdepth");
        this.splitCount = XMLUtil.getInt((Element)element, (String)"splitcount");
        this.defaultRadius = FPMath.fpValue((float)XMLUtil.getFloat((Element)element, (String)"radius"));
    }

    protected EntityFeature.EntityInstance doSpawn() {
        return new PyramidInstance();
    }

    private class PyramidInstance
    extends TringleFeature.TringleInstance {
        private int size;

        PyramidInstance() {
        }

        protected void onDeath() {
            super.onDeath();
            if (this.size < PyramidFeature.this.splitDepth) {
                int i = 0;
                while (i < PyramidFeature.this.splitCount) {
                    PyramidInstance newPyramid = (PyramidInstance)PyramidFeature.this.spawn();
                    if (newPyramid != null) {
                        newPyramid.size = this.size + 1;
                        newPyramid.position.set((ReadableVector3i)this.position);
                        newPyramid.hatch();
                    }
                    ++i;
                }
            }
        }

        protected void doGidrahBirth() {
            super.doGidrahBirth();
            int scale = FPMath.ONE / (this.size + 1);
            this.sprite.setScale(scale);
            this.shadowSprite.setScale(scale <<= 1);
            int radius = PyramidFeature.this.defaultRadius / (this.size + 1);
            this.setRadius(radius);
            this.speed = PyramidFeature.this.speed << this.size;
            this.setWounds(this.size);
        }
    }
}

