/*
 * Decompiled with CFR 0.152.
 */
package xap.gidrahs.full;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.sprites.Animation;
import com.shavenpuppy.jglib.util.FPMath;
import com.shavenpuppy.jglib.util.XMLUtil;
import org.w3c.dom.Element;
import xap.features.EntityFeature;
import xap.gidrahs.BasicGidrahFeature;
import xap.resources.HVMovement;
import xap.resources.HVMovementResource;

public class MinelayerFeature
extends BasicGidrahFeature {
    public static final long serialVersionUID = 1L;
    private static final int WOBBLING = 0;
    private static final int SHOOTING = 1;
    private String wobbleAnimation;
    private String wobbleShadowAnimation;
    private String shootAnimation;
    private String shootShadowAnimation;
    private HVMovementResource movementFeature;
    private Animation wobbleAnimationResource;
    private Animation wobbleShadowAnimationResource;
    private Animation shootAnimationResource;
    private Animation shootShadowAnimationResource;

    public MinelayerFeature(String name) {
        super(name);
    }

    protected EntityFeature.EntityInstance doSpawn() {
        return new MinelayerInstance();
    }

    protected void doCreate() throws Exception {
        super.doCreate();
        this.wobbleAnimationResource = (Animation)Resources.get((String)this.wobbleAnimation);
        this.wobbleShadowAnimationResource = (Animation)Resources.get((String)this.wobbleShadowAnimation);
        this.shootAnimationResource = (Animation)Resources.get((String)this.shootAnimation);
        this.shootShadowAnimationResource = (Animation)Resources.get((String)this.shootShadowAnimation);
    }

    protected void doDestroy() {
        super.doDestroy();
        this.wobbleAnimationResource = null;
        this.wobbleShadowAnimationResource = null;
        this.shootAnimationResource = null;
        this.shootShadowAnimationResource = null;
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        super.load(element, loader);
        this.wobbleAnimation = XMLUtil.getString((Element)element, (String)"wobbleanimation");
        this.wobbleShadowAnimation = XMLUtil.getString((Element)element, (String)"wobbleshadowanimation");
        this.shootAnimation = XMLUtil.getString((Element)element, (String)"shootanimation");
        this.shootShadowAnimation = XMLUtil.getString((Element)element, (String)"shootshadowanimation");
        this.movementFeature = new HVMovementResource();
        this.movementFeature.load(element, loader);
    }

    private class MinelayerInstance
    extends BasicGidrahFeature.BasicGidrahInstance {
        private int phase;
        private HVMovement movementInstance;
        static final /* synthetic */ boolean $assertionsDisabled;
        static /* synthetic */ Class class$0;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("xap.gidrahs.full.MinelayerFeature$MinelayerInstance");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        public MinelayerInstance() {
            this.movementInstance = MinelayerFeature.this.movementFeature.spawn(this);
        }

        protected void initSprite() {
            this.sprite.setAnimation(MinelayerFeature.this.wobbleAnimationResource);
            this.shadowSprite.setAnimation(MinelayerFeature.this.wobbleShadowAnimationResource);
            this.shadowSprite.setScale(FPMath.TWO);
        }

        protected void doGidrahTick() {
            super.doGidrahTick();
            block0 : switch (this.phase) {
                case 0: {
                    if (this.sprite.getEvent() == 1) {
                        this.phase = 1;
                        this.sprite.setEvent(0);
                        this.sprite.setAnimation(MinelayerFeature.this.shootAnimationResource);
                        this.shadowSprite.setAnimation(MinelayerFeature.this.shootShadowAnimationResource);
                    } else {
                        this.movementInstance.tick();
                    }
                }
                case 1: {
                    switch (this.sprite.getEvent()) {
                        case 0: {
                            break block0;
                        }
                        case 1: {
                            this.fire();
                            this.sprite.setEvent(0);
                            break block0;
                        }
                        case 2: {
                            this.sprite.setEvent(0);
                            this.sprite.setAnimation(MinelayerFeature.this.wobbleAnimationResource);
                            this.shadowSprite.setAnimation(MinelayerFeature.this.wobbleShadowAnimationResource);
                            this.phase = 0;
                            break block0;
                        }
                    }
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    break;
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    break;
                }
            }
            this.sprite.setLocation(FPMath.intValue((int)this.position.getX()), FPMath.intValue((int)this.position.getY()), 0);
            this.shadowSprite.setLocation(FPMath.intValue((int)this.position.getX()), FPMath.intValue((int)this.position.getY()), 0);
        }

        protected void doResIn() {
            this.randomLocation(this.position);
        }
    }
}

