/*
 * Decompiled with CFR 0.152.
 */
package xap.gidrahs.full;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.openal.ALBuffer;
import com.shavenpuppy.jglib.sprites.Animation;
import com.shavenpuppy.jglib.util.FPMath;
import com.shavenpuppy.jglib.util.Util;
import com.shavenpuppy.jglib.util.XMLUtil;
import com.shavenpuppy.jglib.vector.ReadableVector3i;
import com.shavenpuppy.jglib.vector.Vector3i;
import com.shavenpuppy.jglib.vector.WritableVector3i;
import org.w3c.dom.Element;
import xap.Game;
import xap.Gidrah;
import xap.features.EncounterFeature;
import xap.features.EntityFeature;
import xap.features.GidrahFeature;
import xap.gidrahs.BasicGidrahFeature;

public class CloudFeature
extends BasicGidrahFeature {
    public static final long serialVersionUID = 1L;
    private static final int WOBBLING = 0;
    private static final int CREATING = 1;
    private String wobblingAnimation;
    private String wobblingShadowAnimation;
    private String creationAnimation;
    private String creationShadowAnimation;
    private int minShootInterval;
    private int maxShootInterval;
    private int minCreateInterval;
    private int maxCreateInterval;
    private String soundEffect;
    private int speed;
    private transient Animation wobblingAnimationResource;
    private transient Animation wobblingShadowAnimationResource;
    private transient Animation creationAnimationResource;
    private transient Animation creationShadowAnimationResource;
    private transient ALBuffer soundEffectResource;

    public CloudFeature(String name) {
        super(name);
    }

    protected EntityFeature.EntityInstance doSpawn() {
        return new CloudInstance();
    }

    protected void doCreate() throws Exception {
        super.doCreate();
        this.wobblingAnimationResource = (Animation)Resources.get((String)this.wobblingAnimation);
        this.wobblingShadowAnimationResource = (Animation)Resources.get((String)this.wobblingShadowAnimation);
        this.creationAnimationResource = (Animation)Resources.get((String)this.creationAnimation);
        this.creationShadowAnimationResource = (Animation)Resources.get((String)this.creationShadowAnimation);
        if (Game.hasSound()) {
            this.soundEffectResource = (ALBuffer)Resources.get((String)this.soundEffect);
        }
    }

    protected void doDestroy() {
        super.doDestroy();
        this.wobblingAnimationResource = null;
        this.wobblingShadowAnimationResource = null;
        this.creationAnimationResource = null;
        this.creationShadowAnimationResource = null;
        this.soundEffectResource = null;
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        super.load(element, loader);
        this.wobblingAnimation = XMLUtil.getString((Element)element, (String)"wobblinganimation");
        this.wobblingShadowAnimation = XMLUtil.getString((Element)element, (String)"wobblingshadowanimation");
        this.creationAnimation = XMLUtil.getString((Element)element, (String)"creationanimation");
        this.creationShadowAnimation = XMLUtil.getString((Element)element, (String)"creationshadowanimation");
        this.minShootInterval = XMLUtil.getInt((Element)element, (String)"minshootinterval");
        this.maxShootInterval = XMLUtil.getInt((Element)element, (String)"maxshootinterval");
        this.minCreateInterval = XMLUtil.getInt((Element)element, (String)"mincreateinterval");
        this.maxCreateInterval = XMLUtil.getInt((Element)element, (String)"maxcreateinterval");
        this.soundEffect = XMLUtil.getString((Element)element, (String)"soundeffect");
        this.speed = FPMath.fpValue((float)XMLUtil.getFloat((Element)element, (String)"speed"));
    }

    private class CloudInstance
    extends BasicGidrahFeature.BasicGidrahInstance {
        private int tick;
        private final Vector3i target = new Vector3i();
        private int shootTick;
        private int createTick;
        private int phase;
        static final /* synthetic */ boolean $assertionsDisabled;
        static /* synthetic */ Class class$0;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("xap.gidrahs.full.CloudFeature$CloudInstance");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        public CloudInstance() {
            this.shootTick = Util.random((int)CloudFeature.this.minShootInterval, (int)CloudFeature.this.maxShootInterval);
            this.createTick = Util.random((int)CloudFeature.this.minCreateInterval, (int)CloudFeature.this.maxCreateInterval);
        }

        protected void initSprite() {
            this.sprite.setAnimation(CloudFeature.this.wobblingAnimationResource);
            this.shadowSprite.setAnimation(CloudFeature.this.wobblingShadowAnimationResource);
            this.shadowSprite.setScale(FPMath.TWO);
        }

        protected void doGidrahTick() {
            super.doGidrahTick();
            block1 : switch (this.phase) {
                case 0: {
                    --this.tick;
                    if (this.tick <= 0) {
                        this.chooseDestination();
                    }
                    Vector3i.add((ReadableVector3i)this.position, (ReadableVector3i)this.velocity, (WritableVector3i)this.position);
                    this.shootTick -= Game.getOptions().getTicksPerFrame();
                    if (this.shootTick <= 0) {
                        this.fire();
                        this.shootTick = Util.random((int)CloudFeature.this.minShootInterval, (int)CloudFeature.this.maxShootInterval);
                    }
                    if (this.createTick > 0) {
                        this.createTick -= Game.getOptions().getTicksPerFrame();
                    }
                    if (this.createTick > 0 || GidrahFeature.getNumActiveGidrahs() >= 32) break;
                    Game.allocateSound(CloudFeature.this.soundEffectResource, this.position, null, this);
                    this.sprite.setAnimation(CloudFeature.this.creationAnimationResource);
                    this.shadowSprite.setAnimation(CloudFeature.this.creationShadowAnimationResource);
                    this.createTick = Util.random((int)CloudFeature.this.minCreateInterval, (int)CloudFeature.this.maxCreateInterval);
                    this.phase = 1;
                    break;
                }
                case 1: {
                    switch (this.sprite.getEvent()) {
                        case 0: {
                            break block1;
                        }
                        case 1: {
                            this.sprite.setEvent(0);
                            try {
                                Gidrah gidrah = EncounterFeature.createRandomEncounteredGidrah();
                                gidrah.getPosition().set((ReadableVector3i)this.position);
                                gidrah.hatch();
                            }
                            catch (Exception e) {
                                Game.handleException(e);
                            }
                            this.sprite.setAnimation(CloudFeature.this.wobblingAnimationResource);
                            this.shadowSprite.setAnimation(CloudFeature.this.wobblingShadowAnimationResource);
                            this.phase = 0;
                            break block1;
                        }
                    }
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    break;
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    break;
                }
            }
            this.sprite.setLocation(FPMath.intValue((int)this.position.getX()), FPMath.intValue((int)this.position.getY()), 0);
            this.shadowSprite.setLocation(FPMath.intValue((int)this.position.getX()), FPMath.intValue((int)this.position.getY()), 0);
        }

        protected void doResIn() {
            this.randomLocation(this.position);
            this.chooseDestination();
        }

        private void chooseDestination() {
            this.randomLocation(this.target);
            this.tick = this.constantVelocity(this.position, this.target, CloudFeature.this.speed, this.velocity);
        }
    }
}

