/*
 * Decompiled with CFR 0.152.
 */
package xap.gidrahs;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.sprites.Animation;
import com.shavenpuppy.jglib.util.FPMath;
import com.shavenpuppy.jglib.util.Util;
import com.shavenpuppy.jglib.util.XMLUtil;
import com.shavenpuppy.jglib.vector.ReadableVector3i;
import com.shavenpuppy.jglib.vector.Vector3i;
import com.shavenpuppy.jglib.vector.WritableVector3i;
import org.w3c.dom.Element;
import xap.BattleZone;
import xap.Compass;
import xap.Game;
import xap.features.EntityFeature;
import xap.gidrahs.BasicGidrahFeature;

public class TringleFeature
extends BasicGidrahFeature {
    public static final long serialVersionUID = 1L;
    protected int speed;
    private int duration;
    private int minShootInterval;
    private int maxShootInterval;
    private int difficultyFactor;
    private String wobbleAnimation;
    private String wobbleShadowAnimation;
    private int moveSpeedDifficultyThreshold;
    private int shootSpeedDifficultyThreshold;
    private transient Animation wobbleAnimationResource;
    private transient Animation wobbleShadowAnimationResource;
    private static final int THINKING = 0;
    private static final int WOBBLING = 1;

    public TringleFeature(String name) {
        super(name);
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        super.load(element, loader);
        this.minShootInterval = XMLUtil.getInt((Element)element, (String)"minshootinterval");
        this.maxShootInterval = XMLUtil.getInt((Element)element, (String)"maxshootinterval");
        this.difficultyFactor = XMLUtil.getInt((Element)element, (String)"difficultyfactor");
        this.wobbleAnimation = XMLUtil.getString((Element)element, (String)"wobbleanimation");
        this.wobbleShadowAnimation = XMLUtil.getString((Element)element, (String)"wobbleshadowanimation");
        this.speed = FPMath.fpValue((float)XMLUtil.getFloat((Element)element, (String)"speed"));
        this.duration = XMLUtil.getInt((Element)element, (String)"duration");
        this.moveSpeedDifficultyThreshold = XMLUtil.getInt((Element)element, (String)"movespeeddifficultythreshold");
        this.shootSpeedDifficultyThreshold = XMLUtil.getInt((Element)element, (String)"shootspeeddifficultythreshold");
    }

    protected EntityFeature.EntityInstance doSpawn() {
        return new TringleInstance();
    }

    protected void doCreate() throws Exception {
        super.doCreate();
        this.wobbleAnimationResource = (Animation)Resources.get((String)this.wobbleAnimation);
        this.wobbleShadowAnimationResource = (Animation)Resources.get((String)this.wobbleShadowAnimation);
    }

    protected void doDestroy() {
        super.doDestroy();
        this.wobbleAnimationResource = null;
        this.wobbleShadowAnimationResource = null;
    }

    protected class TringleInstance
    extends BasicGidrahFeature.BasicGidrahInstance {
        private int dx;
        private int dy;
        private int moveDuration;
        private int phase;
        private int shootTick;
        protected int speed;
        protected final int moveDifficultyAdjust;
        protected final int shootDifficultyAdjust;
        static final /* synthetic */ boolean $assertionsDisabled;
        static /* synthetic */ Class class$0;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("xap.gidrahs.TringleFeature$TringleInstance");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        protected TringleInstance() {
            this.moveDifficultyAdjust = Game.getCurrentLevel() + Game.getGameMode().getDifficultyOffset() < TringleFeature.this.moveSpeedDifficultyThreshold ? 1 : 0;
            this.shootDifficultyAdjust = Game.getCurrentLevel() + Game.getGameMode().getDifficultyOffset() < TringleFeature.this.shootSpeedDifficultyThreshold ? 1 : 0;
        }

        protected void initSprite() {
            this.sprite.setAnimation(TringleFeature.this.wobbleAnimationResource);
            this.shadowSprite.setAnimation(TringleFeature.this.wobbleShadowAnimationResource);
            this.shadowSprite.setScale(FPMath.TWO);
        }

        protected void doGidrahTick() {
            super.doGidrahTick();
            switch (this.phase) {
                case 0: {
                    int dir = Util.random((int)0, (int)3);
                    boolean destx = false;
                    boolean desty = false;
                    this.dx = this.position.getX() < 0 ? 1 : (this.position.getX() > BattleZone.FPWIDTH ? -1 : Compass.dx[(dir << 1) + 1]);
                    this.dy = this.position.getY() < 0 ? 1 : (this.position.getY() > BattleZone.FPWIDTH ? -1 : Compass.dy[(dir << 1) + 1]);
                    this.moveDuration = TringleFeature.this.duration >> Game.getOptions().getSpeedShift();
                    this.moveDuration <<= this.moveDifficultyAdjust;
                    this.dx *= this.speed << Game.getOptions().getSpeedShift();
                    this.dy *= this.speed << Game.getOptions().getSpeedShift();
                    this.dx >>= this.moveDifficultyAdjust;
                    this.dy >>= this.moveDifficultyAdjust;
                    this.phase = 1;
                    this.velocity.set(this.dx, this.dy, 0);
                }
                case 1: {
                    Vector3i.add((ReadableVector3i)this.position, (ReadableVector3i)this.velocity, (WritableVector3i)this.position);
                    --this.moveDuration;
                    if (this.moveDuration != 0) break;
                    this.phase = 0;
                    break;
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    break;
                }
            }
            this.sprite.setLocation(FPMath.intValue((int)this.position.getX()), FPMath.intValue((int)this.position.getY()), 0);
            this.shadowSprite.setLocation(FPMath.intValue((int)this.position.getX()), FPMath.intValue((int)this.position.getY()), 0);
            --this.shootTick;
            if (this.shootTick <= 0) {
                this.fire();
                this.shootTick = Util.random((int)TringleFeature.this.minShootInterval, (int)this.getMaxShootInterval()) >> Game.getOptions().getSpeedShift();
                this.shootTick <<= this.shootDifficultyAdjust;
            }
        }

        private int getMaxShootInterval() {
            int level = Game.getCurrentLevel();
            if (level < Game.getGameMode().getDifficultyLevel()) {
                return TringleFeature.this.maxShootInterval;
            }
            return Math.max(TringleFeature.this.maxShootInterval >> 1, TringleFeature.this.maxShootInterval - (level - Game.getGameMode().getDifficultyLevel()) * TringleFeature.this.difficultyFactor);
        }

        protected void doGidrahBirth() {
            this.shootTick = Util.random((int)TringleFeature.this.minShootInterval, (int)TringleFeature.this.maxShootInterval);
            this.speed = TringleFeature.this.speed;
        }

        protected void doResIn() {
            this.randomLocation(this.position);
        }
    }
}

