/*
 * Decompiled with CFR 0.152.
 */
package xap.gidrahs;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.sprites.Animation;
import com.shavenpuppy.jglib.util.FPMath;
import com.shavenpuppy.jglib.util.Util;
import com.shavenpuppy.jglib.util.XMLUtil;
import org.w3c.dom.Element;
import xap.Entity;
import xap.Game;
import xap.HomingMovement;
import xap.MadJelly;
import xap.SpawnReplacement;
import xap.features.EntityFeature;
import xap.gidrahs.BasicGidrahFeature;
import xap.resources.HomingMovementResource;

public class MadJellyFeature
extends BasicGidrahFeature
implements SpawnReplacement {
    public static final long serialVersionUID = 1L;
    private HomingMovementResource movementFeature;
    private int shootInterval;
    private float difficultyFactor;
    private float resInDistance;
    private float resInVariation;
    private String jellyAnimation;
    private String jellyShadowAnimation;
    private transient Animation jellyAnimationResource;
    private transient Animation jellyShadowAnimationResource;

    public MadJellyFeature(String name) {
        super(name);
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        super.load(element, loader);
        this.movementFeature = new HomingMovementResource();
        this.movementFeature.load(element, loader);
        this.difficultyFactor = XMLUtil.getFloat((Element)element, (String)"difficultyfactor");
        this.shootInterval = XMLUtil.getInt((Element)element, (String)"shootinterval");
        this.resInDistance = XMLUtil.getFloat((Element)element, (String)"resindistance");
        this.resInVariation = XMLUtil.getFloat((Element)element, (String)"resinvariation");
        this.jellyAnimation = XMLUtil.getString((Element)element, (String)"jellyanimation");
        this.jellyShadowAnimation = XMLUtil.getString((Element)element, (String)"jellyshadowanimation");
    }

    protected void doCreate() throws Exception {
        super.doCreate();
        this.jellyAnimationResource = (Animation)Resources.get((String)this.jellyAnimation);
        this.jellyShadowAnimationResource = (Animation)Resources.get((String)this.jellyShadowAnimation);
    }

    protected void doDestroy() {
        super.doDestroy();
        this.jellyAnimationResource = null;
        this.jellyShadowAnimationResource = null;
    }

    protected EntityFeature.EntityInstance doSpawn() {
        return new MadJellyInstance();
    }

    public Entity getReplacement() {
        return this.doSpawn();
    }

    private final class MadJellyInstance
    extends BasicGidrahFeature.BasicGidrahInstance
    implements MadJelly {
        private int shootTick;
        private final HomingMovement movement;

        MadJellyInstance() {
            this.movement = MadJellyFeature.this.movementFeature.spawn(this);
        }

        protected void doGidrahBirth() {
            this.shootTick = Util.random((int)1, (int)MadJellyFeature.this.shootInterval);
        }

        protected void initSprite() {
            this.sprite.setAnimation(MadJellyFeature.this.jellyAnimationResource);
            this.shadowSprite.setAnimation(MadJellyFeature.this.jellyShadowAnimationResource);
            this.shadowSprite.setScale(FPMath.TWO);
        }

        protected void doGidrahTick() {
            super.doGidrahTick();
            this.movement.setDestination(Game.getPlayer().getLastKnownPosition().getX(), Game.getPlayer().getLastKnownPosition().getY());
            this.movement.tick();
            this.sprite.setLocation(FPMath.intValue((int)this.position.getX()), FPMath.intValue((int)this.position.getY()), 0);
            this.shadowSprite.setLocation(FPMath.intValue((int)this.position.getX()), FPMath.intValue((int)this.position.getY()), 0);
            this.shootTick -= Game.getOptions().getTicksPerFrame();
            if (this.shootTick <= 0) {
                this.fire();
                this.shootTick = (int)(Math.max((float)(MadJellyFeature.this.shootInterval / 2), (float)MadJellyFeature.this.shootInterval - (float)Game.getCurrentLevel() * MadJellyFeature.this.difficultyFactor) + (float)Util.random((int)1, (int)10)) >> Game.getOptions().getSpeedShift();
            }
        }

        protected void doResIn() {
            this.randomLocation(Game.getPlayer().getLastKnownPosition(), ((float)Math.random() - 0.5f) * MadJellyFeature.this.resInVariation + MadJellyFeature.this.resInDistance, this.position);
        }
    }
}

