/*
 * Decompiled with CFR 0.152.
 */
package xap.gidrahs;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.openal.ALBuffer;
import com.shavenpuppy.jglib.resources.ColorSequenceResource;
import com.shavenpuppy.jglib.sprites.Animation;
import com.shavenpuppy.jglib.util.FPMath;
import com.shavenpuppy.jglib.util.Util;
import com.shavenpuppy.jglib.util.XMLUtil;
import com.shavenpuppy.jglib.vector.ReadableVector3i;
import com.shavenpuppy.jglib.vector.Vector3i;
import com.shavenpuppy.jglib.vector.WritableVector3i;
import org.lwjgl.util.Color;
import org.w3c.dom.Element;
import xap.BattleZone;
import xap.Blob;
import xap.Compass;
import xap.Game;
import xap.Gidrah;
import xap.SpawnReplacement;
import xap.effects.StrobeEffect;
import xap.features.BlobFeature;
import xap.features.EntityFeature;
import xap.gidrahs.BasicGidrahFeature;

public class BubbleFeature
extends BasicGidrahFeature {
    public static final long serialVersionUID = 1L;
    private float resInDistance;
    private float difficultyFactor;
    private String wobbleAnimation;
    private String gestateAnimation;
    private String mutationAnimation;
    private String wobbleShadowAnimation;
    private String gestateShadowAnimation;
    private String mutationShadowAnimation;
    private int mutationTime;
    private int mutationDifficultyFactor;
    private String laughterSoundEffect;
    private String attackStrobe;
    private String mutateStrobe;
    private String spawnGidrah;
    private transient Animation wobbleAnimationResource;
    private transient Animation gestateAnimationResource;
    private transient Animation mutationAnimationResource;
    private transient Animation wobbleShadowAnimationResource;
    private transient Animation gestateShadowAnimationResource;
    private transient Animation mutationShadowAnimationResource;
    private transient ALBuffer laughterSoundEffectResource;
    private transient ColorSequenceResource attackStrobeResource;
    private transient ColorSequenceResource mutateStrobeResource;
    private transient SpawnReplacement spawnGidrahFeature;
    private static final int THINKING = 0;
    private static final int WOBBLING = 1;
    private static final int ATTACKING = 2;
    private static final int GESTATING = 3;
    private static final int MUTATING = 4;

    public BubbleFeature(String name) {
        super(name);
    }

    protected EntityFeature.EntityInstance doSpawn() {
        if (BlobFeature.getNumBlobs() == 0) {
            try {
                return (EntityFeature.EntityInstance)this.spawnGidrahFeature.getReplacement();
            }
            catch (Exception e) {
                Game.handleException(e);
                return null;
            }
        }
        return new BubbleInstance();
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        super.load(element, loader);
        this.resInDistance = XMLUtil.getFloat((Element)element, (String)"resindistance");
        this.difficultyFactor = XMLUtil.getFloat((Element)element, (String)"difficultyfactor");
        this.wobbleAnimation = XMLUtil.getString((Element)element, (String)"wobbleanimation");
        this.gestateAnimation = XMLUtil.getString((Element)element, (String)"gestateanimation");
        this.mutationAnimation = XMLUtil.getString((Element)element, (String)"mutationanimation");
        this.wobbleShadowAnimation = XMLUtil.getString((Element)element, (String)"wobbleshadowanimation");
        this.gestateShadowAnimation = XMLUtil.getString((Element)element, (String)"gestateshadowanimation");
        this.mutationShadowAnimation = XMLUtil.getString((Element)element, (String)"mutationshadowanimation");
        this.mutationTime = XMLUtil.getInt((Element)element, (String)"mutationtime");
        this.mutationDifficultyFactor = XMLUtil.getInt((Element)element, (String)"mutationdifficultyfactor");
        this.laughterSoundEffect = XMLUtil.getString((Element)element, (String)"laughtersoundeffect");
        this.attackStrobe = XMLUtil.getString((Element)element, (String)"attackstrobe");
        this.mutateStrobe = XMLUtil.getString((Element)element, (String)"mutatestrobe");
        this.spawnGidrah = XMLUtil.getString((Element)element, (String)"spawngidrah");
    }

    protected void doCreate() throws Exception {
        super.doCreate();
        this.wobbleAnimationResource = (Animation)Resources.get((String)this.wobbleAnimation);
        this.gestateAnimationResource = (Animation)Resources.get((String)this.gestateAnimation);
        this.mutationAnimationResource = (Animation)Resources.get((String)this.mutationAnimation);
        this.wobbleShadowAnimationResource = (Animation)Resources.get((String)this.wobbleShadowAnimation);
        this.gestateShadowAnimationResource = (Animation)Resources.get((String)this.gestateShadowAnimation);
        this.mutationShadowAnimationResource = (Animation)Resources.get((String)this.mutationShadowAnimation);
        if (Game.hasSound()) {
            this.laughterSoundEffectResource = (ALBuffer)Resources.get((String)this.laughterSoundEffect);
        }
        this.attackStrobeResource = (ColorSequenceResource)Resources.get((String)this.attackStrobe);
        this.mutateStrobeResource = (ColorSequenceResource)Resources.get((String)this.mutateStrobe);
        this.spawnGidrahFeature = (SpawnReplacement)Resources.get((String)this.spawnGidrah);
    }

    protected void doDestroy() {
        super.doDestroy();
        this.wobbleAnimationResource = null;
        this.gestateAnimationResource = null;
        this.mutationAnimationResource = null;
        this.wobbleShadowAnimationResource = null;
        this.gestateShadowAnimationResource = null;
        this.mutationShadowAnimationResource = null;
        this.laughterSoundEffectResource = null;
        this.attackStrobeResource = null;
        this.mutateStrobeResource = null;
        this.spawnGidrahFeature = null;
    }

    private final class BubbleInstance
    extends BasicGidrahFeature.BasicGidrahInstance {
        private int dx;
        private int dy;
        private int duration;
        private int phase = 0;
        private Blob targetBlob;
        private int blipTick;
        static final /* synthetic */ boolean $assertionsDisabled;
        static /* synthetic */ Class class$0;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("xap.gidrahs.BubbleFeature$BubbleInstance");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        BubbleInstance() {
        }

        private void setPhase(int newPhase) {
            if (newPhase != this.phase) {
                switch (newPhase) {
                    case 0: {
                        if (!($assertionsDisabled || this.phase != 4 && this.phase != 3)) {
                            throw new AssertionError((Object)"Illegal bubble state change");
                        }
                        break;
                    }
                    case 1: {
                        if (!$assertionsDisabled && this.phase != 0) {
                            throw new AssertionError((Object)"Illegal bubble state change");
                        }
                        break;
                    }
                    case 2: {
                        if (!$assertionsDisabled && this.phase != 1 && this.phase != 0) {
                            throw new AssertionError((Object)"Illegal bubble state change");
                        }
                        break;
                    }
                    case 3: {
                        if (!$assertionsDisabled && this.phase != 2) {
                            throw new AssertionError((Object)"Illegal bubble state change");
                        }
                        break;
                    }
                    case 4: {
                        if (!$assertionsDisabled && this.phase != 3) {
                            throw new AssertionError((Object)"Illegal bubble state change");
                        }
                        break;
                    }
                    default: {
                        if (!$assertionsDisabled) {
                            throw new AssertionError((Object)"Illegal bubble state");
                        }
                        break;
                    }
                }
                this.phase = newPhase;
            }
        }

        protected void doGidrahTick() {
            super.doGidrahTick();
            switch (this.phase) {
                case 0: {
                    int dir = Util.random((int)0, (int)3);
                    int destx = 0;
                    int desty = 0;
                    double probability = this.targetBlob != null && this.targetBlob.isGolden() ? 1.0 - (double)(Game.getCurrentLevel() + Game.getGameMode().getDifficultyOffset()) * 0.05 : (BlobFeature.getNumBlobs() == 0 ? 0.0 : 1.0 - (double)(Game.getCurrentLevel() + Game.getGameMode().getDifficultyOffset()) * 0.01);
                    if (Math.random() < probability) {
                        dir = dir + 1 & 3;
                        this.dx = Compass.dx[(dir << 1) + 1];
                        this.dy = Compass.dy[(dir << 1) + 1];
                        int speed = (Game.getCurrentLevel() + Game.getGameMode().getDifficultyOffset() == 0 ? 3 : 4) + Game.getOptions().getSpeedShift();
                        destx = this.position.getX() + FPMath.fpValue((int)(this.dx << speed));
                        desty = this.position.getY() + FPMath.fpValue((int)(this.dy << speed));
                        this.dx = destx < 0 ? FPMath.fpValue((int)1) : (destx >= BattleZone.FPWIDTH ? FPMath.fpValue((int)-1) : FPMath.fpValue((int)this.dx));
                        this.dy = desty < 0 ? FPMath.fpValue((int)1) : (desty >= BattleZone.FPHEIGHT ? FPMath.fpValue((int)-1) : FPMath.fpValue((int)this.dy));
                    } else {
                        Vector3i homing = null;
                        if (this.targetBlob != null) {
                            if (this.targetBlob.isAlive()) {
                                homing = this.targetBlob.getPosition();
                            } else {
                                this.targetBlob = BlobFeature.getRandomBlob();
                                if (this.targetBlob != null) {
                                    homing = this.targetBlob.getPosition();
                                }
                            }
                        }
                        if (homing == null) {
                            homing = Game.getPlayer().getLastKnownPosition();
                        }
                        this.dx = homing.getX() < this.position.getX() ? FPMath.fpValue((int)-1) : FPMath.fpValue((int)1);
                        this.dy = homing.getY() < this.position.getY() ? FPMath.fpValue((int)-1) : FPMath.fpValue((int)1);
                    }
                    if (Game.getCurrentLevel() + Game.getGameMode().getDifficultyOffset() == 0) {
                        this.duration = 128;
                        this.dx >>= 2 - Game.getOptions().getSpeedShift();
                        this.dy >>= 2 - Game.getOptions().getSpeedShift();
                    } else {
                        this.duration = 32;
                        this.dx >>= 1 - Game.getOptions().getSpeedShift();
                        this.dy >>= 1 - Game.getOptions().getSpeedShift();
                    }
                    this.duration >>= Game.getOptions().getSpeedShift();
                    this.setPhase(1);
                    this.velocity.set(this.dx, this.dy, 0);
                }
                case 1: {
                    Vector3i.add((ReadableVector3i)this.position, (ReadableVector3i)this.velocity, (WritableVector3i)this.position);
                    --this.duration;
                    if (this.duration != 0) break;
                    this.setPhase(0);
                    break;
                }
                case 2: {
                    if (!this.targetBlob.isAlive()) {
                        this.setPhase(0);
                        this.targetBlob = BlobFeature.getRandomBlob();
                        break;
                    }
                    int xmove = this.targetBlob.getPosition().getX() - this.position.getX();
                    int ymove = this.targetBlob.getPosition().getY() - this.position.getY();
                    if (Math.abs(xmove) > FPMath.ONE || Math.abs(ymove) > FPMath.ONE) {
                        float fxm = FPMath.floatValue((int)xmove);
                        float fym = FPMath.floatValue((int)ymove);
                        float distance = 4.0f * (float)Math.sqrt(fxm * fxm + fym * fym);
                        xmove = (int)((float)xmove / distance);
                        ymove = (int)((float)ymove / distance);
                        this.position.translate(xmove, ymove, 0);
                        break;
                    }
                    this.setPhase(3);
                    StrobeEffect.spawn(BubbleFeature.this.attackStrobeResource);
                    this.duration = 0;
                    this.sprite.setAnimation(BubbleFeature.this.gestateAnimationResource);
                    this.shadowSprite.setAnimation(BubbleFeature.this.gestateShadowAnimationResource);
                    this.targetBlob.mutate();
                }
                case 3: {
                    this.duration += Game.getOptions().getTicksPerFrame();
                    if (this.duration < this.getMutationTime()) break;
                    this.setPhase(4);
                    this.sprite.setAnimation(BubbleFeature.this.mutationAnimationResource);
                    this.shadowSprite.setAnimation(BubbleFeature.this.mutationShadowAnimationResource);
                    this.duration = 0;
                    break;
                }
                case 4: {
                    if (this.sprite.getEvent() != 1) break;
                    this.targetBlob.jellify();
                    this.targetBlob = null;
                    this.remove();
                    try {
                        StrobeEffect.spawn(BubbleFeature.this.mutateStrobeResource);
                        Gidrah jelly = (Gidrah)BubbleFeature.this.spawnGidrahFeature.spawn();
                        if (jelly == null) break;
                        jelly.getPosition().set((ReadableVector3i)this.position);
                        jelly.hatch();
                        Game.allocateSound(BubbleFeature.this.laughterSoundEffectResource, this.position, null, jelly);
                    }
                    catch (Exception e) {
                        Game.handleException(e);
                    }
                    break;
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    break;
                }
            }
            if (this.sprite != null) {
                this.sprite.setLocation(FPMath.intValue((int)this.position.getX()), FPMath.intValue((int)this.position.getY()), 0);
                this.shadowSprite.setLocation(FPMath.intValue((int)this.position.getX()), FPMath.intValue((int)this.position.getY()), 0);
            }
        }

        protected void initSprite() {
            this.sprite.setAnimation(BubbleFeature.this.wobbleAnimationResource);
            this.shadowSprite.setAnimation(BubbleFeature.this.wobbleShadowAnimationResource);
            this.shadowSprite.setScale(FPMath.TWO);
        }

        protected void onDeath() {
            super.onDeath();
            if (this.targetBlob != null) {
                switch (this.phase) {
                    case 3: 
                    case 4: {
                        this.targetBlob.rescue();
                        break;
                    }
                    case 2: {
                        this.targetBlob.release();
                    }
                }
                this.targetBlob = null;
            }
        }

        private boolean canCapture() {
            return this.phase == 1 || this.phase == 0;
        }

        public void inCollisionWithBlob(Blob blob) {
            if (!this.canCapture()) {
                return;
            }
            if (blob.capture()) {
                this.targetBlob = blob;
                this.setPhase(2);
            }
        }

        protected void doResIn() {
            this.targetBlob = BlobFeature.getRandomBlob();
            Vector3i pos = this.targetBlob == null ? Game.getPlayer().getLastKnownPosition() : this.targetBlob.getPosition();
            this.randomLocation(pos, this.getResInDistance(), this.position);
        }

        private float getResInDistance() {
            int level = Game.getCurrentLevel();
            if (level < Game.getGameMode().getDifficultyLevel()) {
                return BubbleFeature.this.resInDistance;
            }
            return Math.max(BubbleFeature.this.resInDistance / 2.0f, BubbleFeature.this.resInDistance - (float)(level - Game.getGameMode().getDifficultyLevel()) * BubbleFeature.this.difficultyFactor);
        }

        private int getMutationTime() {
            int level = Game.getCurrentLevel();
            if (level + Game.getGameMode().getDifficultyOffset() == 0) {
                return BubbleFeature.this.mutationTime << 1;
            }
            if (level < Game.getGameMode().getDifficultyLevel()) {
                return BubbleFeature.this.mutationTime;
            }
            return Math.max(240, BubbleFeature.this.mutationTime - BubbleFeature.this.mutationDifficultyFactor * (level - Game.getGameMode().getDifficultyLevel()));
        }

        public float getRadarBlip(Color color, Vector3i pos) {
            if (this.phase == 2 || this.phase == 3) {
                ++this.blipTick;
                if ((this.blipTick & 4) == 0) {
                    color.set((byte)-1, (byte)-1, (byte)-1);
                } else {
                    color.set((byte)0, (byte)-1, (byte)0);
                }
            } else {
                color.set((byte)-1, (byte)0, (byte)0);
            }
            pos.set((ReadableVector3i)this.position);
            return 1.0f;
        }
    }
}

