/*
 * Decompiled with CFR 0.152.
 */
package xap.features.full;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.openal.ALBuffer;
import com.shavenpuppy.jglib.sprites.Animation;
import com.shavenpuppy.jglib.sprites.Sprite;
import com.shavenpuppy.jglib.util.FPMath;
import com.shavenpuppy.jglib.util.XMLUtil;
import com.shavenpuppy.jglib.vector.ReadableVector3i;
import com.shavenpuppy.jglib.vector.Vector3i;
import java.util.Arrays;
import org.lwjgl.util.Color;
import org.w3c.dom.Element;
import xap.Bullet;
import xap.Entity;
import xap.Game;
import xap.Living;
import xap.Nuke;
import xap.Player;
import xap.SmartBomb;
import xap.features.EmitterFeature;
import xap.features.EntityFeature;

public class MineFeature
extends EntityFeature {
    public static final long serialVersionUID = 1L;
    private static final int CELLSIZE = 16;
    private static final int CELLS_ACROSS = 64;
    private String animation;
    private String shadowAnimation;
    private String soundEffect;
    private String emitter;
    private transient Animation animationResource;
    private transient Animation shadowAnimationResource;
    private transient ALBuffer soundEffectResource;
    private transient EmitterFeature emitterFeature;
    private transient boolean[] cellUsed;

    public MineFeature(String name) {
        super(name);
    }

    protected EntityFeature.EntityInstance doSpawn() {
        return new MineInstance();
    }

    protected void doCreate() throws Exception {
        super.doCreate();
        this.animationResource = (Animation)Resources.get((String)this.animation);
        this.shadowAnimationResource = (Animation)Resources.get((String)this.shadowAnimation);
        this.emitterFeature = (EmitterFeature)Resources.get((String)this.emitter);
        if (Game.hasSound()) {
            this.soundEffectResource = (ALBuffer)Resources.get((String)this.soundEffect);
        }
        this.cellUsed = new boolean[4096];
    }

    protected void doDestroy() {
        super.doDestroy();
        this.animationResource = null;
        this.shadowAnimation = null;
        this.emitterFeature = null;
        this.soundEffectResource = null;
    }

    public void onNewLevel() throws Exception {
        super.onNewLevel();
        if (this.cellUsed != null) {
            Arrays.fill(this.cellUsed, false);
        }
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        super.load(element, loader);
        this.animation = XMLUtil.getString((Element)element, (String)"animation");
        this.shadowAnimation = XMLUtil.getString((Element)element, (String)"shadowanimation");
        this.emitter = XMLUtil.getString((Element)element, (String)"emitter");
        this.soundEffect = XMLUtil.getString((Element)element, (String)"soundeffect");
    }

    private class MineInstance
    extends EntityFeature.EntityInstance
    implements Bullet {
        private Sprite sprite;
        private Sprite shadowSprite;
        private int cellIndex = -1;

        MineInstance() {
        }

        public void fireAt(Living from, Vector3i target, int accuracy) {
            int cellX = FPMath.intValue((int)from.getPosition().getX()) / 16;
            int cellY = FPMath.intValue((int)from.getPosition().getY()) / 16;
            this.cellIndex = cellX + cellY * 64;
            if (cellX < 0 || cellX >= 64 || cellY < 0 || cellY >= 64) {
                this.cellIndex = -1;
                this.remove();
                return;
            }
            if (MineFeature.this.cellUsed[this.cellIndex]) {
                this.cellIndex = -1;
                this.remove();
                return;
            }
            ((MineFeature)MineFeature.this).cellUsed[this.cellIndex] = true;
            this.position.set((ReadableVector3i)from.getPosition());
            this.sprite = Game.allocateSprite(this);
            this.shadowSprite = Game.allocateSprite(this);
            this.sprite.setAnimation(MineFeature.this.animationResource);
            this.sprite.setLayer(-1);
            this.shadowSprite.setLayer(-2);
            this.shadowSprite.setAnimation(MineFeature.this.shadowAnimationResource);
            this.shadowSprite.setScale(FPMath.TWO);
            this.sprite.setLocation(FPMath.intValue((int)this.position.getX()), FPMath.intValue((int)this.position.getY()), 0);
            this.shadowSprite.setLocation(FPMath.intValue((int)this.position.getX()), FPMath.intValue((int)this.position.getY()), 0);
            Game.allocateSound(MineFeature.this.soundEffectResource, this.position, null, this);
        }

        public void inCollisionWith(Entity dest) {
            dest.inCollisionWithBullet(this);
        }

        public void inCollisionWithPlayer(Player player) {
            this.explode();
        }

        public void inCollisionWithSmartBomb(SmartBomb smartBomb) {
            this.explode();
        }

        public void inCollisionWithNuke(Nuke nuke) {
            this.explode();
        }

        public boolean canCollide() {
            return true;
        }

        protected void doRemove() {
            if (this.sprite != null) {
                this.sprite.deallocate();
                this.sprite = null;
            }
            if (this.shadowSprite != null) {
                this.shadowSprite.deallocate();
                this.shadowSprite = null;
            }
            if (this.cellIndex != -1) {
                ((MineFeature)MineFeature.this).cellUsed[this.cellIndex] = false;
            }
        }

        public void spawn() {
        }

        protected void tick() {
            if (this.sprite.getEvent() == 1) {
                this.explode();
            }
        }

        private void explode() {
            this.remove();
            MineFeature.this.emitterFeature.spawn(this.position.getX(), this.position.getY(), 0, 0, 0, 0);
        }

        public float getRadarBlip(Color color, Vector3i pos) {
            return 0.0f;
        }
    }
}

