/*
 * Decompiled with CFR 0.152.
 */
package xap.features;

import com.shavenpuppy.jglib.Memory;
import com.shavenpuppy.jglib.interpolators.LinearInterpolator;
import com.shavenpuppy.jglib.opengl.nvidia.AGPMemory;
import com.shavenpuppy.jglib.opengl.nvidia.GLFence;
import com.shavenpuppy.jglib.util.FPMath;
import com.shavenpuppy.jglib.vector.Vector3i;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.ARBPointParameters;
import org.lwjgl.opengl.EXTPointParameters;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.util.Color;
import xap.Game;
import xap.Radar;
import xap.features.EntityFeature;
import xap.features.GameModeFeature;
import xap.features.SpecialEffectFeature;

public class RadarFeature
extends SpecialEffectFeature {
    public static final long serialVersionUID = 1L;
    private static RadarFeature feature;
    private static final float RADIUS = 60.0f;
    private static final float RANGE = 1024.0f;
    private static final int MAX_POINTS = 2048;
    private static final int VERTEX_SIZE = 32;
    private static final int VERTEX_SHIFT = 5;
    private static final int FLOAT_VERTEX_SHIFT = 3;
    private static final int COLOR_OFFSET = 12;
    private static FloatBuffer distanceAtten;
    private static final float XPOS = 64.0f;
    private static final float YPOS = 64.0f;
    private transient RadarInstance radar;
    private transient Memory memory;
    private transient FloatBuffer vertexBuffer;
    private transient ByteBuffer colorBuffer;
    private transient int count;
    private transient GLFence fence;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("xap.features.RadarFeature");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        distanceAtten = BufferUtils.createFloatBuffer((int)64);
        distanceAtten.put(new float[]{1.0f, 0.0f, 0.0f});
        distanceAtten.rewind();
    }

    public RadarFeature(String name) {
        super(name);
    }

    protected SpecialEffectFeature.SpecialEffectInstance doSpawn() {
        return new RadarInstance();
    }

    private void setVisible(boolean visible) {
        if (RadarFeature.feature.radar == null && visible) {
            RadarFeature.feature.radar = (RadarInstance)feature.spawn(0, 0, 0, 0, 0, 0, true);
        } else if (RadarFeature.feature.radar != null && !visible) {
            RadarFeature.feature.radar.remove();
            RadarFeature.feature.radar = null;
        }
    }

    public void register() {
        super.register();
        if (!$assertionsDisabled && feature != null) {
            throw new AssertionError();
        }
        feature = this;
        GameModeFeature.addGameEventListener(this);
    }

    public void deregister() {
        super.deregister();
        feature = null;
        GameModeFeature.removeGameEventListener(this);
    }

    protected void doCreate() throws Exception {
        super.doCreate();
        if (this.vertexBuffer == null) {
            this.memory = AGPMemory.allocate((int)65536);
            this.vertexBuffer = this.memory.getBuffer().asFloatBuffer();
            this.colorBuffer = Memory.chop((ByteBuffer)this.memory.getBuffer(), (int)12);
            if (GLContext.GL_NV_vertex_array_range || GLContext.GL_NV_vertex_array_range2) {
                this.fence = new GLFence();
                this.fence.create();
            }
        }
    }

    protected void doDestroy() {
        super.doDestroy();
        if (this.memory != null && this.memory.isCreated()) {
            this.memory.destroy();
        }
        this.vertexBuffer = null;
        this.colorBuffer = null;
        this.memory = null;
        this.fence = null;
    }

    public void onNewLevel() throws Exception {
        super.onNewLevel();
        if (!this.isCreated()) {
            this.create();
        }
        this.setVisible(true);
    }

    public void onIntermission() throws Exception {
        super.onIntermission();
        this.setVisible(false);
    }

    public void onEndGame() throws Exception {
        super.onEndGame();
        this.setVisible(false);
    }

    private class RadarInstance
    extends SpecialEffectFeature.SpecialEffectInstance
    implements Radar {
        public RadarInstance() {
            super(RadarFeature.this);
        }

        protected void doTick() {
        }

        public boolean isVisible() {
            return true;
        }

        protected void doRemove() {
            super.doRemove();
            RadarFeature.this.radar = null;
        }

        public void render() {
            GL11.glPushMatrix();
            try {
                GL11.glTranslatef((float)64.0f, (float)64.0f, (float)0.0f);
                GL11.glColor4ub((byte)-17, (byte)-1, (byte)0, (byte)-70);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)1);
                GL11.glLineWidth((float)3.0f);
                GL11.glBegin((int)2);
                int i = 0;
                while (i < 32) {
                    GL11.glVertex2f((float)((float)Math.cos((double)i * Math.PI / 16.0) * 60.0f), (float)((float)Math.sin((double)i * Math.PI / 16.0) * 60.0f));
                    ++i;
                }
                GL11.glEnd();
                GL11.glLineWidth((float)1.0f);
                GL11.glBegin((int)6);
                GL11.glColor4ub((byte)-17, (byte)-1, (byte)0, (byte)0);
                GL11.glVertex2f((float)0.0f, (float)0.0f);
                int angle = 128 - this.getTick();
                int i2 = 0;
                while (i2 < 16) {
                    GL11.glColor4ub((byte)-17, (byte)-1, (byte)64, (byte)((byte)LinearInterpolator.instance.interpolate(0.0f, 186.0f, (float)i2 / 15.0f)));
                    GL11.glVertex2f((float)((float)Math.cos((double)angle * Math.PI / 64.0) * 60.0f), (float)((float)Math.sin((double)angle * Math.PI / 64.0) * 60.0f));
                    --angle;
                    ++i2;
                }
                GL11.glEnd();
                if (RadarFeature.this.fence != null) {
                    RadarFeature.this.fence.finish();
                }
                RadarFeature.this.count = 0;
                RadarFeature.this.vertexBuffer.clear();
                RadarFeature.this.colorBuffer.clear();
                EntityFeature.updateRadar(this);
                RadarFeature.this.vertexBuffer.flip();
                RadarFeature.this.colorBuffer.flip();
                if (RadarFeature.this.count == 0) {
                    GL11.glPopMatrix();
                    return;
                }
                GL11.glEnableClientState((int)32884);
                GL11.glEnableClientState((int)32886);
                if (GLContext.GL_ARB_point_parameters) {
                    ARBPointParameters.glPointParameterfARB((int)33062, (float)1.0f);
                    ARBPointParameters.glPointParameterfARB((int)33063, (float)200.0f);
                    ARBPointParameters.glPointParameterARB((int)33065, (FloatBuffer)distanceAtten);
                    GL11.glPointSize((float)6.0f);
                } else if (GLContext.GL_EXT_point_parameters) {
                    EXTPointParameters.glPointParameterfEXT((int)33062, (float)1.0f);
                    EXTPointParameters.glPointParameterfEXT((int)33063, (float)200.0f);
                    EXTPointParameters.glPointParameterEXT((int)33065, (FloatBuffer)distanceAtten);
                    GL11.glPointSize((float)6.0f);
                } else {
                    GL11.glPointSize((float)6.0f);
                }
                GL11.glEnable((int)2832);
                GL11.glHint((int)3153, (int)4354);
                GL11.glEnable((int)3042);
                GL11.glVertexPointer((int)3, (int)32, (FloatBuffer)RadarFeature.this.vertexBuffer);
                GL11.glColorPointer((int)4, (boolean)true, (int)32, (ByteBuffer)RadarFeature.this.colorBuffer);
                if (GLContext.GL_NV_vertex_array_range2) {
                    GL11.glEnableClientState((int)34099);
                } else if (GLContext.GL_NV_vertex_array_range) {
                    GL11.glEnableClientState((int)34077);
                }
                GL11.glDrawArrays((int)0, (int)0, (int)RadarFeature.this.count);
                if (RadarFeature.this.fence != null) {
                    RadarFeature.this.fence.set(34034);
                }
                if (GLContext.GL_NV_vertex_array_range2) {
                    GL11.glDisableClientState((int)34099);
                } else if (GLContext.GL_NV_vertex_array_range) {
                    GL11.glDisableClientState((int)34077);
                }
                GL11.glDisableClientState((int)32886);
                GL11.glDisableClientState((int)32884);
                GL11.glDisable((int)3042);
            }
            finally {
                GL11.glPopMatrix();
            }
        }

        public void addBlip(float size, Color color, Vector3i pos) {
            float ypos;
            float xpos = 60.0f * FPMath.floatValue((int)(pos.getX() - Game.getPlayer().getPosition().getX())) / 1024.0f;
            if (xpos * xpos + (ypos = 60.0f * FPMath.floatValue((int)(pos.getY() - Game.getPlayer().getPosition().getY())) / 1024.0f) * ypos > 3600.0f) {
                return;
            }
            RadarFeature.this.vertexBuffer.position(RadarFeature.this.count << 3);
            RadarFeature.this.vertexBuffer.put(xpos);
            RadarFeature.this.vertexBuffer.put(ypos);
            RadarFeature.this.colorBuffer.position(RadarFeature.this.count << 5);
            color.writeRGB(RadarFeature.this.colorBuffer);
            RadarFeature.this.colorBuffer.put((byte)-32);
            RadarFeature radarFeature = RadarFeature.this;
            radarFeature.count = radarFeature.count + 1;
        }
    }
}

