/*
 * Decompiled with CFR 0.152.
 */
package xap.features;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.util.FPMath;
import com.shavenpuppy.jglib.util.XMLUtil;
import com.shavenpuppy.jglib.vector.ReadableVector3i;
import com.shavenpuppy.jglib.vector.Vector3i;
import com.shavenpuppy.jglib.vector.WritableVector3i;
import java.util.ArrayList;
import java.util.HashMap;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import xap.Emitter;
import xap.Feature;
import xap.Game;
import xap.Particle;
import xap.features.GameModeFeature;

public abstract class EmitterFeature
extends Feature {
    public static final long serialVersionUID = 1L;
    private static final int MAX_EMITTERS = 1024;
    private static final ArrayList emitters = new ArrayList(1024);
    private static final HashMap chainMap = new HashMap();
    private int duration;
    private int delay;
    private ArrayList chain;
    private int offsetX;
    private int offsetY;
    private int offsetZ;

    static {
        if (Game.isRunning()) {
            GameModeFeature.addGameEventListener(new Feature(){

                public void onEndGame() throws Exception {
                    super.onEndGame();
                    int i = emitters.size();
                    while (--i >= 0) {
                        ((EmitterInstance)emitters.get(i)).remove();
                    }
                }
            });
        }
    }

    public EmitterFeature() {
    }

    public EmitterFeature(String name) {
        super(name);
    }

    public final Emitter spawn(int x, int y, int z, int vx, int vy, int vz) {
        EmitterInstance ret = this.doSpawn();
        ret.position.set(x + this.offsetX, y + this.offsetY, z + this.offsetZ);
        ret.velocity.set(vx, vy, vz);
        ret.index = EmitterFeature.emitters.size();
        emitters.add(ret);
        return ret;
    }

    public final Emitter spawnChild(Particle parent) {
        EmitterInstance ret = this.doSpawn();
        Vector3i pos = parent.getPosition();
        ret.position.set(pos.getX() + this.offsetX, pos.getY() + this.offsetY, pos.getZ() + this.offsetZ);
        Vector3i vel = parent.getVelocity();
        ret.velocity.set(vel.getX(), vel.getY(), vel.getZ());
        ret.index = EmitterFeature.emitters.size();
        emitters.add(ret);
        return ret;
    }

    protected abstract EmitterInstance doSpawn();

    public static void tickAllEmitters() {
        int i = 0;
        while (i < emitters.size()) {
            EmitterInstance emitter = (EmitterInstance)emitters.get(i);
            if (emitter.isActive()) {
                emitter.tick();
            }
            if (emitter.index == -1) continue;
            ++i;
        }
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        super.load(element, loader);
        this.delay = XMLUtil.getInt((Element)element, (String)"delay", (int)0);
        this.duration = XMLUtil.getInt((Element)element, (String)"duration") + this.delay;
        this.offsetX = FPMath.fpValue((float)XMLUtil.getFloat((Element)element, (String)"offsetx", (float)0.0f));
        this.offsetY = FPMath.fpValue((float)XMLUtil.getFloat((Element)element, (String)"offsety", (float)0.0f));
        this.offsetZ = FPMath.fpValue((float)XMLUtil.getFloat((Element)element, (String)"offsetz", (float)0.0f));
        this.chain = new ArrayList();
        NodeList childNodes = element.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            if (childNodes.item(i) instanceof Element) {
                Element childNode = (Element)childNodes.item(i);
                EmitterFeature child = (EmitterFeature)loader.load(childNode);
                this.chain.add(child);
            }
            ++i;
        }
    }

    protected void doCreate() throws Exception {
        super.doCreate();
        int i = 0;
        while (i < this.chain.size()) {
            ((EmitterFeature)this.chain.get(i)).create();
            ++i;
        }
    }

    protected void doDestroy() {
        super.doDestroy();
        int i = 0;
        while (i < this.chain.size()) {
            ((EmitterFeature)this.chain.get(i)).destroy();
            ++i;
        }
    }

    public final int getDuration() {
        return this.duration;
    }

    protected abstract class EmitterInstance
    implements Emitter {
        protected final Vector3i position = new Vector3i();
        protected final Vector3i velocity = new Vector3i();
        private boolean active = true;
        private boolean spawned = false;
        private int tick = -1;
        private int index;
        private final ArrayList childEmitterInstance;

        protected EmitterInstance() {
            this.childEmitterInstance = new ArrayList(EmitterFeature.this.chain.size());
        }

        public final Vector3i getPosition() {
            return this.position;
        }

        public final Vector3i getVelocity() {
            return this.velocity;
        }

        public final Vector3i getPosition(Vector3i dest) {
            if (dest == null) {
                dest = new Vector3i(this.position.getX() + EmitterFeature.this.offsetX, this.position.getY() + EmitterFeature.this.offsetY, this.position.getZ() + EmitterFeature.this.offsetZ);
            } else {
                dest.set(this.position.getX() + EmitterFeature.this.offsetX, this.position.getY() + EmitterFeature.this.offsetY, this.position.getZ() + EmitterFeature.this.offsetZ);
            }
            return dest;
        }

        public Vector3i getVelocity(Vector3i dest) {
            if (dest == null) {
                dest = new Vector3i((ReadableVector3i)this.velocity);
            } else {
                dest.set((ReadableVector3i)this.velocity);
            }
            return dest;
        }

        public final void setPosition(int x, int y, int z) {
            this.position.set(x + EmitterFeature.this.offsetX, y + EmitterFeature.this.offsetY, z + EmitterFeature.this.offsetZ);
            int n = this.childEmitterInstance.size();
            int i = 0;
            while (i < n) {
                Emitter e = (Emitter)this.childEmitterInstance.get(i);
                e.setPosition(this.position.getX(), this.position.getY(), this.position.getZ());
                ++i;
            }
        }

        public final void setVelocity(int x, int y, int z) {
            this.velocity.set(x, y, z);
        }

        public final int getDuration() {
            return EmitterFeature.this.duration;
        }

        public final int getTick() {
            return this.tick;
        }

        public final int getDelay() {
            return EmitterFeature.this.delay;
        }

        public final boolean isActive() {
            return this.active;
        }

        public final void remove() {
            if (this.index == -1) {
                return;
            }
            int n = emitters.size() - 1;
            if (this.index != n) {
                EmitterInstance replacement = (EmitterInstance)emitters.get(n);
                emitters.set(this.index, replacement);
                replacement.index = this.index;
            }
            this.index = -1;
            emitters.remove(n);
            this.setActive(false);
            this.doRemove();
            this.childEmitterInstance.clear();
        }

        protected final void spawn() {
            this.spawned = true;
            int i = 0;
            while (i < EmitterFeature.this.chain.size()) {
                EmitterFeature child = (EmitterFeature)EmitterFeature.this.chain.get(i);
                Emitter childInstance = child.spawn(this.position.getX() + EmitterFeature.this.offsetX, this.position.getY() + EmitterFeature.this.offsetY, this.position.getZ() + EmitterFeature.this.offsetZ, this.velocity.getX(), this.velocity.getY(), this.velocity.getZ());
                this.childEmitterInstance.add(childInstance);
                ++i;
            }
            this.doSpawn();
        }

        protected abstract void doSpawn();

        protected void doRemove() {
        }

        public final void setActive(boolean active) {
            this.active = active;
        }

        public final void tick() {
            this.tick += Game.getOptions().getTicksPerFrame();
            if (EmitterFeature.this.duration > 0 && this.tick > EmitterFeature.this.duration && this.spawned) {
                this.remove();
            } else if (this.tick >= EmitterFeature.this.delay) {
                if (!this.spawned) {
                    this.spawn();
                }
                this.doTick();
                Vector3i.add((ReadableVector3i)this.position, (ReadableVector3i)this.velocity, (WritableVector3i)this.position);
            }
        }

        protected abstract void doTick();
    }
}

