/*
 * Decompiled with CFR 0.152.
 */
package xap.features;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.openal.ALBuffer;
import com.shavenpuppy.jglib.sprites.Sprite;
import com.shavenpuppy.jglib.sprites.SpriteImage;
import com.shavenpuppy.jglib.util.FPMath;
import com.shavenpuppy.jglib.util.Util;
import com.shavenpuppy.jglib.util.XMLUtil;
import com.shavenpuppy.jglib.vector.ReadableVector3i;
import com.shavenpuppy.jglib.vector.Vector3i;
import com.shavenpuppy.jglib.vector.WritableVector3i;
import org.lwjgl.util.Color;
import org.w3c.dom.Element;
import xap.Bullet;
import xap.Emitter;
import xap.Entity;
import xap.Game;
import xap.Living;
import xap.Nuke;
import xap.Player;
import xap.SmartBomb;
import xap.features.EmitterFeature;
import xap.features.EntityFeature;

public class BulletFeature
extends EntityFeature {
    public static final long serialVersionUID = 1L;
    private static final Vector3i target;
    private int maxBullets;
    private int speed;
    private int range;
    private String soundEffect;
    private String emitter;
    private transient BulletInstance[] bullet;
    private transient int numBullets;
    private transient SpriteImage spriteImage;
    private transient SpriteImage spriteImage2;
    private transient ALBuffer soundEffectResource;
    private transient EmitterFeature emitterFeature;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("xap.features.BulletFeature");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        target = new Vector3i();
    }

    public BulletFeature(String name) {
        super(name);
    }

    protected EntityFeature.EntityInstance doSpawn() {
        if (this.numBullets == this.maxBullets) {
            return null;
        }
        return this.bullet[this.numBullets++];
    }

    private void returnBulletToPool(BulletInstance b) {
        if (!$assertionsDisabled && this.numBullets <= 0) {
            throw new AssertionError();
        }
        this.bullet[((BulletInstance)b).index] = this.bullet[this.numBullets - 1];
        this.bullet[b.index].index = b.index;
        this.bullet[this.numBullets - 1] = b;
        b.index = --this.numBullets;
    }

    protected void doCreate() throws Exception {
        super.doCreate();
        this.spriteImage = new SpriteImage("spotlight.8.texture", "glowing.style", 4, 4);
        this.spriteImage2 = new SpriteImage("spotlight.32.texture", "glowing.style", 16, 16);
        if (Game.hasSound()) {
            this.soundEffectResource = (ALBuffer)Resources.get((String)this.soundEffect);
        }
        this.emitterFeature = (EmitterFeature)Resources.get((String)this.emitter);
        this.bullet = new BulletInstance[this.maxBullets];
        int i = 0;
        while (i < this.maxBullets) {
            this.bullet[i] = new BulletInstance();
            this.bullet[i].index = i;
            ++i;
        }
    }

    protected void doDestroy() {
        super.doDestroy();
        this.spriteImage = null;
        this.spriteImage2 = null;
        this.soundEffectResource = null;
        this.emitterFeature = null;
        this.bullet = null;
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        super.load(element, loader);
        this.maxBullets = XMLUtil.getInt((Element)element, (String)"maxbullets");
        this.speed = FPMath.fpValue((float)XMLUtil.getFloat((Element)element, (String)"speed"));
        this.range = XMLUtil.getInt((Element)element, (String)"range");
        this.soundEffect = XMLUtil.getString((Element)element, (String)"soundeffect");
        this.emitter = XMLUtil.getString((Element)element, (String)"emitter");
    }

    private final class BulletInstance
    extends EntityFeature.EntityInstance
    implements Bullet,
    Bullet.Collider {
        private int index;
        private int tick;
        private Sprite sprite;
        private Sprite sprite2;
        private boolean active;
        private Emitter emitter;

        BulletInstance() {
            super(BulletFeature.this);
            this.sprite = Game.allocateSprite(this);
            this.sprite.setActive(false);
            this.sprite.setImage(BulletFeature.this.spriteImage);
            this.sprite2 = Game.allocateSprite(this);
            this.sprite2.setActive(false);
            this.sprite2.setImage(BulletFeature.this.spriteImage2);
            this.sprite2.setColors(0, 0, 255, 128);
            this.sprite2.setLayer(-1);
        }

        public void spawn() {
            this.active = true;
        }

        public void inCollisionWith(Entity dest) {
            dest.inCollisionWithBullet(this);
        }

        public void inCollisionWithPlayer(Player player) {
            Game.getGameMode().handleCollision(this, player);
        }

        public void inCollisionWithSmartBomb(SmartBomb smartBomb) {
            this.remove();
        }

        public void inCollisionWithNuke(Nuke nuke) {
            this.remove();
        }

        public boolean canCollide() {
            return this.active;
        }

        public void tick() {
            --this.tick;
            if (this.tick <= 0) {
                this.remove();
                return;
            }
            Vector3i.add((ReadableVector3i)this.position, (ReadableVector3i)this.velocity, (WritableVector3i)this.position);
            this.sprite.setLocation(FPMath.intValue((int)this.position.getX()), FPMath.intValue((int)this.position.getY()), FPMath.intValue((int)this.position.getZ()));
            this.sprite.setScale(FPMath.fpValue((double)(Math.random() + 1.0)));
            this.sprite2.setLocation(this.sprite.getX(), this.sprite.getY(), this.sprite.getZ());
            this.emitter.setPosition(this.position.getX(), this.position.getY(), 0);
        }

        protected void doRemove() {
            this.sprite.setActive(false);
            this.sprite2.setActive(false);
            this.active = false;
            this.emitter.remove();
            this.emitter = null;
            BulletFeature.this.returnBulletToPool(this);
        }

        public void fireAt(Living from, Vector3i to, int accuracy) {
            from.getPosition(this.position);
            target.set((ReadableVector3i)to);
            int aim = Util.random((int)0, (int)100);
            if (aim > accuracy) {
                double angle = Math.random() * Math.PI * 2.0;
                target.translate(FPMath.fpValue((double)(Math.cos(angle) * (double)(aim - accuracy) * 4.0)), FPMath.fpValue((double)(Math.sin(angle) * (double)(aim - accuracy) * 4.0)), 0);
            }
            Vector3i.sub((ReadableVector3i)target, (ReadableVector3i)this.position, (WritableVector3i)this.velocity);
            this.velocity.normalize();
            this.velocity.scale((BulletFeature.this.speed << Game.getOptions().getSpeedShift()) + from.getVelocity().length());
            this.tick = BulletFeature.this.range;
            Game.allocateSound(BulletFeature.this.soundEffectResource, this.position, this.velocity, this);
            this.sprite.setLocation(this.position.getX(), this.position.getY(), 0);
            this.sprite2.setLocation(this.position.getX(), this.position.getY(), 0);
            this.sprite.setActive(true);
            this.sprite2.setActive(true);
            this.emitter = BulletFeature.this.emitterFeature.spawn(this.position.getX(), this.position.getY(), 0, 0, 0, 0);
        }

        public float getRadarBlip(Color color, Vector3i pos) {
            return 0.0f;
        }
    }
}

