/*
 * Decompiled with CFR 0.152.
 */
package xap.features;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.opengl.GLRenderable;
import com.shavenpuppy.jglib.sprites.Sprite;
import com.shavenpuppy.jglib.sprites.StaticSpriteEngine;
import com.shavenpuppy.jglib.util.XMLUtil;
import org.w3c.dom.Element;
import xap.BattleZone;
import xap.Feature;
import xap.Game;
import xap.GameEventListener;
import xap.Ticked;
import xap.Ticker;
import xap.features.EmitterFeature;
import xap.features.EntityFeature;
import xap.features.GameModeFeature;
import xap.features.ParticleFeature;
import xap.features.SpecialEffectFeature;
import xap.particles.PointParticleFeature;

public class BattleZoneFeature
extends Feature
implements Ticked {
    public static final long serialVersionUID = 1L;
    private static BattleZoneFeature feature;
    private int maxSprites = 8192;
    private transient BattleZoneInstance instance;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("xap.features.BattleZoneFeature");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public BattleZoneFeature() {
    }

    public BattleZoneFeature(String name) {
        super(name);
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        super.load(element, loader);
        this.maxSprites = XMLUtil.getInt((Element)element, (String)"maxsprites");
    }

    public void register() {
        super.register();
        if (!$assertionsDisabled && feature != null) {
            throw new AssertionError();
        }
        feature = this;
        if (Game.isRunning()) {
            Ticker.register(this);
            GameModeFeature.addGameEventListener(this);
        }
    }

    public void deregister() {
        super.deregister();
        feature = null;
        if (Game.isRunning()) {
            Ticker.deregister(this);
            GameModeFeature.removeGameEventListener(this);
            if (this.instance != null) {
                this.instance.destroy();
                this.instance = null;
            }
        }
    }

    public static BattleZone spawn() throws Exception {
        return feature.doSpawn();
    }

    private BattleZoneInstance doSpawn() throws Exception {
        if (this.instance != null) {
            this.instance.destroy();
            this.instance = null;
        }
        this.instance = new BattleZoneInstance();
        return this.instance;
    }

    public boolean tick() {
        if (this.instance != null) {
            return this.instance.tick();
        }
        return false;
    }

    public void onEndGame() throws Exception {
        super.onEndGame();
        this.instance.onEndGame();
    }

    public void onNewGame() throws Exception {
        super.onNewGame();
        this.instance.onNewGame();
    }

    public void onPlayerDeath() throws Exception {
        super.onPlayerDeath();
        this.instance.onPlayerDeath();
    }

    public void onPlayerSpawn() throws Exception {
        super.onPlayerSpawn();
        this.instance.onPlayerSpawn();
    }

    private class BattleZoneInstance
    implements BattleZone,
    GameEventListener {
        private final StaticSpriteEngine spriteEngine;
        private boolean backgroundVisible;

        public BattleZoneInstance() throws Exception {
            this.spriteEngine = new StaticSpriteEngine(false, BattleZoneFeature.this.maxSprites, Game.getOptions().getTicksPerFrame());
            this.spriteEngine.create();
        }

        private void destroy() {
            this.spriteEngine.destroy();
        }

        public boolean tick() {
            this.spriteEngine.setTickRate(Game.getOptions().getTicksPerFrame());
            this.spriteEngine.tick();
            EntityFeature.tickAllEntities();
            EmitterFeature.tickAllEmitters();
            ParticleFeature.tickAllParticles();
            return true;
        }

        public void render() {
            Game.getFrustum().extract();
            GLRenderable background = Game.getGameMode().getCurrentBackground();
            if (background != null) {
                background.render();
            }
            this.spriteEngine.render();
            EntityFeature.renderEntities();
            SpecialEffectFeature.renderBackgroundEffects();
            PointParticleFeature.renderPointParticles();
        }

        public void setBackgroundVisible(boolean visibility) {
            if (this.backgroundVisible != visibility) {
                this.backgroundVisible = visibility;
            }
        }

        public Sprite allocateSprite(Object owner) {
            return this.spriteEngine.allocate(owner);
        }

        public void beginNewGame() {
        }

        public void beginNewLevel() {
        }

        public void endLevel() {
        }

        public void gameOver() {
        }

        public void endGame() {
        }

        public void onEndGame() throws Exception {
        }

        public void onEndLevel() throws Exception {
        }

        public void onGameOver() throws Exception {
        }

        public void onIntermission() throws Exception {
        }

        public void onLastBlobDeath() throws Exception {
        }

        public void onNewGame() throws Exception {
        }

        public void onNewLevel() throws Exception {
        }

        public void onPlayerDeath() throws Exception {
        }

        public void onPlayerSpawn() throws Exception {
        }
    }
}

