/*
 * Decompiled with CFR 0.152.
 */
package xap.eolgs.full;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.interpolators.LinearInterpolator;
import com.shavenpuppy.jglib.openal.ALBuffer;
import com.shavenpuppy.jglib.opengl.GLFont;
import com.shavenpuppy.jglib.resources.ColorSequenceResource;
import com.shavenpuppy.jglib.sprites.Animation;
import com.shavenpuppy.jglib.sprites.Sprite;
import com.shavenpuppy.jglib.sprites.SpriteImage;
import com.shavenpuppy.jglib.util.FPMath;
import com.shavenpuppy.jglib.util.Util;
import com.shavenpuppy.jglib.util.XMLUtil;
import com.shavenpuppy.jglib.vector.ReadableVector3i;
import com.shavenpuppy.jglib.vector.Vector3i;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import xap.Bullet;
import xap.Compass;
import xap.Feature;
import xap.FloatingLabel;
import xap.Game;
import xap.Gidrah;
import xap.HomingMovement;
import xap.Living;
import xap.Nuke;
import xap.Player;
import xap.SmartBomb;
import xap.effects.LabelEffect;
import xap.features.EmitterFeature;
import xap.features.EntityFeature;
import xap.features.GidrahFeature;
import xap.resources.HomingMovementResource;

public class EnormousCubeFeature
extends GidrahFeature {
    public static final long serialVersionUID = 1L;
    private static final HashMap mapping = new HashMap();
    private int speed;
    private int duration;
    private String wobbleAnimation;
    private String wobbleShadowAnimation;
    private String spawnGidrah;
    private int maxSpawned;
    private CubeGun[] cubeGun;
    private String crosshair;
    private HomingMovementResource homingMovementResource;
    private String gunExplosionEmitter;
    private String spawnSound;
    private String cubeOpenSound;
    private transient Animation wobbleAnimationResource;
    private transient Animation wobbleShadowAnimationResource;
    private transient GidrahFeature spawnGidrahFeature;
    private transient SpriteImage crosshairResource;
    private transient EmitterFeature gunExplosionEmitterFeature;
    private transient ALBuffer spawnSoundResource;
    private transient ALBuffer cubeOpenSoundResource;
    private static final int THINKING = 0;
    private static final int WOBBLING = 1;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("xap.eolgs.full.EnormousCubeFeature$CubeGun");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        mapping.put("gun", clazz);
    }

    public EnormousCubeFeature(String name) {
        super(name);
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        super.load(element, loader);
        this.spawnGidrah = XMLUtil.getString((Element)element, (String)"spawngidrah");
        this.wobbleAnimation = XMLUtil.getString((Element)element, (String)"wobbleanimation");
        this.wobbleShadowAnimation = XMLUtil.getString((Element)element, (String)"wobbleshadowanimation");
        this.speed = FPMath.fpValue((float)XMLUtil.getFloat((Element)element, (String)"speed"));
        this.duration = XMLUtil.getInt((Element)element, (String)"duration");
        this.maxSpawned = XMLUtil.getInt((Element)element, (String)"maxspawned");
        this.crosshair = XMLUtil.getString((Element)element, (String)"crosshair");
        this.gunExplosionEmitter = XMLUtil.getString((Element)element, (String)"gunexplosionemitter");
        this.spawnSound = XMLUtil.getString((Element)element, (String)"spawnsound");
        this.cubeOpenSound = XMLUtil.getString((Element)element, (String)"cubeopensound");
        this.homingMovementResource = new HomingMovementResource();
        this.homingMovementResource.load(element, loader);
        try {
            ArrayList<Resource> guns = new ArrayList<Resource>(3);
            loader.pushMap((Map)mapping);
            NodeList childTagList = element.getChildNodes();
            boolean gunCount = false;
            int i = 0;
            while (i < childTagList.getLength()) {
                if (childTagList.item(i) instanceof Element) {
                    Element childElement = (Element)childTagList.item(i);
                    guns.add(loader.load(childElement));
                }
                ++i;
            }
            this.cubeGun = new CubeGun[guns.size()];
            guns.toArray(this.cubeGun);
        }
        finally {
            loader.popMap();
        }
    }

    protected EntityFeature.EntityInstance doSpawn() {
        return new EnormousCubeInstance();
    }

    protected void doCreate() throws Exception {
        super.doCreate();
        this.wobbleAnimationResource = (Animation)Resources.get((String)this.wobbleAnimation);
        this.wobbleShadowAnimationResource = (Animation)Resources.get((String)this.wobbleShadowAnimation);
        this.spawnGidrahFeature = (GidrahFeature)Resources.get((String)this.spawnGidrah);
        this.crosshairResource = (SpriteImage)Resources.get((String)this.crosshair);
        this.gunExplosionEmitterFeature = (EmitterFeature)Resources.get((String)this.gunExplosionEmitter);
        if (Game.hasSound()) {
            this.spawnSoundResource = (ALBuffer)Resources.get((String)this.spawnSound);
            this.cubeOpenSoundResource = (ALBuffer)Resources.get((String)this.cubeOpenSound);
        }
        int i = 0;
        while (i < this.cubeGun.length) {
            this.cubeGun[i].create();
            ++i;
        }
    }

    protected void doDestroy() {
        super.doDestroy();
        this.wobbleAnimationResource = null;
        this.wobbleShadowAnimation = null;
        this.spawnGidrahFeature = null;
        this.crosshairResource = null;
        this.gunExplosionEmitterFeature = null;
        this.spawnSoundResource = null;
        this.cubeOpenSoundResource = null;
        int i = 0;
        while (i < this.cubeGun.length) {
            this.cubeGun[i].destroy();
            ++i;
        }
    }

    public static class CubeGun
    extends Feature {
        public static final long serialVersionUID = 1L;
        private int xoffset;
        private int yoffset;
        private int idlexoffset;
        private int idleyoffset;
        private double minAngle;
        private double maxAngle;
        private String[] image;
        private double radius;
        private int hitPoints;
        private transient SpriteImage[] imageResource;

        public void load(Element element, Resource.Loader loader) throws Exception {
            super.load(element, loader);
            this.xoffset = FPMath.fpValue((int)XMLUtil.getInt((Element)element, (String)"xoffset"));
            this.yoffset = FPMath.fpValue((int)XMLUtil.getInt((Element)element, (String)"yoffset"));
            this.idlexoffset = FPMath.fpValue((int)XMLUtil.getInt((Element)element, (String)"idlexoffset"));
            this.idleyoffset = FPMath.fpValue((int)XMLUtil.getInt((Element)element, (String)"idleyoffset"));
            this.radius = XMLUtil.getFloat((Element)element, (String)"radius");
            this.minAngle = XMLUtil.getFloat((Element)element, (String)"minangle");
            this.maxAngle = XMLUtil.getFloat((Element)element, (String)"maxangle");
            this.hitPoints = XMLUtil.getInt((Element)element, (String)"hitpoints");
            NodeList imageNodeList = element.getElementsByTagName("image");
            this.image = new String[imageNodeList.getLength()];
            int i = 0;
            while (i < imageNodeList.getLength()) {
                Element imageNode = (Element)imageNodeList.item(i);
                Text textNode = (Text)imageNode.getFirstChild();
                this.image[i] = textNode.getData();
                ++i;
            }
        }

        protected void doCreate() throws Exception {
            super.doCreate();
            this.imageResource = new SpriteImage[this.image.length];
            int i = 0;
            while (i < this.imageResource.length) {
                this.imageResource[i] = (SpriteImage)Resources.get((String)this.image[i]);
                ++i;
            }
        }

        protected void doDestroy() {
            super.doDestroy();
            this.imageResource = null;
        }

        public Instance spawn(EnormousCubeFeature cubeFeature, EnormousCubeInstance cube) {
            return new Instance(cubeFeature, cube);
        }

        public class Instance
        implements Living {
            private Sprite gunSprite;
            private int wounds;
            private boolean active = true;
            private Sprite crosshairSprite;
            private HomingMovement movement;
            private final EnormousCubeInstance cube;
            private final EnormousCubeFeature cubeFeature;
            private final Vector3i position = new Vector3i();
            private final Vector3i velocity = new Vector3i();
            private int fireInterval;
            private GunPod gunPod = new GunPod();

            Instance(EnormousCubeFeature cubeFeature, EnormousCubeInstance cube) {
                this.cubeFeature = cubeFeature;
                this.cube = cube;
                this.gunSprite = Game.allocateSprite(this);
                this.gunSprite.setAlpha(0);
                this.crosshairSprite = Game.allocateSprite(this);
                this.crosshairSprite.setAlpha(0);
                this.crosshairSprite.setImage(cubeFeature.crosshairResource);
                this.gunSprite.setLayer(1);
                this.movement = cubeFeature.homingMovementResource.spawn(this);
                this.tick();
            }

            void damage(int points, int x, int y) {
                if (!this.active) {
                    return;
                }
                if (!this.pointIsVisible(x, y)) {
                    return;
                }
                this.wounds += points;
                this.gunSprite.setFlash(true);
                if (this.wounds >= CubeGun.this.hitPoints) {
                    this.remove();
                }
            }

            public boolean isAlive() {
                return this.active;
            }

            void remove() {
                this.gunSprite.setActive(false);
                this.crosshairSprite.setActive(false);
                this.active = false;
                this.cubeFeature.gunExplosionEmitterFeature.spawn(FPMath.intValue((int)(this.cube.getPosition().getX() + CubeGun.this.xoffset)), FPMath.intValue((int)(this.cube.getPosition().getY() + CubeGun.this.yoffset)), 0, 0, 0, 0);
            }

            void tick() {
                if (!this.active) {
                    return;
                }
                boolean isPlayerVisible = this.playerIsVisible();
                if (isPlayerVisible) {
                    this.movement.setDestination(Game.getPlayer().getLastKnownPosition().getX(), Game.getPlayer().getLastKnownPosition().getY());
                } else {
                    this.movement.setDestination(this.cube.getPosition().getX() + CubeGun.this.idlexoffset, this.cube.getPosition().getY() + CubeGun.this.idleyoffset);
                }
                this.movement.tick();
                this.crosshairSprite.setLocation(FPMath.intValue((int)this.position.getX()), FPMath.intValue((int)this.position.getY()), 0);
                this.gunPod.setPosition(this.cube.position.getX() + CubeGun.this.xoffset, this.cube.position.getY() + CubeGun.this.yoffset, 0);
                if (this.fireInterval > 0) {
                    this.fireInterval -= Game.getOptions().getTicksPerFrame();
                } else if (isPlayerVisible) {
                    double ddy;
                    int dx = Game.getPlayer().getLastKnownPosition().getX() - this.position.getX();
                    int dy = Game.getPlayer().getLastKnownPosition().getY() - this.position.getY();
                    double ddx = FPMath.doubleValue((long)dx);
                    double dd = Math.sqrt(ddx * ddx + (ddy = FPMath.doubleValue((long)dy)) * ddy);
                    if (dd < CubeGun.this.radius) {
                        Bullet b = (Bullet)this.cubeFeature.bulletFeature.spawn();
                        if (b == null) {
                            return;
                        }
                        b.fireAt(this.gunPod, this.position, 100);
                        this.fireInterval = 30;
                    }
                }
                double angle = this.getAngleToPoint(this.position.getX(), this.position.getY());
                double scale = angle + 360.0 < CubeGun.this.maxAngle ? (angle + 360.0 - CubeGun.this.minAngle) / (CubeGun.this.maxAngle - CubeGun.this.minAngle) : (angle - CubeGun.this.minAngle) / (CubeGun.this.maxAngle - CubeGun.this.minAngle);
                int i = (int)LinearInterpolator.instance.interpolate(0.0f, (float)(CubeGun.this.imageResource.length - 1), (float)scale);
                this.gunSprite.setImage(CubeGun.this.imageResource[i]);
                this.gunSprite.setFlash(false);
                this.gunSprite.setLocation(FPMath.intValue((int)this.cube.getPosition().getX()), FPMath.intValue((int)this.cube.getPosition().getY()), 0);
            }

            boolean playerIsVisible() {
                Player player = Game.getPlayer();
                if (!player.isAlive()) {
                    return false;
                }
                return this.pointIsVisible(player.getLastKnownPosition().getX(), player.getLastKnownPosition().getY());
            }

            double getAngleToPoint(int x, int y) {
                double xd;
                double yd = FPMath.doubleValue((long)(y - (this.cube.getPosition().getY() + CubeGun.this.yoffset)));
                double angle = Math.toDegrees(Math.atan2(yd, xd = FPMath.doubleValue((long)(x - (this.cube.getPosition().getX() + CubeGun.this.xoffset)))));
                if (angle < 0.0) {
                    angle += 360.0;
                }
                return angle;
            }

            boolean pointIsVisible(int x, int y) {
                double angle = this.getAngleToPoint(x, y);
                if (CubeGun.this.maxAngle >= 360.0) {
                    return angle >= CubeGun.this.minAngle && angle <= 360.0 || angle >= 0.0 && angle + 360.0 <= CubeGun.this.maxAngle;
                }
                return angle >= CubeGun.this.minAngle && angle <= CubeGun.this.maxAngle;
            }

            void removeSprites() {
                if (this.gunSprite != null) {
                    this.gunSprite.deallocate();
                    this.gunSprite = null;
                }
                if (this.crosshairSprite != null) {
                    this.crosshairSprite.deallocate();
                    this.crosshairSprite = null;
                }
            }

            void setAlpha(int alpha) {
                this.gunSprite.setAlpha(alpha);
                this.crosshairSprite.setAlpha(alpha);
            }

            public Vector3i getPosition() {
                return this.position;
            }

            public Vector3i getPosition(Vector3i dest) {
                if (dest == null) {
                    dest = new Vector3i((ReadableVector3i)this.position);
                } else {
                    dest.set((ReadableVector3i)this.position);
                }
                return dest;
            }

            public Vector3i getVelocity() {
                return this.velocity;
            }

            public Vector3i getVelocity(Vector3i dest) {
                if (dest == null) {
                    dest = new Vector3i((ReadableVector3i)this.velocity);
                } else {
                    dest.set((ReadableVector3i)this.velocity);
                }
                return dest;
            }

            public void setPosition(int x, int y, int z) {
                this.position.set(x, y, z);
            }

            public void setVelocity(int x, int y, int z) {
                this.velocity.set(x, y, z);
            }

            private class GunPod
            implements Living {
                final Vector3i pos = new Vector3i();
                static final /* synthetic */ boolean $assertionsDisabled;
                static /* synthetic */ Class class$0;

                static {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("xap.eolgs.full.EnormousCubeFeature$CubeGun$Instance$GunPod");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    $assertionsDisabled = !clazz.desiredAssertionStatus();
                }

                GunPod() {
                }

                public Vector3i getPosition() {
                    return this.pos;
                }

                public Vector3i getVelocity() {
                    return null;
                }

                public boolean isAlive() {
                    return Instance.this.active;
                }

                public void setPosition(int x, int y, int z) {
                    this.pos.set(x, y, z);
                }

                public Vector3i getPosition(Vector3i dest) {
                    dest.set((ReadableVector3i)this.pos);
                    return dest;
                }

                public Vector3i getVelocity(Vector3i dest) {
                    return null;
                }

                public void setVelocity(int x, int y, int z) {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                }
            }
        }
    }

    private class EnormousCubeInstance
    extends GidrahFeature.GidrahInstance {
        private Sprite sprite;
        private Sprite shadowSprite;
        private FloatingLabel endOfDemoLabel;
        private int dx;
        private int dy;
        private int moveDuration;
        private int phase;
        private int spawnTick;
        private int numSpawned;
        private CubeGun.Instance[] cubeGunInstance;
        private boolean cubeIsOpen;
        private int damageIndicationTick;
        static final /* synthetic */ boolean $assertionsDisabled;
        static /* synthetic */ Class class$0;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("xap.eolgs.full.EnormousCubeFeature$EnormousCubeInstance");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        EnormousCubeInstance() {
            super(EnormousCubeFeature.this);
        }

        protected void initSprite() {
            this.sprite = Game.allocateSprite(this);
            this.shadowSprite = Game.allocateSprite(this);
            this.shadowSprite.setLayer(-2);
            this.sprite.setLocation(FPMath.intValue((int)this.position.getX()), FPMath.intValue((int)this.position.getY()), 0);
            this.shadowSprite.setLocation(FPMath.intValue((int)this.position.getX()), FPMath.intValue((int)this.position.getY()), 0);
            this.sprite.setAnimation(EnormousCubeFeature.this.wobbleAnimationResource);
            this.shadowSprite.setAnimation(EnormousCubeFeature.this.wobbleShadowAnimationResource);
            this.shadowSprite.setScale(FPMath.TWO);
            this.cubeGunInstance = new CubeGun.Instance[EnormousCubeFeature.this.cubeGun.length];
            int i = 0;
            while (i < EnormousCubeFeature.this.cubeGun.length) {
                this.cubeGunInstance[i] = EnormousCubeFeature.this.cubeGun[i].spawn(EnormousCubeFeature.this, this);
                ++i;
            }
        }

        protected void doGidrahSpawnTick() {
            this.spawnTick += Game.getOptions().getTicksPerFrame();
            int alpha = (int)LinearInterpolator.instance.interpolate(0.0f, 255.0f, (float)this.spawnTick / (float)EnormousCubeFeature.this.beamInEmitterFeature.getDuration());
            this.sprite.setAlpha(alpha);
            this.shadowSprite.setAlpha(alpha);
            int i = 0;
            while (i < this.cubeGunInstance.length) {
                this.cubeGunInstance[i].setAlpha(alpha);
                this.cubeGunInstance[i].tick();
                ++i;
            }
        }

        protected void removeSprites() {
            if (this.sprite != null) {
                this.sprite.deallocate();
                this.sprite = null;
            }
            if (this.shadowSprite != null) {
                this.shadowSprite.deallocate();
                this.shadowSprite = null;
            }
            if (this.cubeGunInstance != null) {
                int i = 0;
                while (i < this.cubeGunInstance.length) {
                    this.cubeGunInstance[i].removeSprites();
                    ++i;
                }
            }
        }

        private void wobbleRandomly() {
            int dir = Util.random((int)0, (int)3);
            boolean destx = false;
            boolean desty = false;
            this.dx = Compass.dx[(dir << 1) + 1];
            this.dy = Compass.dy[(dir << 1) + 1];
            this.moveDuration = EnormousCubeFeature.this.duration >> Game.getOptions().getSpeedShift();
            this.dx *= EnormousCubeFeature.this.speed << Game.getOptions().getSpeedShift();
            this.dy *= EnormousCubeFeature.this.speed << Game.getOptions().getSpeedShift();
            this.phase = 1;
        }

        private void wobbleNastily(int hx, int hy) {
            this.dx = hx < this.position.getX() ? -1 : 1;
            this.dy = hy < this.position.getY() ? -1 : 1;
            this.moveDuration = EnormousCubeFeature.this.duration >> Game.getOptions().getSpeedShift();
            this.dx *= EnormousCubeFeature.this.speed << Game.getOptions().getSpeedShift();
            this.dy *= EnormousCubeFeature.this.speed << Game.getOptions().getSpeedShift();
            this.phase = 1;
        }

        protected void doGidrahTick() {
            if (this.damageIndicationTick > 0) {
                this.damageIndicationTick -= Game.getOptions().getTicksPerFrame();
                if (this.damageIndicationTick <= 0) {
                    this.sprite.setFlash(false);
                }
            }
            switch (this.phase) {
                case 0: {
                    int chosenGun = Util.random((int)0, (int)this.cubeGunInstance.length);
                    if (chosenGun == this.cubeGunInstance.length) {
                        this.wobbleRandomly();
                    } else {
                        int y;
                        int x;
                        if (this.cubeGunInstance[chosenGun].isAlive()) {
                            x = Game.getPlayer().getPosition().getX() - EnormousCubeFeature.this.cubeGun[chosenGun].idlexoffset;
                            y = Game.getPlayer().getPosition().getY() - EnormousCubeFeature.this.cubeGun[chosenGun].idleyoffset;
                        } else {
                            x = Game.getPlayer().getLastKnownPosition().getX();
                            y = Game.getPlayer().getLastKnownPosition().getY();
                        }
                        this.wobbleNastily(x, y);
                    }
                }
                case 1: {
                    switch (this.sprite.getEvent()) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            this.shadowSprite.setSequence(4);
                            this.sprite.setEvent(4);
                            this.cubeIsOpen = true;
                            Game.allocateSound(EnormousCubeFeature.this.cubeOpenSoundResource, this.position, null, this);
                            break;
                        }
                        case 2: {
                            this.sprite.setEvent(4);
                            if (this.numSpawned >= EnormousCubeFeature.this.maxSpawned) break;
                            Gidrah newGidrah = (Gidrah)EnormousCubeFeature.this.spawnGidrahFeature.spawn();
                            newGidrah.setPosition(this.position.getX(), this.position.getY(), 0);
                            newGidrah.hatch();
                            Game.allocateSound(EnormousCubeFeature.this.spawnSoundResource, this.position, null, this);
                            ++this.numSpawned;
                            break;
                        }
                        case 3: {
                            this.cubeIsOpen = false;
                            this.sprite.setEvent(0);
                            break;
                        }
                        case 4: {
                            break;
                        }
                        default: {
                            if (!$assertionsDisabled) {
                                throw new AssertionError();
                            }
                            break;
                        }
                    }
                    this.position.translate(this.dx, this.dy, 0);
                    --this.moveDuration;
                    if (this.moveDuration != 0) break;
                    this.phase = 0;
                    break;
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    break;
                }
            }
            this.sprite.setLocation(FPMath.intValue((int)this.position.getX()), FPMath.intValue((int)this.position.getY()), 0);
            this.shadowSprite.setLocation(FPMath.intValue((int)this.position.getX()), FPMath.intValue((int)this.position.getY()), 0);
            int i = 0;
            while (i < this.cubeGunInstance.length) {
                this.cubeGunInstance[i].tick();
                ++i;
            }
            if (this.endOfDemoLabel != null && !this.endOfDemoLabel.isVisible()) {
                Game.endGame();
                Game.endDemo();
            }
        }

        protected void doResIn() {
            this.position.set(FPMath.fpValue((int)512), FPMath.fpValue((int)512), 0);
            this.initSprite();
        }

        public void inCollisionWithPlayer(Player player) {
        }

        public void inCollisionWithSmartBomb(SmartBomb smartBomb) {
        }

        public void inCollisionWithNuke(Nuke nuke) {
        }

        public void damage(int points, int x, int y) {
            if (this.cubeIsOpen) {
                super.damage(points, x, y);
            } else {
                int i = 0;
                while (i < this.cubeGunInstance.length) {
                    this.cubeGunInstance[i].damage(points, x, y);
                    ++i;
                }
            }
        }

        protected void indicateDamage() {
            this.sprite.setFlash(true);
            this.damageIndicationTick = 4;
        }

        protected void onGidrahBirth() {
            super.onGidrahBirth();
            if (!Game.isRegistered()) {
                try {
                    LabelEffect.spawn(FPMath.fpValue((int)400), FPMath.fpValue((int)318), 0, 0, (GLFont)Resources.get((String)"impact-plain-32.glfont"), (ColorSequenceResource)Resources.get((String)"demo_end.colorseq"), "Oh no! What happens next....?", true);
                    this.endOfDemoLabel = LabelEffect.spawn(FPMath.fpValue((int)400), FPMath.fpValue((int)282), 0, 0, (GLFont)Resources.get((String)"impact-plain-32.glfont"), (ColorSequenceResource)Resources.get((String)"demo_end.colorseq"), "Find out in the registered version!", true);
                }
                catch (Exception e) {
                    Game.handleException(e);
                }
            }
        }
    }
}

