/*
 * Decompiled with CFR 0.152.
 */
package xap.eolgs.full;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.interpolators.CosineInterpolator;
import com.shavenpuppy.jglib.interpolators.LinearInterpolator;
import com.shavenpuppy.jglib.openal.ALBuffer;
import com.shavenpuppy.jglib.resources.ColorSequenceResource;
import com.shavenpuppy.jglib.sprites.Animation;
import com.shavenpuppy.jglib.sprites.Sprite;
import com.shavenpuppy.jglib.sprites.SpriteImage;
import com.shavenpuppy.jglib.util.FPMath;
import com.shavenpuppy.jglib.util.Util;
import com.shavenpuppy.jglib.util.XMLUtil;
import com.shavenpuppy.jglib.vector.ReadableVector3i;
import com.shavenpuppy.jglib.vector.Vector3i;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.lwjgl.util.Color;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import xap.Emitter;
import xap.Feature;
import xap.Game;
import xap.Gidrah;
import xap.HomingMovement;
import xap.Living;
import xap.Moving;
import xap.Nuke;
import xap.Player;
import xap.SmartBomb;
import xap.features.EmitterFeature;
import xap.features.EntityFeature;
import xap.features.GidrahFeature;
import xap.resources.HomingMovementResource;

public class AlienBrainFeature
extends GidrahFeature {
    public static final long serialVersionUID = 1L;
    private static final HashMap mapping = new HashMap();
    private static final int WOBBLING = 0;
    private static final int SUCKING = 1;
    private static final Color color;
    private ArrayList legs;
    private ArrayList jars;
    private String jarShadow;
    private String brain;
    private String brainShadow;
    private ArrayList eyes;
    private int legRadius;
    private int legHitPoints;
    private String jetEmitter;
    private String legExplosionEmitter;
    private int height;
    private int bob;
    private int bobRate;
    private int distance;
    private HomingMovementResource homingMovement;
    private int minAttackInterval;
    private int maxAttackInterval;
    private int minSpawnInterval;
    private int maxSpawnInterval;
    private String spawn;
    private String spawnSound;
    private int maxSpawn;
    private String fleshyRicochet;
    private String crashEmitter;
    private String smashEmitter;
    private int smallRadius;
    private int smallRadiusSquared;
    private String suctionSound;
    private float suctionPower;
    private int suctionDuration;
    private String suctionColorsequence;
    private transient SpriteImage jarShadowResource;
    private transient SpriteImage brainShadowResource;
    private transient Animation brainAnimationResource;
    private transient SpriteImage[] jarResource;
    private transient EmitterFeature jetEmitterFeature;
    private transient EmitterFeature legExplosionEmitterFeature;
    private transient GidrahFeature spawnFeature;
    private transient ALBuffer spawnSoundResource;
    private transient EmitterFeature fleshyRicochetFeature;
    private transient EmitterFeature crashEmitterFeature;
    private transient EmitterFeature smashEmitterFeature;
    private transient ColorSequenceResource suctionColorsequenceResource;
    private transient ALBuffer suctionSoundResource;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("xap.eolgs.full.AlienBrainFeature$Leg");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        mapping.put("leg", clazz);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("xap.eolgs.full.AlienBrainFeature$Eye");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        mapping.put("eye", clazz2);
        color = new Color();
    }

    public AlienBrainFeature(String name) {
        super(name);
    }

    protected EntityFeature.EntityInstance doSpawn() {
        return new AlienBrainInstance();
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        super.load(element, loader);
        this.legRadius = XMLUtil.getInt((Element)element, (String)"legradius");
        this.legHitPoints = XMLUtil.getInt((Element)element, (String)"leghitpoints");
        this.jetEmitter = XMLUtil.getString((Element)element, (String)"jetemitter");
        this.legExplosionEmitter = XMLUtil.getString((Element)element, (String)"legexplosionemitter");
        this.height = FPMath.fpValue((int)XMLUtil.getInt((Element)element, (String)"height"));
        this.distance = FPMath.fpValue((int)XMLUtil.getInt((Element)element, (String)"distance"));
        this.bob = FPMath.fpValue((int)XMLUtil.getInt((Element)element, (String)"bob"));
        this.bobRate = XMLUtil.getInt((Element)element, (String)"bobrate");
        this.brain = XMLUtil.getString((Element)element, (String)"brain");
        this.brainShadow = XMLUtil.getString((Element)element, (String)"brainshadow");
        this.jarShadow = XMLUtil.getString((Element)element, (String)"jarshadow");
        this.minAttackInterval = XMLUtil.getInt((Element)element, (String)"minattackinterval");
        this.maxAttackInterval = XMLUtil.getInt((Element)element, (String)"maxattackinterval");
        this.minSpawnInterval = XMLUtil.getInt((Element)element, (String)"minspawninterval");
        this.maxSpawnInterval = XMLUtil.getInt((Element)element, (String)"maxspawninterval");
        this.spawn = XMLUtil.getString((Element)element, (String)"spawn");
        this.spawnSound = XMLUtil.getString((Element)element, (String)"spawnsound");
        this.maxSpawn = XMLUtil.getInt((Element)element, (String)"maxspawn");
        this.fleshyRicochet = XMLUtil.getString((Element)element, (String)"fleshyricochet");
        this.crashEmitter = XMLUtil.getString((Element)element, (String)"crashemitter");
        this.smashEmitter = XMLUtil.getString((Element)element, (String)"smashemitter");
        this.suctionDuration = XMLUtil.getInt((Element)element, (String)"suctionduration");
        this.suctionPower = XMLUtil.getFloat((Element)element, (String)"suctionpower");
        this.suctionSound = XMLUtil.getString((Element)element, (String)"suctionsound");
        this.suctionColorsequence = XMLUtil.getString((Element)element, (String)"suctioncolorseq");
        int r = XMLUtil.getInt((Element)element, (String)"smallradius");
        this.smallRadius = FPMath.fpValue((int)r);
        this.smallRadiusSquared = FPMath.fpValue((int)(r * r));
        this.homingMovement = new HomingMovementResource();
        this.homingMovement.load(element, loader);
        try {
            this.legs = new ArrayList(8);
            this.jars = new ArrayList(4);
            this.eyes = new ArrayList(2);
            loader.pushMap((Map)mapping);
            NodeList childNodes = element.getChildNodes();
            int i = 0;
            while (i < childNodes.getLength()) {
                Node node = childNodes.item(i);
                if (node instanceof Element) {
                    Element child = (Element)node;
                    if (child.getTagName().equals("jar")) {
                        this.jars.add(child.getAttribute("image"));
                    } else {
                        Resource childResource = loader.load(child);
                        if (childResource instanceof Leg) {
                            this.legs.add(childResource);
                        } else if (childResource instanceof Eye) {
                            this.eyes.add(childResource);
                        } else {
                            throw new Exception("Illegal sub-node for brain");
                        }
                    }
                }
                ++i;
            }
        }
        finally {
            loader.popMap();
        }
    }

    protected void doCreate() throws Exception {
        super.doCreate();
        this.jarShadowResource = (SpriteImage)Resources.get((String)this.jarShadow);
        this.brainShadowResource = (SpriteImage)Resources.get((String)this.brainShadow);
        this.brainAnimationResource = (Animation)Resources.get((String)this.brain);
        this.legExplosionEmitterFeature = (EmitterFeature)Resources.get((String)this.legExplosionEmitter);
        this.jetEmitterFeature = (EmitterFeature)Resources.get((String)this.jetEmitter);
        this.spawnFeature = (GidrahFeature)Resources.get((String)this.spawn);
        if (Game.hasSound()) {
            this.spawnSoundResource = (ALBuffer)Resources.get((String)this.spawnSound);
            this.suctionSoundResource = (ALBuffer)Resources.get((String)this.suctionSound);
        }
        this.fleshyRicochetFeature = (EmitterFeature)Resources.get((String)this.fleshyRicochet);
        this.crashEmitterFeature = (EmitterFeature)Resources.get((String)this.crashEmitter);
        this.smashEmitterFeature = (EmitterFeature)Resources.get((String)this.smashEmitter);
        this.suctionColorsequenceResource = (ColorSequenceResource)Resources.get((String)this.suctionColorsequence);
        this.jarResource = new SpriteImage[this.jars.size()];
        int i = 0;
        while (i < this.jars.size()) {
            this.jarResource[i] = (SpriteImage)Resources.get((String)((String)this.jars.get(i)));
            ++i;
        }
        i = 0;
        while (i < this.legs.size()) {
            ((Feature)this.legs.get(i)).create();
            ++i;
        }
        i = 0;
        while (i < this.eyes.size()) {
            ((Feature)this.eyes.get(i)).create();
            ++i;
        }
    }

    protected void doDestroy() {
        super.doDestroy();
        this.jarShadowResource = null;
        this.brainShadowResource = null;
        this.brainAnimationResource = null;
        this.legExplosionEmitterFeature = null;
        this.jetEmitterFeature = null;
        this.jarResource = null;
        this.spawnFeature = null;
        this.spawnSoundResource = null;
        this.fleshyRicochetFeature = null;
        this.crashEmitterFeature = null;
        this.smashEmitterFeature = null;
        int i = 0;
        while (i < this.legs.size()) {
            ((Feature)this.legs.get(i)).destroy();
            ++i;
        }
        i = 0;
        while (i < this.eyes.size()) {
            ((Feature)this.eyes.get(i)).destroy();
            ++i;
        }
    }

    public static class Leg
    extends Feature {
        public static final long serialVersionUID = 1L;
        private int xoffset;
        private int yoffset;
        private String image;
        private String shadow;
        private SpriteImage imageResource;
        private SpriteImage shadowResource;

        public void load(Element element, Resource.Loader loader) throws Exception {
            super.load(element, loader);
            this.xoffset = XMLUtil.getInt((Element)element, (String)"xoffset");
            this.yoffset = XMLUtil.getInt((Element)element, (String)"yoffset");
            this.image = XMLUtil.getString((Element)element, (String)"image");
            this.shadow = XMLUtil.getString((Element)element, (String)"shadow", null);
        }

        protected void doCreate() throws Exception {
            super.doCreate();
            this.imageResource = (SpriteImage)Resources.get((String)this.image);
            if (this.shadow != null) {
                this.shadowResource = (SpriteImage)Resources.get((String)this.shadow);
            }
        }

        protected void doDestroy() {
            super.doDestroy();
            this.imageResource = null;
            this.shadowResource = null;
        }

        Instance spawn(AlienBrainInstance brainInstance, AlienBrainFeature brainFeature) {
            return new Instance(brainInstance, brainFeature);
        }

        public class Instance
        implements Living {
            private final AlienBrainInstance brainInstance;
            private final AlienBrainFeature brainFeature;
            private final Vector3i position = new Vector3i();
            private int wounds;
            private boolean active = true;
            private Emitter emitterInstance;
            private Sprite sprite;
            private Sprite shadowSprite;
            private int damageIndicationTick;
            static final /* synthetic */ boolean $assertionsDisabled;
            static /* synthetic */ Class class$0;

            static {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("xap.eolgs.full.AlienBrainFeature$Leg$Instance");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                $assertionsDisabled = !clazz.desiredAssertionStatus();
            }

            private Instance(AlienBrainInstance brainInstance, AlienBrainFeature brainFeature) {
                this.brainInstance = brainInstance;
                this.brainFeature = brainFeature;
                this.emitterInstance = brainFeature.jetEmitterFeature.spawn(brainInstance.position.getX() + Leg.this.xoffset, brainInstance.position.getY() + Leg.this.yoffset, 0, 0, 0, 0);
                this.sprite = Game.allocateSprite(this);
                this.sprite.setImage(Leg.this.imageResource);
                this.sprite.setLayer(1);
                if (Leg.this.shadowResource != null) {
                    this.shadowSprite = Game.allocateSprite(this);
                    this.shadowSprite.setImage(Leg.this.shadowResource);
                    this.shadowSprite.setScale(FPMath.TWO);
                    this.shadowSprite.setLayer(-2);
                }
            }

            void tick() {
                if (!this.active) {
                    return;
                }
                if (this.damageIndicationTick > 0) {
                    this.damageIndicationTick -= Game.getOptions().getTicksPerFrame();
                    if (this.damageIndicationTick <= 0) {
                        this.sprite.setFlash(false);
                    }
                }
                this.position.set(this.brainInstance.position.getX() + FPMath.fpValue((int)Leg.this.xoffset), this.brainInstance.position.getY() + FPMath.fpValue((int)Leg.this.yoffset), this.brainInstance.position.getZ());
                this.sprite.setLocation(FPMath.intValue((int)this.position.getX()), FPMath.intValue((int)this.position.getY()), FPMath.intValue((int)this.position.getZ()));
                if (this.shadowSprite != null) {
                    this.sprite.setLocation(FPMath.intValue((int)this.position.getX()), FPMath.intValue((int)this.position.getY()), FPMath.intValue((int)this.position.getZ()));
                }
                this.emitterInstance.setPosition(this.position.getX(), this.position.getY(), this.position.getZ());
            }

            boolean damage(int points, int x, int y) {
                float hity;
                if (!this.active) {
                    return false;
                }
                float legx = FPMath.floatValue((int)this.brainInstance.position.getX()) + (float)Leg.this.xoffset;
                float legy = FPMath.floatValue((int)this.brainInstance.position.getY()) + (float)Leg.this.yoffset;
                float hitx = FPMath.floatValue((int)x) - legx;
                double distance = Math.sqrt(hitx * hitx + (hity = FPMath.floatValue((int)y) - legy) * hity);
                if (distance <= (double)this.brainFeature.legRadius) {
                    this.wounds += points;
                    if (this.wounds > this.brainFeature.legHitPoints) {
                        this.kill();
                    } else {
                        this.sprite.setFlash(true);
                        this.damageIndicationTick = 4;
                    }
                    return true;
                }
                return false;
            }

            void kill() {
                this.brainFeature.legExplosionEmitterFeature.spawn(this.position.getX(), this.position.getY(), this.position.getZ(), 0, 0, 0);
                this.remove();
            }

            void remove() {
                this.active = false;
                if (this.sprite != null) {
                    this.sprite.deallocate();
                    this.sprite = null;
                }
                if (this.shadowSprite != null) {
                    this.shadowSprite.deallocate();
                    this.shadowSprite = null;
                }
                if (this.emitterInstance != null) {
                    this.emitterInstance.remove();
                    this.emitterInstance = null;
                }
            }

            public boolean isAlive() {
                return this.active;
            }

            public Vector3i getVelocity() {
                return null;
            }

            public Vector3i getVelocity(Vector3i dest) {
                return dest;
            }

            public void setVelocity(int x, int y, int z) {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }

            public Vector3i getPosition() {
                return this.position;
            }

            public Vector3i getPosition(Vector3i dest) {
                if (dest == null) {
                    return new Vector3i((ReadableVector3i)this.position);
                }
                dest.set((ReadableVector3i)this.position);
                return dest;
            }

            public void setPosition(int x, int y, int z) {
                this.position.set(x, y, z);
            }

            void setAlpha(int alpha) {
                if (this.sprite != null) {
                    this.sprite.setAlpha(alpha);
                }
                if (this.shadowSprite != null) {
                    this.shadowSprite.setAlpha(alpha);
                }
            }
        }
    }

    public static class Eye
    extends Feature {
        public static final long serialVersionUID = 1L;
        private int xoffset;
        private int yoffset;
        private String[] eyeImage;
        private HomingMovementResource homingMovement;
        private SpriteImage[] eyeImageResource;

        public void load(Element element, Resource.Loader loader) throws Exception {
            super.load(element, loader);
            this.xoffset = FPMath.fpValue((int)XMLUtil.getInt((Element)element, (String)"xoffset"));
            this.yoffset = FPMath.fpValue((int)XMLUtil.getInt((Element)element, (String)"yoffset"));
            this.homingMovement = new HomingMovementResource();
            this.homingMovement.load(element, loader);
            NodeList childNodes = element.getElementsByTagName("image");
            ArrayList<String> temp = new ArrayList<String>();
            int i = 0;
            while (i < childNodes.getLength()) {
                if (childNodes.item(i) instanceof Element) {
                    Element child = (Element)childNodes.item(i);
                    Text textNode = (Text)child.getFirstChild();
                    temp.add(textNode.getData());
                }
                ++i;
            }
            this.eyeImage = new String[temp.size()];
            temp.toArray(this.eyeImage);
        }

        protected void doCreate() throws Exception {
            super.doCreate();
            this.eyeImageResource = new SpriteImage[this.eyeImage.length];
            int i = 0;
            while (i < this.eyeImage.length) {
                this.eyeImageResource[i] = (SpriteImage)Resources.get((String)this.eyeImage[i]);
                ++i;
            }
        }

        protected void doDestroy() {
            super.doDestroy();
            this.eyeImageResource = null;
        }

        Instance spawn(AlienBrainInstance brainInstance, AlienBrainFeature brainFeature) {
            return new Instance(brainInstance, brainFeature);
        }

        public class Instance
        implements Moving {
            private final Vector3i position = new Vector3i();
            private final Vector3i velocity = new Vector3i();
            private Sprite sprite;
            private final AlienBrainInstance brainInstance;
            private final AlienBrainFeature brainFeature;
            private final HomingMovement movement;

            private Instance(AlienBrainInstance brainInstance, AlienBrainFeature brainFeature) {
                this.brainInstance = brainInstance;
                this.brainFeature = brainFeature;
                this.movement = Eye.this.homingMovement.spawn(this);
                this.velocity.setX(FPMath.fpValue((int)(Util.random((int)0, (int)1) * 2 - 1)));
                this.velocity.setY(FPMath.fpValue((int)(Util.random((int)0, (int)1) * 2 - 1)));
                this.position.setX(FPMath.fpValue((int)(Util.random((int)0, (int)1) * 2 - 1)));
                this.position.setY(FPMath.fpValue((int)(Util.random((int)0, (int)1) * 2 - 1)));
                this.sprite = Game.allocateSprite(this);
                this.sprite.setLayer(3);
                this.tick();
            }

            void tick() {
                this.movement.tick();
                int px = this.position.getX() + this.brainInstance.position.getX() + Eye.this.xoffset;
                int py = this.position.getY() + this.brainInstance.position.getY() + Eye.this.yoffset;
                this.sprite.setLocation(FPMath.intValue((int)px), FPMath.intValue((int)py), FPMath.intValue((int)this.brainInstance.position.getZ()));
                int dx = Game.getPlayer().getLastKnownPosition().getX() - px;
                int dy = Game.getPlayer().getLastKnownPosition().getY() - py;
                double angle = Math.abs(Math.toDegrees(Math.atan2(dy, dx)));
                if (angle < 45.0) {
                    angle = 45.0;
                } else if (angle > 135.0) {
                    angle = 135.0;
                }
                int image = (int)LinearInterpolator.instance.interpolate((float)(Eye.this.eyeImage.length - 1), 0.0f, (float)(angle -= 45.0) / 90.0f);
                this.sprite.setImage(Eye.this.eyeImageResource[image]);
                if (this.brainInstance.phase == 1) {
                    this.sprite.setScale(FPMath.fpValue((double)(Math.random() * 0.3 + 0.85)));
                    this.brainFeature.suctionColorsequenceResource.getColor(this.brainInstance.suctionTick, color);
                    this.sprite.setColors(color.getRed(), color.getGreen(), color.getBlue(), 255);
                } else {
                    this.sprite.setScale(FPMath.ONE);
                    this.sprite.setColors(255, 255, 255, 255);
                }
            }

            void remove() {
                if (this.sprite != null) {
                    this.sprite.deallocate();
                    this.sprite = null;
                }
            }

            public Vector3i getPosition() {
                return this.position;
            }

            public Vector3i getVelocity() {
                return this.velocity;
            }

            public Vector3i getPosition(Vector3i dest) {
                if (dest == null) {
                    return new Vector3i((ReadableVector3i)this.position);
                }
                dest.set((ReadableVector3i)this.position);
                return dest;
            }

            public Vector3i getVelocity(Vector3i dest) {
                if (dest == null) {
                    return new Vector3i((ReadableVector3i)this.velocity);
                }
                dest.set((ReadableVector3i)this.velocity);
                return dest;
            }

            public void setPosition(int x, int y, int z) {
                this.position.set(x, y, z);
            }

            public void setVelocity(int x, int y, int z) {
                this.velocity.set(x, y, z);
            }

            void setAlpha(int alpha) {
                if (this.sprite != null) {
                    this.sprite.setAlpha(alpha);
                }
            }
        }
    }

    private class AlienBrainInstance
    extends GidrahFeature.GidrahInstance {
        private int numLegs;
        private final Leg.Instance[] legInstance;
        private final Eye.Instance[] eyeInstance;
        private int damageIndicationTick;
        private Sprite brainSprite;
        private Sprite jarSprite;
        private Sprite brainShadowSprite;
        private Sprite jarShadowSprite;
        private int jarState;
        private final HomingMovement movementInstance;
        private int tick;
        private int nextAttackTime;
        private int nextSpawnTime;
        private int bobTick;
        private boolean crashing;
        private int crashTick;
        private Emitter crashEmitterInstance;
        private int crashHeight;
        private int spawnTick;
        private int phase;
        private int suctionTick;
        static final /* synthetic */ boolean $assertionsDisabled;
        static /* synthetic */ Class class$0;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("xap.eolgs.full.AlienBrainFeature$AlienBrainInstance");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        public AlienBrainInstance() {
            super(AlienBrainFeature.this);
            this.phase = 0;
            this.movementInstance = AlienBrainFeature.this.homingMovement.spawn(this);
            this.legInstance = new Leg.Instance[AlienBrainFeature.this.legs.size()];
            int i = 0;
            while (i < AlienBrainFeature.this.legs.size()) {
                this.legInstance[i] = ((Leg)AlienBrainFeature.this.legs.get(i)).spawn(this, AlienBrainFeature.this);
                ++i;
            }
            this.eyeInstance = new Eye.Instance[AlienBrainFeature.this.eyes.size()];
            i = 0;
            while (i < AlienBrainFeature.this.eyes.size()) {
                this.eyeInstance[i] = ((Eye)AlienBrainFeature.this.eyes.get(i)).spawn(this, AlienBrainFeature.this);
                ++i;
            }
        }

        private void initSprite() {
            this.brainSprite = Game.allocateSprite(this);
            this.brainSprite.setAnimation(AlienBrainFeature.this.brainAnimationResource);
            this.brainSprite.setLayer(2);
            this.jarSprite = Game.allocateSprite(this);
            this.jarSprite.setImage(AlienBrainFeature.this.jarResource[0]);
            this.jarSprite.setLayer(4);
            this.brainShadowSprite = Game.allocateSprite(this);
            this.brainShadowSprite.setImage(AlienBrainFeature.this.brainShadowResource);
            this.brainShadowSprite.setScale(FPMath.TWO);
            this.brainShadowSprite.setLayer(-2);
            this.jarShadowSprite = Game.allocateSprite(this);
            this.jarShadowSprite.setImage(AlienBrainFeature.this.jarShadowResource);
            this.jarShadowSprite.setScale(FPMath.TWO);
            this.jarShadowSprite.setLayer(-2);
        }

        public void inCollisionWithPlayer(Player player) {
        }

        public void inCollisionWithSmartBomb(SmartBomb smartBomb) {
        }

        public void inCollisionWithNuke(Nuke nuke) {
        }

        void bobTheBrain() {
            this.bobTick += Game.getOptions().getTicksPerFrame();
            this.bobTick &= 0xFFFF;
            this.position.setZ(FPMath.mul((int)AlienBrainFeature.this.bob, (int)FPMath.cos((int)this.bobTick)) + AlienBrainFeature.this.height);
        }

        void crashTheBrain() {
            if (this.position.getZ() > 0) {
                this.crashTick += Game.getOptions().getTicksPerFrame();
                this.position.setZ(CosineInterpolator.instance.interpolate(this.crashHeight, 0, FPMath.fpValue((float)((float)this.crashTick / 60.0f))));
                if (this.position.getZ() == 0) {
                    Game.shake(80, 24);
                }
            } else {
                this.velocity.scale(FPMath.fpValue((float)0.8f));
            }
            this.crashEmitterInstance.setPosition(this.position.getX(), this.position.getY(), this.position.getZ());
        }

        void updateSpriteLocations() {
            int x = FPMath.intValue((int)this.position.getX());
            int y = FPMath.intValue((int)this.position.getY());
            int z = FPMath.intValue((int)this.position.getZ());
            this.brainSprite.setLocation(x, y, z);
            this.jarSprite.setLocation(x, y, z);
            this.brainShadowSprite.setLocation(x, y, z);
            this.jarShadowSprite.setLocation(x, y, z);
        }

        void tickBits() {
            int i = 0;
            while (i < this.legInstance.length) {
                this.legInstance[i].tick();
                ++i;
            }
            i = 0;
            while (i < this.eyeInstance.length) {
                this.eyeInstance[i].tick();
                ++i;
            }
        }

        protected void doGidrahTick() {
            if (this.damageIndicationTick > 0) {
                this.damageIndicationTick -= Game.getOptions().getTicksPerFrame();
                if (this.damageIndicationTick <= 0) {
                    this.brainSprite.setFlash(false);
                    this.jarSprite.setFlash(false);
                }
            }
            if (this.phase == 0) {
                this.movementInstance.setDestination(Game.getPlayer().getLastKnownPosition().getX(), Game.getPlayer().getLastKnownPosition().getY() + AlienBrainFeature.this.distance);
                this.movementInstance.tick();
            } else if (!this.crashing) {
                this.velocity.scale(FPMath.fpValue((float)0.8f));
            }
            if (this.crashing) {
                this.crashTheBrain();
            } else {
                this.bobTheBrain();
            }
            this.tickBits();
            this.updateSpriteLocations();
            switch (this.phase) {
                case 0: {
                    this.tick += Game.getOptions().getTicksPerFrame();
                    if (this.tick > this.nextAttackTime) {
                        this.setNextAttackTime();
                        this.suckPlayer();
                    }
                    if (this.tick <= this.nextSpawnTime) break;
                    Gidrah gidrah = (Gidrah)AlienBrainFeature.this.spawnFeature.spawn();
                    if (gidrah != null) {
                        gidrah.setPosition(this.position.getX(), this.position.getY(), 0);
                        gidrah.hatch();
                        Game.allocateSound(AlienBrainFeature.this.spawnSoundResource, this.position, null, this);
                    }
                    this.setNextSpawnTime();
                    break;
                }
                case 1: {
                    this.suctionTick += Game.getOptions().getTicksPerFrame();
                    if (this.suctionTick > AlienBrainFeature.this.suctionDuration) {
                        this.phase = 0;
                        break;
                    }
                    Game.getPlayer().accelerate(this.position.getX(), this.position.getY(), AlienBrainFeature.this.suctionPower);
                    break;
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    break;
                }
            }
        }

        void suckPlayer() {
            Game.allocateSound(AlienBrainFeature.this.suctionSoundResource, this.position, null, this);
            this.suctionTick = 0;
            this.phase = 1;
        }

        protected void doGidrahSpawnTick() {
            this.spawnTick += Game.getOptions().getTicksPerFrame();
            this.setAlpha((int)LinearInterpolator.instance.interpolate(0.0f, 255.0f, (float)this.spawnTick / (float)AlienBrainFeature.this.beamInEmitterFeature.getDuration()));
            this.bobTheBrain();
            this.updateSpriteLocations();
            this.tickBits();
        }

        protected void doResIn() {
            this.position.set(FPMath.fpValue((int)512), FPMath.fpValue((int)512), 0);
            this.initSprite();
            this.setAlpha(0);
            this.setNextAttackTime();
            this.setNextSpawnTime();
        }

        void setAlpha(int alpha) {
            this.brainSprite.setAlpha(alpha);
            this.brainShadowSprite.setAlpha(alpha);
            this.jarSprite.setAlpha(alpha);
            this.jarShadowSprite.setAlpha(alpha);
            int i = 0;
            while (i < this.legInstance.length) {
                this.legInstance[i].setAlpha(alpha);
                ++i;
            }
            i = 0;
            while (i < this.eyeInstance.length) {
                this.eyeInstance[i].setAlpha(alpha);
                ++i;
            }
        }

        private void setNextAttackTime() {
            this.nextAttackTime += Util.random((int)AlienBrainFeature.this.minAttackInterval, (int)AlienBrainFeature.this.maxAttackInterval);
        }

        private void setNextSpawnTime() {
            this.nextSpawnTime += Util.random((int)AlienBrainFeature.this.minSpawnInterval, (int)AlienBrainFeature.this.maxSpawnInterval);
        }

        protected void removeSprites() {
            if (this.brainSprite != null) {
                this.brainSprite.deallocate();
                this.brainSprite = null;
            }
            if (this.brainShadowSprite != null) {
                this.brainShadowSprite.deallocate();
                this.brainShadowSprite = null;
            }
            if (this.jarSprite != null) {
                this.jarSprite.deallocate();
                this.jarSprite = null;
            }
            if (this.jarShadowSprite != null) {
                this.jarShadowSprite.deallocate();
                this.jarShadowSprite = null;
            }
            int i = 0;
            while (i < this.legInstance.length) {
                this.legInstance[i].remove();
                ++i;
            }
            i = 0;
            while (i < this.eyeInstance.length) {
                this.eyeInstance[i].remove();
                ++i;
            }
        }

        protected void indicateDamage() {
            if (this.jarState < AlienBrainFeature.this.jarResource.length) {
                this.jarSprite.setFlash(true);
            } else {
                this.brainSprite.setFlash(true);
            }
            this.damageIndicationTick = 2;
        }

        protected void makeRicochetSound(int x, int y) {
            if (this.jarState < AlienBrainFeature.this.jarResource.length) {
                AlienBrainFeature.this.ricochetFeature.spawn(x, y, 0, this.velocity.getX(), this.velocity.getY(), 0);
            } else {
                AlienBrainFeature.this.fleshyRicochetFeature.spawn(x, y, 0, this.velocity.getX(), this.velocity.getY(), 0);
            }
        }

        public void damage(int points, int x, int y) {
            boolean legHit = false;
            int legCount = 0;
            int i = 0;
            while (i < this.legInstance.length) {
                legHit |= this.legInstance[i].damage(points, x, y);
                if (this.legInstance[i].isAlive()) {
                    ++legCount;
                }
                ++i;
            }
            this.movementInstance.setScale((float)legCount / (float)this.legInstance.length);
            if (!legHit) {
                super.damage(points, x, y);
                int newJarState = (int)LinearInterpolator.instance.interpolate(0.0f, (float)AlienBrainFeature.this.jarResource.length + 2.0f, (float)this.getWounds() / (float)this.getHitPoints());
                if (newJarState != this.jarState) {
                    this.jarState = newJarState;
                    if (this.jarState == AlienBrainFeature.this.jarResource.length) {
                        this.jarSprite.setActive(false);
                        AlienBrainFeature.this.smashEmitterFeature.spawn(this.position.getX(), this.position.getY(), this.position.getZ(), 0, 0, 0);
                    } else if (this.jarState < AlienBrainFeature.this.jarResource.length) {
                        this.jarSprite.setImage(AlienBrainFeature.this.jarResource[this.jarState]);
                    }
                }
            } else if (legCount == 0) {
                this.crashing = true;
                this.crashHeight = this.position.getZ();
                this.crashEmitterInstance = AlienBrainFeature.this.crashEmitterFeature.spawn(this.position.getX(), this.position.getY(), this.position.getZ(), 0, 0, 0);
            }
        }

        public int getRadius() {
            if (this.jarState < AlienBrainFeature.this.jarResource.length) {
                return super.getRadius();
            }
            return AlienBrainFeature.this.smallRadius;
        }

        public int getRadiusSquared() {
            if (this.jarState < AlienBrainFeature.this.jarResource.length) {
                return super.getRadiusSquared();
            }
            return AlienBrainFeature.this.smallRadiusSquared;
        }
    }
}

