/*
 * Decompiled with CFR 0.152.
 */
package xap.emitters;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.openal.ALBuffer;
import com.shavenpuppy.jglib.sound.SoundEffect;
import com.shavenpuppy.jglib.util.FPMath;
import com.shavenpuppy.jglib.util.Util;
import com.shavenpuppy.jglib.util.XMLUtil;
import com.shavenpuppy.jglib.vector.ReadableVector3i;
import com.shavenpuppy.jglib.vector.Vector3i;
import com.shavenpuppy.jglib.vector.WritableVector3i;
import org.w3c.dom.Element;
import xap.Game;
import xap.features.EmitterFeature;
import xap.features.ParticleFeature;

public class GenericEmitterFeature
extends EmitterFeature {
    public static final long serialVersionUID = 1L;
    private static final Vector3i distanceCalc = new Vector3i();
    protected int minDistance;
    protected int maxDistance;
    protected int minInterval;
    protected int maxInterval;
    protected String particle;
    protected int numParticles;
    protected String soundEffect;
    protected transient ParticleFeature particleFeature;
    protected transient ALBuffer soundEffectResource;

    public GenericEmitterFeature() {
    }

    public GenericEmitterFeature(String name) {
        super(name);
    }

    protected final EmitterFeature.EmitterInstance doSpawn() {
        return new GenericEmitterInstance();
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        super.load(element, loader);
        this.particle = XMLUtil.getString((Element)element, (String)"particle", null);
        this.numParticles = XMLUtil.getInt((Element)element, (String)"numparticles");
        float fminDistance = XMLUtil.getFloat((Element)element, (String)"mindistance", (float)0.0f);
        fminDistance *= fminDistance;
        float fmaxDistance = XMLUtil.getFloat((Element)element, (String)"maxdistance", (float)0.0f);
        fmaxDistance *= fmaxDistance;
        this.minDistance = FPMath.fpValue((float)fminDistance);
        this.maxDistance = FPMath.fpValue((float)fmaxDistance);
        this.minInterval = XMLUtil.getInt((Element)element, (String)"mininterval", (int)0);
        this.maxInterval = XMLUtil.getInt((Element)element, (String)"maxinterval", (int)0);
        this.soundEffect = XMLUtil.getString((Element)element, (String)"soundeffect", null);
    }

    protected void doCreate() throws Exception {
        if (this.particle != null) {
            this.particleFeature = (ParticleFeature)Resources.get((String)this.particle);
        }
        if (Game.hasSound() && this.soundEffect != null) {
            this.soundEffectResource = (ALBuffer)Resources.get((String)this.soundEffect);
        }
    }

    protected void doDestroy() {
        super.doDestroy();
        this.particleFeature = null;
        this.soundEffectResource = null;
    }

    protected class GenericEmitterInstance
    extends EmitterFeature.EmitterInstance {
        private final Vector3i lastPosition;
        private SoundEffect soundEffectInstance;
        private int nextEmissionDistance;
        private int nextEmissionTick;

        protected GenericEmitterInstance() {
            super(GenericEmitterFeature.this);
            this.lastPosition = new Vector3i();
        }

        protected void doTick() {
            if (this.soundEffectInstance != null) {
                this.soundEffectInstance.setPosition(FPMath.floatValue((int)this.position.getX()), FPMath.floatValue((int)this.position.getY()), FPMath.floatValue((int)this.position.getZ()), (Object)this);
                this.soundEffectInstance.setVelocity(FPMath.floatValue((int)this.velocity.getX()), FPMath.floatValue((int)this.velocity.getY()), FPMath.floatValue((int)this.velocity.getZ()), (Object)this);
            }
            if (GenericEmitterFeature.this.particleFeature != null) {
                Vector3i.sub((ReadableVector3i)this.position, (ReadableVector3i)this.lastPosition, (WritableVector3i)distanceCalc);
                int distanceMoved = (int)distanceCalc.lengthSquared();
                if (distanceMoved >= this.nextEmissionDistance && GenericEmitterFeature.this.minDistance > 0 || this.getTick() > this.nextEmissionTick && GenericEmitterFeature.this.minInterval > 0) {
                    Vector3i position = this.getPosition();
                    this.lastPosition.set((ReadableVector3i)position);
                    this.nextEmissionDistance = Util.random((int)GenericEmitterFeature.this.minDistance, (int)GenericEmitterFeature.this.maxDistance);
                    this.nextEmissionTick = this.getTick() + Util.random((int)GenericEmitterFeature.this.minInterval, (int)GenericEmitterFeature.this.maxInterval);
                    int i = 0;
                    while (i < GenericEmitterFeature.this.numParticles) {
                        if (GenericEmitterFeature.this.particleFeature.allocate(position.getX(), position.getY(), position.getZ(), 0, 0, 0) == null) {
                            this.setActive(false);
                            break;
                        }
                        ++i;
                    }
                }
            }
        }

        protected void doRemove() {
            super.doRemove();
            this.soundEffectInstance = null;
        }

        protected void doSpawn() {
            if (GenericEmitterFeature.this.soundEffect != null) {
                this.soundEffectInstance = Game.allocateSound(GenericEmitterFeature.this.soundEffectResource, this.position, this.velocity, this);
            }
        }
    }
}

