/*
 * Decompiled with CFR 0.152.
 */
package xap.effects;

import com.shavenpuppy.jglib.interpolators.LinearInterpolator;
import com.shavenpuppy.jglib.util.FPMath;
import com.shavenpuppy.jglib.vector.Vector3i;
import org.lwjgl.opengl.GL11;
import xap.Blob;
import xap.SpecialEffect;
import xap.features.SpecialEffectFeature;

public final class BubbleAttackEffect
extends SpecialEffectFeature {
    public static final long serialVersionUID = 1L;
    private static final BubbleAttackEffect bubbleAttackEffect = new BubbleAttackEffect();
    private static final int DURATION = 120;
    private static final float DURATIONF = 120.0f;
    private static final float OUTER_START_SIZE = 1024.0f;
    private static final float OUTER_END_SIZE = 32.0f;
    private static final float INNER_SIZE = 128.0f;
    private static final float INNER_ROTATION = 1.0f;
    private static final float OUTER_ROTATION = -1.0f;
    private static final float LINE_LENGTH = 32.0f;
    private static final float INNER_LINE_RADIUS = 96.0f;

    private BubbleAttackEffect() {
    }

    protected SpecialEffectFeature.SpecialEffectInstance doSpawn() {
        return new BubbleAttackEffectInstance();
    }

    public static final SpecialEffect spawn(Blob blob) {
        Vector3i pos = blob.getPosition();
        BubbleAttackEffectInstance ret = (BubbleAttackEffectInstance)bubbleAttackEffect.spawn(pos.getX(), pos.getY(), 0, 0, 0, 0, false);
        ret.setBlob(blob);
        return ret;
    }

    private class BubbleAttackEffectInstance
    extends SpecialEffectFeature.SpecialEffectInstance {
        private float outerAngle;
        private float innerAngle;
        private Blob blob;

        BubbleAttackEffectInstance() {
            super(BubbleAttackEffect.this);
        }

        private void setBlob(Blob blob) {
            this.blob = blob;
        }

        public boolean isVisible() {
            return this.blob.isCaptured() && this.getTick() < 120;
        }

        protected void doTick() {
            this.innerAngle += 1.0f;
            this.outerAngle += -1.0f;
        }

        public void render() {
            GL11.glColor4ub((byte)50, (byte)-1, (byte)50, (byte)-128);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)1);
            float x = FPMath.floatValue((int)this.position.getX());
            float y = FPMath.floatValue((int)this.position.getY());
            GL11.glLineWidth((float)3.0f);
            GL11.glPushMatrix();
            try {
                float radius = LinearInterpolator.instance.interpolate(1024.0f, 32.0f, (float)this.getTick() / 120.0f);
                float lineRadius = radius + 32.0f;
                GL11.glTranslatef((float)x, (float)y, (float)0.0f);
                GL11.glBegin((int)2);
                int i = 0;
                while (i < 32) {
                    GL11.glVertex2f((float)((float)Math.cos((double)i * Math.PI / 16.0) * radius), (float)((float)Math.sin((double)i * Math.PI / 16.0) * radius));
                    ++i;
                }
                GL11.glEnd();
                GL11.glRotatef((float)this.outerAngle, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glBegin((int)1);
                i = 0;
                while (i < 32) {
                    GL11.glVertex2f((float)((float)Math.cos((double)i * Math.PI / 16.0) * radius), (float)((float)Math.sin((double)i * Math.PI / 16.0) * radius));
                    GL11.glVertex2f((float)((float)Math.cos((double)i * Math.PI / 16.0) * lineRadius), (float)((float)Math.sin((double)i * Math.PI / 16.0) * lineRadius));
                    i += 8;
                }
                GL11.glEnd();
            }
            finally {
                GL11.glPopMatrix();
            }
            GL11.glPushMatrix();
            try {
                GL11.glTranslatef((float)x, (float)y, (float)0.0f);
                GL11.glRotatef((float)this.innerAngle, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glLineStipple((int)4, (short)-3856);
                GL11.glEnable((int)2852);
                GL11.glBegin((int)2);
                int i = 0;
                while (i < 32) {
                    GL11.glVertex2f((float)((float)Math.cos((double)i * Math.PI / 16.0) * 128.0f), (float)((float)Math.sin((double)i * Math.PI / 16.0) * 128.0f));
                    ++i;
                }
                GL11.glEnd();
                GL11.glDisable((int)2852);
                GL11.glBegin((int)1);
                i = 0;
                while (i < 32) {
                    GL11.glVertex2f((float)((float)Math.cos((double)i * Math.PI / 16.0) * 128.0f), (float)((float)Math.sin((double)i * Math.PI / 16.0) * 128.0f));
                    GL11.glVertex2f((float)((float)Math.cos((double)i * Math.PI / 16.0) * 96.0f), (float)((float)Math.sin((double)i * Math.PI / 16.0) * 96.0f));
                    i += 8;
                }
                GL11.glEnd();
            }
            finally {
                GL11.glPopMatrix();
                GL11.glLineWidth((float)1.0f);
            }
        }
    }
}

