/*
 * Decompiled with CFR 0.152.
 */
package xap.background;

import com.shavenpuppy.jglib.renderer.ShadedTriangle;
import com.shavenpuppy.jglib.renderer.Shader;
import com.shavenpuppy.jglib.renderer.State;
import com.shavenpuppy.jglib.renderer.Triangle;
import org.lwjgl.util.vector.Vector3f;
import xap.background.BumpMapPassState;
import xap.background.BumpMappedGeometry;
import xap.background.BumpMappedGeometrySortState;
import xap.background.DiffusePassState;
import xap.background.EmptyState;
import xap.background.LitShader;
import xap.background.TextureSortState;

public final class BumpMappedShader
extends LitShader {
    private final BumpMappedGeometry geometry;
    private final State[] bumpState;
    private final State[] diffuseState;
    private static final Vector3f vertex = new Vector3f();

    public BumpMappedShader(BumpMappedGeometrySortState geometrySortState, BumpMapPassState bumpMapPassState, DiffusePassState diffusePassState, TextureSortState bumpTextureSortState, TextureSortState diffuseTextureSortState, int maxVertexIndex) {
        super(maxVertexIndex);
        this.geometry = geometrySortState.geometry;
        this.bumpState = new State[]{geometrySortState, EmptyState.instance, bumpMapPassState, bumpTextureSortState};
        this.diffuseState = new State[]{geometrySortState, EmptyState.instance, diffusePassState, diffuseTextureSortState};
    }

    public int shade(Triangle triangle, ShadedTriangle[] output, int pos) {
        output[pos++].update(triangle, (Shader)this, this.bumpState);
        output[pos++].update(triangle, (Shader)this, this.diffuseState);
        return 2;
    }

    protected void doProcess(int v) {
        this.geometry.getVertex(v, vertex);
        BumpMappedShader.vertex.x = this.light.x - BumpMappedShader.vertex.x;
        BumpMappedShader.vertex.y = this.light.y - BumpMappedShader.vertex.y;
        BumpMappedShader.vertex.z = this.light.z - BumpMappedShader.vertex.z;
        this.geometry.setLightVector(v, vertex);
    }
}

