/*
 * Decompiled with CFR 0.152.
 */
package xap;

import com.shavenpuppy.jglib.Image;
import com.shavenpuppy.jglib.algorithms.RadixSort;
import com.shavenpuppy.jglib.resources.ColorSequenceResource;
import com.shavenpuppy.jglib.util.FPMath;
import com.shavenpuppy.jglib.util.Util;
import java.nio.ByteBuffer;
import org.lwjgl.util.Color;
import org.lwjgl.util.Point;
import xap.CellularTexture;

public class CellularTexture
extends Image {
    public static final long serialVersionUID = 1L;
    private int numPoints;
    private transient Point[] point;
    private transient int[] index;
    private int minDist;
    private int maxDist;
    private CellType cellType;
    private ColorSequenceResource colorSequence;
    private RadixSort sort = new RadixSort();
    public static final CellType FUNGUS;
    public static final CellType CELLS;
    public static final CellType GERMS;
    public static final CellType DISEASE;
    public static final CellType[] RANDOM;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("xap.CellularTexture");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        FUNGUS = new Fungus();
        CELLS = new Cells();
        GERMS = new Germs();
        DISEASE = new Disease();
        RANDOM = new CellType[]{FUNGUS, CELLS, GERMS, DISEASE};
    }

    public static CellType decode(String name) throws Exception {
        int i = 0;
        while (i < RANDOM.length) {
            if (RANDOM[i].name.equals(name)) {
                return RANDOM[i];
            }
            ++i;
        }
        throw new Exception("Failed to decode texture type '" + name + "'");
    }

    public static String randomCode() {
        return RANDOM[Util.random((int)0, (int)(RANDOM.length - 1))].name;
    }

    public CellularTexture(int width, int height, int imageFormat, CellType cellType, int numPoints, ColorSequenceResource colorSequence) {
        super(width, height, imageFormat);
        this.cellType = cellType;
        this.numPoints = numPoints;
        this.colorSequence = colorSequence;
        this.createPoints();
        this.calculateImage();
        this.convertImage();
        this.cleanup();
    }

    private void createPoints() {
        this.point = new Point[this.numPoints];
        int i = 0;
        while (i < this.numPoints) {
            this.point[i] = new Point(Util.random((int)0, (int)(this.getWidth() - 1)), Util.random((int)0, (int)(this.getHeight() - 1)));
            ++i;
        }
    }

    private void calculateImage() {
        int i = 0;
        this.minDist = Integer.MAX_VALUE;
        this.maxDist = Integer.MIN_VALUE;
        this.index = new int[this.getWidth() * this.getHeight()];
        int y = 0;
        while (y < this.getHeight()) {
            int x = 0;
            while (x < this.getWidth()) {
                int dist = this.cellType.getColor(x, y, this);
                if (dist < this.minDist) {
                    this.minDist = dist;
                }
                if (dist > this.maxDist) {
                    this.maxDist = dist;
                }
                this.index[i++] = dist;
                ++x;
            }
            ++y;
        }
        int range = this.colorSequence != null ? this.colorSequence.getDuration() : 255;
        int j = 0;
        while (j < this.index.length) {
            this.index[j] = this.cellType.postProcess(this.index[j], this.minDist, this.maxDist);
            this.index[j] = range * (this.index[j] - this.minDist) / (this.maxDist - this.minDist);
            ++j;
        }
    }

    private void convertImage() {
        ByteBuffer buf = this.getData();
        if (this.getType() == 8 || this.getType() == 2) {
            int i = 0;
            while (i < this.index.length) {
                buf.put((byte)this.index[i]);
                ++i;
            }
        } else {
            Color c = new Color();
            if (this.getType() == 0) {
                int i = 0;
                while (i < this.index.length) {
                    this.colorSequence.getColor(this.index[i], c);
                    c.writeRGB(buf);
                    ++i;
                }
            } else if (this.getType() == 1) {
                int i = 0;
                while (i < this.index.length) {
                    this.colorSequence.getColor(this.index[i], c);
                    c.writeRGBA(buf);
                    ++i;
                }
            } else if (this.getType() == 5) {
                int i = 0;
                while (i < this.index.length) {
                    this.colorSequence.getColor(this.index[i], c);
                    c.writeABGR(buf);
                    ++i;
                }
            } else if (this.getType() == 6) {
                int i = 0;
                while (i < this.index.length) {
                    this.colorSequence.getColor(this.index[i], c);
                    c.writeBGR(buf);
                    ++i;
                }
            } else if (this.getType() == 7) {
                int i = 0;
                while (i < this.index.length) {
                    this.colorSequence.getColor(this.index[i], c);
                    c.writeBGRA(buf);
                    ++i;
                }
            } else if (this.getType() == 4) {
                int i = 0;
                while (i < this.index.length) {
                    this.colorSequence.getColor(this.index[i], c);
                    c.writeARGB(buf);
                    ++i;
                }
            } else if (this.getType() == 3) {
                int i = 0;
                while (i < this.index.length) {
                    this.colorSequence.getColor(this.index[i], c);
                    buf.put(c.getRedByte());
                    buf.put(c.getAlphaByte());
                    ++i;
                }
            } else if (!$assertionsDisabled) {
                throw new AssertionError((Object)"Unsupported image type");
            }
        }
        buf.flip();
    }

    private void cleanup() {
        this.point = null;
        this.sort = null;
        this.index = null;
    }

    private int wrappedDistance(int x0, int y0, int x1, int y1) {
        return FPMath.intValue((int)FPMath.sqrt((int)FPMath.fpValue((int)this.wrappedDistanceSquared(x0, y0, x1, y1))));
    }

    private int wrappedDistanceSquared(int x0, int y0, int x1, int y1) {
        int dx = Math.abs(x0 - x1);
        int dy = Math.abs(y0 - y1);
        if (dx > this.getWidth() >> 1) {
            dx = this.getWidth() - dx;
        }
        if (dy > this.getHeight() >> 1) {
            dy = this.getHeight() - dy;
        }
        return dx * dx + dy * dy;
    }

    private void findNearest(int x, int y, Point[] ret) {
        final class Dist
        implements RadixSort.Sortable {
            final int dist;
            final Point p;
            final /* synthetic */ CellularTexture this$0;

            Dist(CellularTexture cellularTexture, Point p, int dist) {
                this.this$0 = cellularTexture;
                this.p = p;
                this.dist = dist;
            }

            public int sortOrder() {
                return this.dist;
            }
        }
        RadixSort.Sortable[] dists = new Dist[this.point.length];
        int i = 0;
        while (i < this.point.length) {
            dists[i] = new Dist(this, this.point[i], this.wrappedDistanceSquared(x, y, this.point[i].getX(), this.point[i].getY()));
            ++i;
        }
        this.sort.resetIndices().sort(dists, dists.length);
        int[] idx = this.sort.getIndices();
        int i2 = 0;
        while (i2 < ret.length) {
            ret[i2] = dists[idx[i2]].p;
            ++i2;
        }
    }

    public static abstract class CellType {
        private final String name;

        CellType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public abstract int getColor(int var1, int var2, CellularTexture var3);

        public int postProcess(int c, int minValue, int maxValue) {
            return c;
        }
    }

    private static final class Fungus
    extends CellType {
        Point[] p = new Point[1];

        Fungus() {
            super("fungus");
        }

        public int getColor(int x, int y, CellularTexture texture) {
            texture.findNearest(x, y, this.p);
            return texture.wrappedDistanceSquared(x, y, this.p[0].getX(), this.p[0].getY());
        }
    }

    private static final class Germs
    extends CellType {
        Point[] p = new Point[1];

        Germs() {
            super("germs");
        }

        public int getColor(int x, int y, CellularTexture texture) {
            texture.findNearest(x, y, this.p);
            int dist = texture.wrappedDistance(x, y, this.p[0].getX(), this.p[0].getY());
            return dist * dist;
        }

        public int postProcess(int c, int minValue, int maxValue) {
            return maxValue - minValue - c;
        }
    }

    private static final class Cells
    extends CellType {
        Point[] p = new Point[2];

        Cells() {
            super("cells");
        }

        public int getColor(int x, int y, CellularTexture texture) {
            texture.findNearest(x, y, this.p);
            int dist0 = texture.wrappedDistance(x, y, this.p[1].getX(), this.p[1].getY());
            int dist1 = texture.wrappedDistance(x, y, this.p[0].getX(), this.p[0].getY());
            return dist1 - dist0;
        }
    }

    private static final class Disease
    extends CellType {
        Point[] p = new Point[2];

        Disease() {
            super("disease");
        }

        public int getColor(int x, int y, CellularTexture texture) {
            texture.findNearest(x, y, this.p);
            int dist0 = texture.wrappedDistance(x, y, this.p[1].getX(), this.p[1].getY());
            int dist1 = texture.wrappedDistance(x, y, this.p[0].getX(), this.p[0].getY());
            return dist1 * dist0;
        }
    }
}

