/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.gamecommerce.shared;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.Date;
import net.puppygames.gamecommerce.shared.RegistrationDetails;

public final class GameInfo
implements Serializable {
    public static final long serialVersionUID = 1L;
    private final String game;
    private final String version;
    private final String affiliate;
    private final long installation;
    private String regCode;
    private final String display_adapter;
    private final String adapter_version;
    private String glvendor;
    private String glversion;
    private String glrenderer;
    private String gldriver;
    private final boolean crashRecovery;
    private int runtime;
    private int played;
    private String os_arch;
    private String os_version;
    private String os_name;
    private String java_version;
    private String user_country;
    private boolean webstarted;
    private String config;

    public GameInfo(String game, String version, String affiliate, long installation, boolean crashRecovery, String display_adapter, String adapter_version, String config) {
        this.game = game;
        this.version = version;
        this.affiliate = affiliate;
        this.installation = installation;
        this.crashRecovery = crashRecovery;
        this.display_adapter = display_adapter;
        this.adapter_version = adapter_version;
        this.os_name = System.getProperty("os.name");
        this.os_version = (String.valueOf(System.getProperty("os.version")) + " " + System.getProperty("sun.os.patch.level", "")).trim();
        this.os_arch = (String.valueOf(System.getProperty("os.arch")) + " " + System.getProperty("sun.cpu.isalist", "")).trim();
        this.java_version = System.getProperty("java.vm.version");
        this.user_country = System.getProperty("user.country");
        this.webstarted = !System.getProperty("jnlpx.home", "!").equals("!");
        this.config = config;
    }

    public void update(String glvendor, String glrenderer, String glversion, String gldriver, RegistrationDetails registration) {
        this.glvendor = glvendor;
        this.glrenderer = glrenderer;
        this.glversion = glversion;
        this.gldriver = gldriver;
        this.regCode = registration != null ? registration.getAuthCode() : null;
    }

    public void insertInto(Database db, String host) throws SQLException {
        db.insertGameInfo(host, this.game, this.version, this.affiliate, this.installation, this.regCode, this.display_adapter, this.adapter_version, this.glvendor, this.glrenderer, this.glversion, this.gldriver, this.crashRecovery, this.runtime, this.played, this.os_name, this.os_version, this.os_arch, this.java_version, this.user_country, this.webstarted, this.config, new java.sql.Date(new Date().getTime()));
    }

    public void addTime(int timeInSeconds) {
        this.runtime += timeInSeconds;
    }

    public void onNewGame() {
        ++this.played;
    }

    public String getGameTitle() {
        return this.game;
    }

    public String getAffiliate() {
        return this.affiliate;
    }

    public String getGameVersion() {
        return this.version;
    }

    public long getInstallation() {
        return this.installation;
    }

    public static interface Database {
        public void insertGameInfo(String var1, String var2, String var3, String var4, long var5, String var7, String var8, String var9, String var10, String var11, String var12, String var13, boolean var14, int var15, int var16, String var17, String var18, String var19, String var20, String var21, boolean var22, String var23, java.sql.Date var24) throws SQLException;
    }
}

