/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl.glu;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.glu.PixelStoreState;
import org.lwjgl.opengl.glu.Util;

public class MipMap
extends Util {
    public static int gluBuild2DMipmaps(int target, int components, int width, int height, int format, int type, ByteBuffer data) {
        int error;
        ByteBuffer image;
        int bpp;
        int h;
        int retVal = 0;
        if (width < 1 || height < 1) {
            return 100901;
        }
        int maxSize = Util.glGetIntegerv(3379);
        int w = Util.nearestPower(width);
        if (w > maxSize) {
            w = maxSize;
        }
        if ((h = Util.nearestPower(height)) > maxSize) {
            h = maxSize;
        }
        if ((bpp = Util.bytesPerPixel(format, type)) == 0) {
            return 100900;
        }
        PixelStoreState pss = new PixelStoreState();
        GL11.glPixelStorei(3330, 0);
        GL11.glPixelStorei(3333, 1);
        GL11.glPixelStorei(3331, 0);
        GL11.glPixelStorei(3332, 0);
        boolean done = false;
        if (w != width || h != height) {
            image = BufferUtils.createByteBuffer((w + 4) * h * bpp);
            error = MipMap.gluScaleImage(format, width, height, type, data, w, h, type, image);
            if (error != 0) {
                retVal = error;
                done = true;
            }
        } else {
            image = data;
        }
        int level = 0;
        while (!done) {
            ByteBuffer newimage;
            int newh;
            if (image != data) {
                GL11.glPixelStorei(3314, 0);
                GL11.glPixelStorei(3317, 1);
                GL11.glPixelStorei(3315, 0);
                GL11.glPixelStorei(3316, 0);
            }
            GL11.glTexImage2D(target, level, components, w, h, 0, format, type, image);
            if (w == 1 && h == 1) break;
            int neww = w < 2 ? 1 : w / 2;
            error = MipMap.gluScaleImage(format, w, h, type, image, neww, newh = h < 2 ? 1 : h / 2, type, newimage = BufferUtils.createByteBuffer((neww + 4) * newh * bpp));
            if (error != 0) {
                retVal = error;
                done = true;
            }
            image = newimage;
            w = neww;
            h = newh;
            ++level;
        }
        pss.save();
        return retVal;
    }

    public static int gluScaleImage(int format, int widthIn, int heightIn, int typein, ByteBuffer dataIn, int widthOut, int heightOut, int typeOut, ByteBuffer dataOut) {
        int j;
        int i;
        int k;
        int sizeout;
        int sizein;
        int components = Util.compPerPix(format);
        if (components == -1) {
            return 100900;
        }
        float[] tempin = new float[widthIn * heightIn * components];
        float[] tempout = new float[widthOut * heightOut * components];
        switch (typein) {
            case 5121: {
                sizein = 1;
                break;
            }
            default: {
                return 1280;
            }
        }
        switch (typeOut) {
            case 5121: {
                sizeout = 1;
                break;
            }
            default: {
                return 1280;
            }
        }
        PixelStoreState pss = new PixelStoreState();
        int rowlen = pss.unpackRowLength > 0 ? pss.unpackRowLength : widthIn;
        int rowstride = sizein >= pss.unpackAlignment ? components * rowlen : pss.unpackAlignment / sizein * Util.ceil(components * rowlen * sizein, pss.unpackAlignment);
        switch (typein) {
            case 5121: {
                k = 0;
                dataIn.rewind();
                i = 0;
                while (i < heightIn) {
                    int ubptr = i * rowstride + pss.unpackSkipRows * rowstride + pss.unpackSkipPixels * components;
                    j = 0;
                    while (j < widthIn * components) {
                        tempin[k++] = dataIn.get(ubptr++) & 0xFF;
                        ++j;
                    }
                    ++i;
                }
                break;
            }
            default: {
                return 100900;
            }
        }
        float sx = (float)widthIn / (float)widthOut;
        float sy = (float)heightIn / (float)heightOut;
        float[] c = new float[components];
        int iy = 0;
        while (iy < heightOut) {
            int ix = 0;
            while (ix < widthOut) {
                int src;
                int x0 = (int)((float)ix * sx);
                int x1 = (int)((float)(ix + 1) * sx);
                int y0 = (int)((float)iy * sy);
                int y1 = (int)((float)(iy + 1) * sy);
                int readPix = 0;
                int ic = 0;
                while (ic < components) {
                    c[ic] = 0.0f;
                    ++ic;
                }
                int ix0 = x0;
                while (ix0 < x1) {
                    int iy0 = y0;
                    while (iy0 < y1) {
                        src = (iy0 * widthIn + ix0) * components;
                        int ic2 = 0;
                        while (ic2 < components) {
                            int n = ic2;
                            c[n] = c[n] + tempin[src + ic2];
                            ++ic2;
                        }
                        ++readPix;
                        ++iy0;
                    }
                    ++ix0;
                }
                int dst = (iy * widthOut + ix) * components;
                if (readPix == 0) {
                    src = (y0 * widthIn + x0) * components;
                    ic = 0;
                    while (ic < components) {
                        tempout[dst++] = tempin[src + ic];
                        ++ic;
                    }
                } else {
                    k = 0;
                    while (k < components) {
                        tempout[dst++] = c[k] / (float)readPix;
                        ++k;
                    }
                }
                ++ix;
            }
            ++iy;
        }
        rowlen = pss.packRowLength > 0 ? pss.packRowLength : widthOut;
        rowstride = sizeout >= pss.packAlignment ? components * rowlen : pss.packAlignment / sizeout * Util.ceil(components * rowlen * sizeout, pss.packAlignment);
        switch (typeOut) {
            case 5121: {
                k = 0;
                i = 0;
                while (i < heightOut) {
                    int ubptr = i * rowstride + pss.packSkipRows * rowstride + pss.packSkipPixels * components;
                    j = 0;
                    while (j < widthOut * components) {
                        dataOut.put(ubptr++, (byte)tempout[k++]);
                        ++j;
                    }
                    ++i;
                }
                break;
            }
            default: {
                return 100900;
            }
        }
        return 0;
    }
}

