/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.BufferChecks;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.BufferObjectTracker;

public final class GL15 {
    public static final int GL_ARRAY_BUFFER = 34962;
    public static final int GL_ELEMENT_ARRAY_BUFFER = 34963;
    public static final int GL_ARRAY_BUFFER_BINDING = 34964;
    public static final int GL_ELEMENT_ARRAY_BUFFER_BINDING = 34965;
    public static final int GL_VERTEX_ARRAY_BUFFER_BINDING = 34966;
    public static final int GL_NORMAL_ARRAY_BUFFER_BINDING = 34967;
    public static final int GL_COLOR_ARRAY_BUFFER_BINDING = 34968;
    public static final int GL_INDEX_ARRAY_BUFFER_BINDING = 34969;
    public static final int GL_TEXTURE_COORD_ARRAY_BUFFER_BINDING = 34970;
    public static final int GL_EDGE_FLAG_ARRAY_BUFFER_BINDING = 34971;
    public static final int GL_SECONDARY_COLOR_ARRAY_BUFFER_BINDING = 34972;
    public static final int GL_FOG_COORDINATE_ARRAY_BUFFER_BINDING = 34973;
    public static final int GL_WEIGHT_ARRAY_BUFFER_BINDING = 34974;
    public static final int GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING = 34975;
    public static final int GL_STREAM_DRAW = 35040;
    public static final int GL_STREAM_READ = 35041;
    public static final int GL_STREAM_COPY = 35042;
    public static final int GL_STATIC_DRAW = 35044;
    public static final int GL_STATIC_READ = 35045;
    public static final int GL_STATIC_COPY = 35046;
    public static final int GL_DYNAMIC_DRAW = 35048;
    public static final int GL_DYNAMIC_READ = 35049;
    public static final int GL_DYNAMIC_COPY = 35050;
    public static final int GL_READ_ONLY = 35000;
    public static final int GL_WRITE_ONLY = 35001;
    public static final int GL_READ_WRITE = 35002;
    public static final int GL_BUFFER_SIZE = 34660;
    public static final int GL_BUFFER_USAGE = 34661;
    public static final int GL_BUFFER_ACCESS = 35003;
    public static final int GL_BUFFER_MAPPED = 35004;
    public static final int GL_BUFFER_MAP_POINTER = 35005;
    public static final int GL_SAMPLES_PASSED = 35092;
    public static final int GL_QUERY_COUNTER_BITS = 34916;
    public static final int GL_CURRENT_QUERY = 34917;
    public static final int GL_QUERY_RESULT = 34918;
    public static final int GL_QUERY_RESULT_AVAILABLE = 34919;

    private GL15() {
    }

    static native void initNativeStubs() throws LWJGLException;

    public static void glBindBuffer(int target, int buffer) {
        switch (target) {
            case 34963: {
                BufferObjectTracker.getVBOElementStack().setState(buffer);
                break;
            }
            case 34962: {
                BufferObjectTracker.getVBOArrayStack().setState(buffer);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported VBO target " + target);
            }
        }
        GL15.nglBindBuffer(target, buffer);
    }

    private static native void nglBindBuffer(int var0, int var1);

    public static void glDeleteBuffers(IntBuffer buffers) {
        BufferChecks.checkDirect(buffers);
        int i = buffers.position();
        while (i < buffers.limit()) {
            int buffer_handle = buffers.get(i);
            if (BufferObjectTracker.getVBOElementStack().getState() == buffer_handle) {
                BufferObjectTracker.getVBOElementStack().setState(0);
            }
            if (BufferObjectTracker.getVBOArrayStack().getState() == buffer_handle) {
                BufferObjectTracker.getVBOArrayStack().setState(0);
            }
            ++i;
        }
        GL15.nglDeleteBuffers(buffers.remaining(), buffers, buffers.position());
    }

    private static native void nglDeleteBuffers(int var0, IntBuffer var1, int var2);

    public static void glGenBuffers(IntBuffer buffers) {
        BufferChecks.checkDirect(buffers);
        GL15.nglGenBuffers(buffers.remaining(), buffers, buffers.position());
    }

    private static native void nglGenBuffers(int var0, IntBuffer var1, int var2);

    public static native boolean glIsBuffer(int var0);

    public static void glBufferData(int target, int size, ByteBuffer data, int usage) {
        BufferChecks.checkDirectOrNull(data);
        GL15.nglBufferData(target, data != null ? data.remaining() : size, data, data != null ? data.position() : 0, usage);
    }

    public static void glBufferData(int target, int size, ShortBuffer data, int usage) {
        BufferChecks.checkDirectOrNull(data);
        GL15.nglBufferData(target, data != null ? data.remaining() << 1 : size, data, data != null ? data.position() << 1 : 0, usage);
    }

    public static void glBufferData(int target, int size, FloatBuffer data, int usage) {
        BufferChecks.checkDirectOrNull(data);
        GL15.nglBufferData(target, data != null ? data.remaining() << 2 : size, data, data != null ? data.position() << 2 : 0, usage);
    }

    public static void glBufferData(int target, int size, IntBuffer data, int usage) {
        BufferChecks.checkDirectOrNull(data);
        GL15.nglBufferData(target, data != null ? data.remaining() << 2 : size, data, data != null ? data.position() << 2 : 0, usage);
    }

    private static native void nglBufferData(int var0, int var1, Buffer var2, int var3, int var4);

    public static void glBufferSubData(int target, int offset, ByteBuffer data) {
        BufferChecks.checkDirect(data);
        GL15.nglBufferSubData(target, offset, data.remaining(), data, data.position());
    }

    public static void glBufferSubData(int target, int offset, ShortBuffer data) {
        BufferChecks.checkDirect(data);
        GL15.nglBufferSubData(target, offset, data.remaining() << 1, data, data.position() << 1);
    }

    public static void glBufferSubData(int target, int offset, FloatBuffer data) {
        BufferChecks.checkDirect(data);
        GL15.nglBufferSubData(target, offset, data.remaining() << 2, data, data.position() << 2);
    }

    public static void glBufferSubData(int target, int offset, IntBuffer data) {
        BufferChecks.checkDirect(data);
        GL15.nglBufferSubData(target, offset, data.remaining() << 2, data, data.position() << 2);
    }

    private static native void nglBufferSubData(int var0, int var1, int var2, Buffer var3, int var4);

    public static void glGetBufferSubData(int target, int offset, ByteBuffer data) {
        BufferChecks.checkDirect(data);
        GL15.nglGetBufferSubData(target, offset, data.remaining(), data, data.position());
    }

    public static void glGetBufferSubData(int target, int offset, ShortBuffer data) {
        BufferChecks.checkDirect(data);
        GL15.nglGetBufferSubData(target, offset, data.remaining() << 1, data, data.position() << 1);
    }

    public static void glGetBufferSubData(int target, int offset, IntBuffer data) {
        BufferChecks.checkDirect(data);
        GL15.nglGetBufferSubData(target, offset, data.remaining() << 2, data, data.position() << 2);
    }

    public static void glGetBufferSubData(int target, int offset, FloatBuffer data) {
        BufferChecks.checkDirect(data);
        GL15.nglGetBufferSubData(target, offset, data.remaining() << 2, data, data.position() << 2);
    }

    private static native void nglGetBufferSubData(int var0, int var1, int var2, Buffer var3, int var4);

    public static native ByteBuffer glMapBuffer(int var0, int var1, int var2, ByteBuffer var3);

    public static native boolean glUnmapBuffer(int var0);

    public static void glGetBufferParameter(int target, int pname, IntBuffer params) {
        BufferChecks.checkBuffer(params);
        GL15.nglGetBufferParameteriv(target, pname, params, params.position());
    }

    private static native void nglGetBufferParameteriv(int var0, int var1, IntBuffer var2, int var3);

    public static native ByteBuffer glGetBufferPointer(int var0, int var1, int var2);

    public static void glGenQueries(IntBuffer ids) {
        BufferChecks.checkDirect(ids);
        GL15.nglGenQueries(ids.remaining(), ids, ids.position());
    }

    private static native void nglGenQueries(int var0, IntBuffer var1, int var2);

    public static void glDeleteQueries(IntBuffer ids) {
        BufferChecks.checkDirect(ids);
        GL15.nglDeleteQueries(ids.remaining(), ids, ids.position());
    }

    private static native void nglDeleteQueries(int var0, IntBuffer var1, int var2);

    public static native boolean glIsQuery(int var0);

    public static native void glBeginQuery(int var0, int var1);

    public static native void glEndQuery(int var0);

    public static void glGetQuery(int target, int pname, IntBuffer params) {
        BufferChecks.checkDirect(params);
        GL15.nglGetQueryiv(target, pname, params, params.position());
    }

    private static native void nglGetQueryiv(int var0, int var1, IntBuffer var2, int var3);

    public static void glGetQueryObject(int id, int pname, IntBuffer params) {
        BufferChecks.checkBuffer(params);
        GL15.nglGetQueryObjectiv(id, pname, params, params.position());
    }

    private static native void nglGetQueryObjectiv(int var0, int var1, IntBuffer var2, int var3);

    public static void glGetQueryObjectu(int id, int pname, IntBuffer params) {
        BufferChecks.checkBuffer(params);
        GL15.nglGetQueryObjectuiv(id, pname, params, params.position());
    }

    private static native void nglGetQueryObjectuiv(int var0, int var1, IntBuffer var2, int var3);
}

