/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.BufferChecks;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.GLBufferChecks;

public final class GL12 {
    public static final int GL_TABLE_TOO_LARGE = 32817;
    public static final int GL_PACK_SKIP_IMAGES = 32875;
    public static final int GL_PACK_IMAGE_HEIGHT = 32876;
    public static final int GL_UNPACK_SKIP_IMAGES = 32877;
    public static final int GL_UNPACK_IMAGE_HEIGHT = 32878;
    public static final int GL_TEXTURE_3D = 32879;
    public static final int GL_PROXY_TEXTURE_3D = 32880;
    public static final int GL_TEXTURE_DEPTH = 32881;
    public static final int GL_TEXTURE_WRAP_R = 32882;
    public static final int GL_MAX_3D_TEXTURE_SIZE = 32883;
    public static final int GL_BGR = 32992;
    public static final int GL_BGRA = 32993;
    public static final int GL_UNSIGNED_BYTE_3_3_2 = 32818;
    public static final int GL_UNSIGNED_BYTE_2_3_3_REV = 33634;
    public static final int GL_UNSIGNED_SHORT_5_6_5 = 33635;
    public static final int GL_UNSIGNED_SHORT_5_6_5_REV = 33636;
    public static final int GL_UNSIGNED_SHORT_4_4_4_4 = 32819;
    public static final int GL_UNSIGNED_SHORT_4_4_4_4_REV = 33637;
    public static final int GL_UNSIGNED_SHORT_5_5_5_1 = 32820;
    public static final int GL_UNSIGNED_SHORT_1_5_5_5_REV = 33638;
    public static final int GL_UNSIGNED_INT_8_8_8_8 = 32821;
    public static final int GL_UNSIGNED_INT_8_8_8_8_REV = 33639;
    public static final int GL_UNSIGNED_INT_10_10_10_2 = 32822;
    public static final int GL_UNSIGNED_INT_2_10_10_10_REV = 33640;
    public static final int GL_RESCALE_NORMAL = 32826;
    public static final int GL_LIGHT_MODEL_COLOR_CONTROL = 33272;
    public static final int GL_SINGLE_COLOR = 33273;
    public static final int GL_SEPARATE_SPECULAR_COLOR = 33274;
    public static final int GL_CLAMP_TO_EDGE = 33071;
    public static final int GL_TEXTURE_MIN_LOD = 33082;
    public static final int GL_TEXTURE_MAX_LOD = 33083;
    public static final int GL_TEXTURE_BASE_LEVEL = 33084;
    public static final int GL_TEXTURE_MAX_LEVEL = 33085;
    public static final int GL_MAX_ELEMENTS_VERTICES = 33000;
    public static final int GL_MAX_ELEMENTS_INDICES = 33001;
    public static final int GL_ALIASED_POINT_SIZE_RANGE = 33901;
    public static final int GL_ALIASED_LINE_WIDTH_RANGE = 33902;

    private GL12() {
    }

    static native void initNativeStubs() throws LWJGLException;

    public static void glDrawRangeElements(int mode, int start, int end, ByteBuffer indices) {
        BufferChecks.checkDirect(indices);
        GLBufferChecks.ensureElementVBOdisabled();
        GL12.nglDrawRangeElements(mode, start, end, indices.remaining(), 5121, indices, indices.position());
    }

    public static void glDrawRangeElements(int mode, int start, int end, ShortBuffer indices) {
        BufferChecks.checkDirect(indices);
        GLBufferChecks.ensureElementVBOdisabled();
        GL12.nglDrawRangeElements(mode, start, end, indices.remaining(), 5123, indices, indices.position() << 1);
    }

    public static void glDrawRangeElements(int mode, int start, int end, IntBuffer indices) {
        BufferChecks.checkDirect(indices);
        GLBufferChecks.ensureElementVBOdisabled();
        GL12.nglDrawRangeElements(mode, start, end, indices.remaining(), 5125, indices, indices.position() << 2);
    }

    private static native void nglDrawRangeElements(int var0, int var1, int var2, int var3, int var4, Buffer var5, int var6);

    public static void glDrawRangeElements(int mode, int start, int end, int count, int type, int buffer_offset) {
        GLBufferChecks.ensureElementVBOenabled();
        GL12.nglDrawRangeElementsVBO(mode, start, end, count, type, buffer_offset);
    }

    private static native void nglDrawRangeElementsVBO(int var0, int var1, int var2, int var3, int var4, int var5);

    public static void glTexImage3D(int target, int level, int internalFormat, int width, int height, int depth, int border, int format, int type, ByteBuffer pixels) {
        GLBufferChecks.ensureUnpackPBOdisabled();
        if (pixels != null) {
            BufferChecks.checkBuffer(pixels, GLBufferChecks.calculateTexImage3DStorage(format, type, width, height, depth, border));
        }
        GL12.nglTexImage3D(target, level, internalFormat, width, height, depth, border, format, type, pixels, pixels != null ? pixels.position() : 0);
    }

    public static void glTexImage3D(int target, int level, int internalFormat, int width, int height, int depth, int border, int format, int type, ShortBuffer pixels) {
        GLBufferChecks.ensureUnpackPBOdisabled();
        if (pixels != null) {
            BufferChecks.checkBuffer(pixels, GLBufferChecks.calculateTexImage3DStorage(format, type, width, height, depth, border) >> 1);
        }
        GL12.nglTexImage3D(target, level, internalFormat, width, height, depth, border, format, type, pixels, pixels != null ? pixels.position() << 1 : 0);
    }

    public static void glTexImage3D(int target, int level, int internalFormat, int width, int height, int depth, int border, int format, int type, IntBuffer pixels) {
        GLBufferChecks.ensureUnpackPBOdisabled();
        if (pixels != null) {
            BufferChecks.checkBuffer(pixels, GLBufferChecks.calculateTexImage3DStorage(format, type, width, height, depth, border) >> 2);
        }
        GL12.nglTexImage3D(target, level, internalFormat, width, height, depth, border, format, type, pixels, pixels != null ? pixels.position() << 2 : 0);
    }

    public static void glTexImage3D(int target, int level, int internalFormat, int width, int height, int depth, int border, int format, int type, FloatBuffer pixels) {
        GLBufferChecks.ensureUnpackPBOdisabled();
        if (pixels != null) {
            BufferChecks.checkBuffer(pixels, GLBufferChecks.calculateTexImage3DStorage(format, type, width, height, depth, border) >> 2);
        }
        GL12.nglTexImage3D(target, level, internalFormat, width, height, depth, border, format, type, pixels, pixels != null ? pixels.position() << 2 : 0);
    }

    private static native void nglTexImage3D(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, Buffer var9, int var10);

    public static void glTexImage3D(int target, int level, int internalFormat, int width, int height, int depth, int border, int format, int type, int buffer_offset) {
        GLBufferChecks.ensureUnpackPBOenabled();
        GL12.nglTexImage3DBO(target, level, internalFormat, width, height, depth, border, format, type, buffer_offset);
    }

    private static native void nglTexImage3DBO(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9);

    public static void glTexSubImage3D(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, ByteBuffer pixels) {
        GLBufferChecks.ensureUnpackPBOdisabled();
        BufferChecks.checkBuffer(pixels, GLBufferChecks.calculateImageStorage(format, type, width, height, depth));
        GL12.nglTexSubImage3D(target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels, pixels.position());
    }

    public static void glTexSubImage3D(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, ShortBuffer pixels) {
        GLBufferChecks.ensureUnpackPBOdisabled();
        BufferChecks.checkBuffer(pixels, GLBufferChecks.calculateImageStorage(format, type, width, height, depth) >> 1);
        GL12.nglTexSubImage3D(target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels, pixels.position() << 1);
    }

    public static void glTexSubImage3D(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, IntBuffer pixels) {
        GLBufferChecks.ensureUnpackPBOdisabled();
        BufferChecks.checkBuffer(pixels, GLBufferChecks.calculateImageStorage(format, type, width, height, depth) >> 2);
        GL12.nglTexSubImage3D(target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels, pixels.position() << 2);
    }

    public static void glTexSubImage3D(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, FloatBuffer pixels) {
        GLBufferChecks.ensureUnpackPBOdisabled();
        BufferChecks.checkBuffer(pixels, GLBufferChecks.calculateImageStorage(format, type, width, height, depth) >> 2);
        GL12.nglTexSubImage3D(target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels, pixels.position() << 2);
    }

    private static native void nglTexSubImage3D(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, Buffer var10, int var11);

    public static void glTexSubImage3D(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, int buffer_offset) {
        GLBufferChecks.ensureUnpackPBOenabled();
        GL12.nglTexSubImage3DBO(target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, buffer_offset);
    }

    private static native void nglTexSubImage3DBO(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10);

    public static native void glCopyTexSubImage3D(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8);
}

