/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.util.Map;
import java.util.WeakHashMap;
import org.lwjgl.opengl.StateStack;
import org.lwjgl.opengl.Util;

final class BufferObjectTracker {
    private static BufferObjectTracker current_tracker;
    private static final Map contextToTracker;
    private final StateStack vbo_array_stack;
    private final StateStack vbo_element_stack;
    private final StateStack pbo_pack_stack;
    private final StateStack pbo_unpack_stack;
    private final StateStack attrib_stack;

    static {
        contextToTracker = new WeakHashMap(3, 1.0f);
    }

    private BufferObjectTracker() {
        int stack_size = Math.max(1, Util.glGetInteger(3387));
        this.vbo_array_stack = new StateStack(stack_size, 0);
        this.vbo_element_stack = new StateStack(stack_size, 0);
        this.pbo_pack_stack = new StateStack(stack_size, 0);
        this.pbo_unpack_stack = new StateStack(stack_size, 0);
        this.attrib_stack = new StateStack(stack_size, 0);
    }

    static StateStack getVBOArrayStack() {
        return BufferObjectTracker.current_tracker.vbo_array_stack;
    }

    static StateStack getVBOElementStack() {
        return BufferObjectTracker.current_tracker.vbo_element_stack;
    }

    static StateStack getPBOPackStack() {
        return BufferObjectTracker.current_tracker.pbo_pack_stack;
    }

    static StateStack getPBOUnpackStack() {
        return BufferObjectTracker.current_tracker.pbo_unpack_stack;
    }

    static StateStack getClientAttribStack() {
        return BufferObjectTracker.current_tracker.attrib_stack;
    }

    static void setCurrent(Object context) {
        if (context == null) {
            current_tracker = null;
            return;
        }
        current_tracker = (BufferObjectTracker)contextToTracker.get(context);
        if (current_tracker == null) {
            current_tracker = new BufferObjectTracker();
            contextToTracker.put(context, current_tracker);
        }
    }
}

